/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicInputRenderer;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectBoolean;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;

public class CheckboxRenderer
extends HtmlBasicInputRenderer {
    private static final String[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.SELECTBOOLEANCHECKBOX);

    public void decode(FacesContext context, UIComponent component) {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldDecode(component)) {
            return;
        }
        String clientId = component.getClientId(context);
        assert (clientId != null);
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String isChecked = CheckboxRenderer.isChecked((String)requestParameterMap.get(clientId));
        this.setSubmittedValue(component, isChecked);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "new value after decoding: {0}", isChecked);
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        String newValue = (String)submittedValue;
        return Boolean.valueOf(newValue);
    }

    protected void getEndTextToRender(FacesContext context, UIComponent component, String currentValue) throws IOException {
        String styleClass;
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        writer.startElement("input", component);
        this.writeIdAttributeIfNecessary(context, writer, component);
        writer.writeAttribute("type", (Object)"checkbox", "type");
        writer.writeAttribute("name", (Object)component.getClientId(context), "clientId");
        if (((UISelectBoolean)component).isSelected()) {
            writer.writeAttribute("checked", (Object)Boolean.TRUE, "value");
        }
        if (null != (styleClass = (String)component.getAttributes().get("styleClass"))) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        RenderKitUtils.renderPassThruAttributes(writer, component, ATTRIBUTES);
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(writer, component);
        RenderKitUtils.renderOnchange(context, component);
        writer.endElement("input");
    }

    private static String isChecked(String value) {
        return Boolean.toString("on".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value));
    }
}

