/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.converter;

import java.math.BigDecimal;
import java.math.MathContext;
import javax.measure.converter.LinearConverter;
import javax.measure.converter.UnitConverter;

public final class MultiplyConverter
extends LinearConverter {
    private final double _factor;
    private static final long serialVersionUID = 1L;

    public MultiplyConverter(double factor) {
        if (factor == 1.0) {
            throw new IllegalArgumentException("Would result in identity converter");
        }
        this._factor = factor;
    }

    public double getFactor() {
        return this._factor;
    }

    public UnitConverter concatenate(UnitConverter converter) {
        if (converter instanceof MultiplyConverter) {
            double factor = this._factor * ((MultiplyConverter)converter)._factor;
            return factor == 1.0 ? IDENTITY : new MultiplyConverter(factor);
        }
        return super.concatenate(converter);
    }

    public MultiplyConverter inverse() {
        return new MultiplyConverter(1.0 / this._factor);
    }

    public double convert(double value) {
        return value * this._factor;
    }

    public BigDecimal convert(BigDecimal value, MathContext ctx) throws ArithmeticException {
        return value.multiply(BigDecimal.valueOf(this._factor), ctx);
    }

    public final String toString() {
        return "MultiplyConverter(" + this._factor + ")";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MultiplyConverter)) {
            return false;
        }
        MultiplyConverter that = (MultiplyConverter)obj;
        return this._factor == that._factor;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this._factor);
        return (int)(bits ^ bits >>> 32);
    }
}

