/*
 * Decompiled with CFR 0.152.
 */
package javax.money.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.spi.ServiceProvider;

class DefaultServiceProvider
implements ServiceProvider {
    private final ConcurrentHashMap<Class<?>, List<Object>> servicesLoaded = new ConcurrentHashMap();

    DefaultServiceProvider() {
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public <T> List<T> getServices(Class<T> serviceType) {
        List<Object> found = this.servicesLoaded.get(serviceType);
        if (found != null) {
            return found;
        }
        return this.loadServices(serviceType);
    }

    private <T> List<T> loadServices(Class<T> serviceType) {
        ArrayList<Object> services = new ArrayList<Object>();
        try {
            for (T t : ServiceLoader.load(serviceType)) {
                services.add(t);
            }
            services.sort(Comparator.comparing(o -> o.getClass().getSimpleName()));
            ArrayList<Object> previousServices = this.servicesLoaded.putIfAbsent(serviceType, services);
            return Collections.unmodifiableList(previousServices != null ? previousServices : services);
        }
        catch (Exception e) {
            Logger.getLogger(DefaultServiceProvider.class.getName()).log(Level.WARNING, "Error loading services of type " + serviceType, e);
            return services;
        }
    }
}

