/*
 * Decompiled with CFR 0.152.
 */
package javax.money.spi;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.money.CurrencyQuery;
import javax.money.CurrencyQueryBuilder;
import javax.money.CurrencyUnit;
import javax.money.MonetaryException;
import javax.money.UnknownCurrencyException;

public interface MonetaryCurrenciesSingletonSpi {
    public List<String> getDefaultProviderChain();

    public Set<String> getProviderNames();

    public Set<CurrencyUnit> getCurrencies(CurrencyQuery var1);

    default public CurrencyUnit getCurrency(String currencyCode, String ... providers) {
        Objects.requireNonNull(currencyCode, "Currency Code may not be null");
        Set<CurrencyUnit> found = this.getCurrencies(((CurrencyQueryBuilder)CurrencyQueryBuilder.of().setCurrencyCodes(currencyCode).setProviderNames(providers)).build());
        if (found.isEmpty()) {
            throw new UnknownCurrencyException(currencyCode);
        }
        if (found.size() > 1) {
            throw new MonetaryException("Ambiguous CurrencyUnit for code: " + currencyCode + ": " + found);
        }
        return (CurrencyUnit)found.iterator().next();
    }

    default public CurrencyUnit getCurrency(Locale country, String ... providers) {
        Set<CurrencyUnit> found = this.getCurrencies(((CurrencyQueryBuilder)CurrencyQueryBuilder.of().setCountries(country).setProviderNames(providers)).build());
        if (found.isEmpty()) {
            throw new MonetaryException("No currency unit found for locale: " + country);
        }
        if (found.size() > 1) {
            throw new MonetaryException("Ambiguous CurrencyUnit for locale: " + country + ": " + found);
        }
        return (CurrencyUnit)found.iterator().next();
    }

    default public Set<CurrencyUnit> getCurrencies(Locale locale, String ... providers) {
        return this.getCurrencies(((CurrencyQueryBuilder)CurrencyQueryBuilder.of().setCountries(locale).setProviderNames(providers)).build());
    }

    default public boolean isCurrencyAvailable(String code, String ... providers) {
        return !this.getCurrencies(((CurrencyQueryBuilder)CurrencyQueryBuilder.of().setCurrencyCodes(code).setProviderNames(providers)).build()).isEmpty();
    }

    default public boolean isCurrencyAvailable(Locale locale, String ... providers) {
        return !this.getCurrencies(((CurrencyQueryBuilder)CurrencyQueryBuilder.of().setCountries(locale).setProviderNames(providers)).build()).isEmpty();
    }

    default public Set<CurrencyUnit> getCurrencies(String ... providers) {
        return this.getCurrencies(((CurrencyQueryBuilder)CurrencyQueryBuilder.of().setProviderNames(providers)).build());
    }

    default public CurrencyUnit getCurrency(CurrencyQuery query) {
        Set<CurrencyUnit> currencies = this.getCurrencies(query);
        if (currencies.isEmpty()) {
            throw new MonetaryException("CurrencyUnit not found: " + query);
        }
        if (currencies.size() == 1) {
            return currencies.iterator().next();
        }
        throw new MonetaryException("Ambiguous request for CurrencyUnit: " + query + ", found: " + currencies);
    }
}

