/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import javax.time.calendar.DateAdjuster;
import javax.time.calendar.DayOfWeek;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.LocalDate;
import javax.time.calendar.MonthOfYear;

public final class DateAdjusters {
    private DateAdjusters() {
    }

    public static DateAdjuster lastDayOfMonth() {
        return Impl.LAST_DAY_OF_MONTH;
    }

    public static DateAdjuster lastDayOfYear() {
        return Impl.LAST_DAY_OF_YEAR;
    }

    public static DateAdjuster nextNonWeekendDay() {
        return Impl.NEXT_NON_WEEKEND;
    }

    public static DateAdjuster firstInMonth(DayOfWeek dayOfWeek) {
        if (dayOfWeek == null) {
            throw new NullPointerException("DayOfWeek must not be null");
        }
        return new DayOfWeekInMonth(1, dayOfWeek);
    }

    public static DateAdjuster dayOfWeekInMonth(int ordinal, DayOfWeek dayOfWeek) {
        if (ordinal < 1 || ordinal > 5) {
            throw new IllegalArgumentException("Illegal value for ordinal, value " + ordinal + " is not in the range 1 to 5");
        }
        if (dayOfWeek == null) {
            throw new NullPointerException("DayOfWeek must not be null");
        }
        return new DayOfWeekInMonth(ordinal, dayOfWeek);
    }

    public static DateAdjuster next(DayOfWeek dow) {
        if (dow == null) {
            throw new NullPointerException("dow must not be null");
        }
        return new RelativeDayOfWeek(2, dow);
    }

    public static DateAdjuster nextOrCurrent(DayOfWeek dow) {
        if (dow == null) {
            throw new NullPointerException("dow must not be null");
        }
        return new RelativeDayOfWeek(0, dow);
    }

    public static DateAdjuster previous(DayOfWeek dow) {
        if (dow == null) {
            throw new NullPointerException("dow must not be null");
        }
        return new RelativeDayOfWeek(3, dow);
    }

    public static DateAdjuster previousOrCurrent(DayOfWeek dow) {
        if (dow == null) {
            throw new NullPointerException("dow must not be null");
        }
        return new RelativeDayOfWeek(1, dow);
    }

    private static final class RelativeDayOfWeek
    implements DateAdjuster,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final int relative;
        private final DayOfWeek dow;

        private RelativeDayOfWeek(int relative, DayOfWeek dow) {
            this.relative = relative;
            this.dow = dow;
        }

        @Override
        public LocalDate adjustDate(LocalDate date) {
            DayOfWeek dow = date.getDayOfWeek();
            if (this.relative < 2 && dow == this.dow) {
                return date;
            }
            if ((this.relative & 1) == 0) {
                int daysDiff = dow.ordinal() - this.dow.ordinal();
                return date.plusDays(daysDiff >= 0 ? (long)(7 - daysDiff) : (long)(-daysDiff));
            }
            int daysDiff = this.dow.ordinal() - dow.ordinal();
            return date.minusDays(daysDiff >= 0 ? (long)(7 - daysDiff) : (long)(-daysDiff));
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RelativeDayOfWeek)) {
                return false;
            }
            RelativeDayOfWeek other = (RelativeDayOfWeek)obj;
            if (this.relative != other.relative) {
                return false;
            }
            return this.dow == other.dow;
        }

        public int hashCode() {
            int hash = 13;
            hash = 19 * hash + this.relative;
            hash = 19 * hash + this.dow.hashCode();
            return hash;
        }
    }

    private static final class DayOfWeekInMonth
    implements DateAdjuster,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final int ordinal;
        private final DayOfWeek dayOfWeek;

        private DayOfWeekInMonth(int ordinal, DayOfWeek dayOfWeek) {
            this.ordinal = ordinal;
            this.dayOfWeek = dayOfWeek;
        }

        @Override
        public LocalDate adjustDate(LocalDate date) {
            LocalDate temp = date.withDayOfMonth(1);
            int curDow = temp.getDayOfWeek().ordinal();
            int newDow = this.dayOfWeek.ordinal();
            int dowDiff = (newDow - curDow + 7) % 7;
            return temp.plusDays(dowDiff += (this.ordinal - 1) * 7);
        }

        public boolean equals(Object obj) {
            if (obj instanceof DayOfWeekInMonth) {
                DayOfWeekInMonth other = (DayOfWeekInMonth)obj;
                return this.ordinal == other.ordinal && this.dayOfWeek == other.dayOfWeek;
            }
            return false;
        }

        public int hashCode() {
            return this.ordinal + 8 * this.dayOfWeek.ordinal();
        }
    }

    private static enum Impl implements DateAdjuster
    {
        LAST_DAY_OF_MONTH{

            @Override
            public LocalDate adjustDate(LocalDate date) {
                int dom = date.getMonthOfYear().getLastDayOfMonth(ISOChronology.isLeapYear(date.getYear()));
                return date.withDayOfMonth(dom);
            }
        }
        ,
        LAST_DAY_OF_YEAR{

            @Override
            public LocalDate adjustDate(LocalDate date) {
                return LocalDate.of(date.getYear(), MonthOfYear.DECEMBER, 31);
            }
        }
        ,
        NEXT_NON_WEEKEND{

            @Override
            public LocalDate adjustDate(LocalDate date) {
                DayOfWeek dow = date.getDayOfWeek();
                switch (dow) {
                    case SATURDAY: {
                        return date.plusDays(2L);
                    }
                    case FRIDAY: {
                        return date.plusDays(3L);
                    }
                }
                return date.plusDays(1L);
            }
        };

    }
}

