/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalMatcher;
import javax.time.calendar.CalendricalRule;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.UnsupportedRuleException;

public final class DateTimeFields
implements Calendrical,
CalendricalMatcher,
Iterable<DateTimeFieldRule<?>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final DateTimeFields EMPTY = new DateTimeFields(DateTimeFields.createMap());
    private final TreeMap<DateTimeFieldRule<?>, Integer> fieldValueMap;

    public static DateTimeFields fields() {
        return EMPTY;
    }

    public static DateTimeFields fields(DateTimeFieldRule<?> fieldRule, int value) {
        ISOChronology.checkNotNull(fieldRule, "DateTimeFieldRule must not be null");
        fieldRule.checkValue(value);
        TreeMap<DateTimeFieldRule<?>, Integer> map = DateTimeFields.createMap();
        map.put(fieldRule, value);
        return new DateTimeFields(map);
    }

    public static DateTimeFields fields(DateTimeFieldRule<?> fieldRule1, int value1, DateTimeFieldRule<?> fieldRule2, int value2) {
        ISOChronology.checkNotNull(fieldRule1, "First DateTimeFieldRule must not be null");
        ISOChronology.checkNotNull(fieldRule2, "Second DateTimeFieldRule must not be null");
        fieldRule1.checkValue(value1);
        fieldRule2.checkValue(value2);
        TreeMap<DateTimeFieldRule<?>, Integer> map = DateTimeFields.createMap();
        map.put(fieldRule1, value1);
        map.put(fieldRule2, value2);
        return new DateTimeFields(map);
    }

    public static DateTimeFields fields(Map<DateTimeFieldRule<?>, Integer> fieldValueMap) {
        ISOChronology.checkNotNull(fieldValueMap, "Field-value map must not be null");
        if (fieldValueMap.isEmpty()) {
            return EMPTY;
        }
        TreeMap<DateTimeFieldRule<?>, Integer> map = DateTimeFields.createMap();
        for (Map.Entry<DateTimeFieldRule<?>, Integer> entry : fieldValueMap.entrySet()) {
            DateTimeFieldRule<?> fieldRule = entry.getKey();
            Integer value = entry.getValue();
            ISOChronology.checkNotNull(fieldRule, "Null keys are not permitted in field-value map");
            ISOChronology.checkNotNull(value, "Null values are not permitted in field-value map");
            fieldRule.checkValue(value);
            map.put(fieldRule, value);
        }
        return new DateTimeFields(map);
    }

    private static TreeMap<DateTimeFieldRule<?>, Integer> createMap() {
        return new TreeMap(Collections.reverseOrder());
    }

    private DateTimeFields(TreeMap<DateTimeFieldRule<?>, Integer> assignedMap) {
        this.fieldValueMap = assignedMap;
    }

    private Object readResolve() throws ObjectStreamException {
        return this.fieldValueMap.isEmpty() ? EMPTY : this;
    }

    public int size() {
        return this.fieldValueMap.size();
    }

    @Override
    public Iterator<DateTimeFieldRule<?>> iterator() {
        return this.fieldValueMap.keySet().iterator();
    }

    public boolean contains(DateTimeFieldRule<?> fieldRule) {
        return fieldRule != null && this.fieldValueMap.containsKey(fieldRule);
    }

    @Override
    public <T> T get(CalendricalRule<T> rule) {
        Integer value;
        ISOChronology.checkNotNull(rule, "CalendricalRule must not be null");
        if (rule instanceof DateTimeFieldRule && (value = this.fieldValueMap.get(rule)) != null) {
            DateTimeFieldRule r = (DateTimeFieldRule)rule;
            return r.convertIntToValue(value);
        }
        return rule.deriveValueFrom(this);
    }

    public int getInt(DateTimeFieldRule<?> rule) {
        ISOChronology.checkNotNull(rule, "DateTimeFieldRule must not be null");
        Integer value = this.fieldValueMap.get(rule);
        if (value == null) {
            throw new UnsupportedRuleException(rule);
        }
        return value;
    }

    public Integer getQuiet(DateTimeFieldRule<?> fieldRule) {
        return fieldRule == null ? null : this.fieldValueMap.get(fieldRule);
    }

    public DateTimeFields with(DateTimeFieldRule<?> fieldRule, int value) {
        ISOChronology.checkNotNull(fieldRule, "DateTimeFieldRule must not be null");
        fieldRule.checkValue(value);
        TreeMap<DateTimeFieldRule<?>, Integer> clonedMap = this.clonedMap();
        clonedMap.put(fieldRule, value);
        return new DateTimeFields(clonedMap);
    }

    public DateTimeFields with(DateTimeFields fields) {
        ISOChronology.checkNotNull(fields, "DateTimeFields must not be null");
        if (fields.size() == 0 || fields == this) {
            return this;
        }
        TreeMap<DateTimeFieldRule<?>, Integer> clonedMap = this.clonedMap();
        clonedMap.putAll(fields.fieldValueMap);
        return new DateTimeFields(clonedMap);
    }

    public DateTimeFields withFieldRemoved(DateTimeFieldRule<?> fieldRule) {
        ISOChronology.checkNotNull(fieldRule, "DateTimeFieldRule must not be null");
        TreeMap<DateTimeFieldRule<?>, Integer> clonedMap = this.clonedMap();
        if (clonedMap.remove(fieldRule) == null) {
            return this;
        }
        return clonedMap.isEmpty() ? EMPTY : new DateTimeFields(clonedMap);
    }

    @Override
    public boolean matchesCalendrical(Calendrical calendrical) {
        ISOChronology.checkNotNull(calendrical, "Calendrical must not be null");
        for (Map.Entry<DateTimeFieldRule<?>, Integer> entry : this.fieldValueMap.entrySet()) {
            Integer dateValue = entry.getKey().getInteger(calendrical);
            if (dateValue == null || dateValue.equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public SortedMap<DateTimeFieldRule<?>, Integer> toFieldValueMap() {
        return new TreeMap((SortedMap<DateTimeFieldRule<?>, Integer>)this.fieldValueMap);
    }

    private TreeMap<DateTimeFieldRule<?>, Integer> clonedMap() {
        TreeMap<DateTimeFieldRule<?>, Integer> cloned = DateTimeFields.createMap();
        cloned.putAll(this.fieldValueMap);
        return cloned;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DateTimeFields) {
            DateTimeFields other = (DateTimeFields)obj;
            return this.fieldValueMap.equals(other.fieldValueMap);
        }
        return false;
    }

    public int hashCode() {
        return this.fieldValueMap.hashCode();
    }

    public String toString() {
        return this.fieldValueMap.toString();
    }
}

