/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.util.Locale;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.IllegalCalendarFieldValueException;
import javax.time.calendar.format.DateTimeFormatterBuilder;

public enum DayOfWeek {
    MONDAY,
    TUESDAY,
    WEDNESDAY,
    THURSDAY,
    FRIDAY,
    SATURDAY,
    SUNDAY;


    public static DayOfWeek of(int dayOfWeek) {
        switch (dayOfWeek) {
            case 1: {
                return MONDAY;
            }
            case 2: {
                return TUESDAY;
            }
            case 3: {
                return WEDNESDAY;
            }
            case 4: {
                return THURSDAY;
            }
            case 5: {
                return FRIDAY;
            }
            case 6: {
                return SATURDAY;
            }
            case 7: {
                return SUNDAY;
            }
        }
        throw new IllegalCalendarFieldValueException(ISOChronology.dayOfWeekRule(), dayOfWeek, 1, 7);
    }

    public static DayOfWeek firstDayOfWeekFor(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("Locale must not be null");
        }
        if (locale.equals(Locale.US) || locale.getLanguage().equals("pt") && locale.getCountry().equals("BR")) {
            return SUNDAY;
        }
        return MONDAY;
    }

    public int getValue() {
        return this.ordinal() + 1;
    }

    public String getShortText(Locale locale) {
        return ISOChronology.dayOfWeekRule().getText(this.getValue(), locale, DateTimeFormatterBuilder.TextStyle.SHORT);
    }

    public String getText(Locale locale) {
        return ISOChronology.dayOfWeekRule().getText(this.getValue(), locale, DateTimeFormatterBuilder.TextStyle.FULL);
    }

    public boolean isMonday() {
        return this == MONDAY;
    }

    public boolean isTuesday() {
        return this == TUESDAY;
    }

    public boolean isWednesday() {
        return this == WEDNESDAY;
    }

    public boolean isThursday() {
        return this == THURSDAY;
    }

    public boolean isFriday() {
        return this == FRIDAY;
    }

    public boolean isSaturday() {
        return this == SATURDAY;
    }

    public boolean isSunday() {
        return this == SUNDAY;
    }

    public DayOfWeek next() {
        return DayOfWeek.values()[(this.ordinal() + 1) % 7];
    }

    public DayOfWeek previous() {
        return DayOfWeek.values()[(this.ordinal() + 7 - 1) % 7];
    }

    public DayOfWeek roll(int days) {
        return DayOfWeek.values()[(this.ordinal() + (days % 7 + 7)) % 7];
    }
}

