/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import javax.time.CalendricalException;
import javax.time.MathUtils;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalMatcher;
import javax.time.calendar.CalendricalRule;
import javax.time.calendar.DateAdjuster;
import javax.time.calendar.DateProvider;
import javax.time.calendar.DateResolver;
import javax.time.calendar.DateResolvers;
import javax.time.calendar.DayOfWeek;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.InvalidCalendarFieldException;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.LocalTime;
import javax.time.calendar.MonthOfYear;
import javax.time.calendar.OffsetDate;
import javax.time.calendar.TimeZone;
import javax.time.calendar.Year;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.ZoneResolvers;
import javax.time.calendar.ZonedDateTime;
import javax.time.calendar.format.DateTimeFormatters;
import javax.time.period.Period;
import javax.time.period.PeriodProvider;

public final class LocalDate
implements Calendrical,
DateProvider,
CalendricalMatcher,
DateAdjuster,
Comparable<LocalDate>,
Serializable {
    private static final long serialVersionUID = 798274969L;
    private final int year;
    private final MonthOfYear month;
    private final int day;

    public static LocalDate of(int year, MonthOfYear monthOfYear, int dayOfMonth) {
        ISOChronology.yearRule().checkValue(year);
        ISOChronology.checkNotNull((Object)monthOfYear, "MonthOfYear must not be null");
        ISOChronology.dayOfMonthRule().checkValue(dayOfMonth);
        return LocalDate.create(year, monthOfYear, dayOfMonth);
    }

    public static LocalDate of(int year, int monthOfYear, int dayOfMonth) {
        ISOChronology.yearRule().checkValue(year);
        ISOChronology.monthOfYearRule().checkValue(monthOfYear);
        ISOChronology.dayOfMonthRule().checkValue(dayOfMonth);
        return LocalDate.create(year, MonthOfYear.of(monthOfYear), dayOfMonth);
    }

    public static LocalDate from(DateProvider dateProvider) {
        ISOChronology.checkNotNull(dateProvider, "DateProvider must not be null");
        LocalDate result = dateProvider.toLocalDate();
        ISOChronology.checkNotNull(result, "DateProvider implementation must not return null");
        return result;
    }

    public static LocalDate fromEpochDays(long epochDays) {
        return LocalDate.fromYearZeroDays(epochDays + 719528L);
    }

    public static LocalDate fromModifiedJulianDays(long mjDays) {
        return LocalDate.fromYearZeroDays(mjDays + 678941L);
    }

    static LocalDate fromYearZeroDays(long epochDays) {
        long yearEst;
        long doyEst;
        long adjust = 0L;
        if ((epochDays -= 60L) < 0L) {
            long adjustCycles = (epochDays + 1L) / 146097L - 1L;
            adjust = adjustCycles * 400L;
            epochDays += -adjustCycles * 146097L;
        }
        if ((doyEst = epochDays - (365L * (yearEst = (400L * epochDays + 591L) / 146097L) + yearEst / 4L - yearEst / 100L + yearEst / 400L)) < 0L) {
            doyEst = epochDays - (365L * --yearEst + yearEst / 4L - yearEst / 100L + yearEst / 400L);
        }
        yearEst += adjust;
        int marchDoy0 = (int)doyEst;
        int marchMonth0 = (marchDoy0 * 5 + 2) / 153;
        int month = (marchMonth0 + 2) % 12 + 1;
        int dom = marchDoy0 - (marchMonth0 * 306 + 5) / 10 + 1;
        int year = ISOChronology.yearRule().checkValue(yearEst += (long)(marchMonth0 / 10));
        return new LocalDate(year, MonthOfYear.of(month), dom);
    }

    public static LocalDate parse(String text) {
        return DateTimeFormatters.isoLocalDate().parse(text, LocalDate.rule());
    }

    private static LocalDate create(int year, MonthOfYear monthOfYear, int dayOfMonth) {
        if (dayOfMonth > 28 && dayOfMonth > monthOfYear.lengthInDays(ISOChronology.isLeapYear(year))) {
            if (dayOfMonth == 29) {
                throw new InvalidCalendarFieldException("Illegal value for DayOfMonth field, value 29 is not valid as " + year + " is not a leap year", ISOChronology.dayOfMonthRule());
            }
            throw new InvalidCalendarFieldException("Illegal value for DayOfMonth field, value " + dayOfMonth + " is not valid for month " + monthOfYear.name(), ISOChronology.dayOfMonthRule());
        }
        return new LocalDate(year, monthOfYear, dayOfMonth);
    }

    private LocalDate(int year, MonthOfYear monthOfYear, int dayOfMonth) {
        this.year = year;
        this.month = monthOfYear;
        this.day = dayOfMonth;
    }

    public ISOChronology getChronology() {
        return ISOChronology.INSTANCE;
    }

    @Override
    public <T> T get(CalendricalRule<T> rule) {
        return LocalDate.rule().deriveValueFor(rule, this, this);
    }

    public int getYear() {
        return this.year;
    }

    public MonthOfYear getMonthOfYear() {
        return this.month;
    }

    public int getDayOfMonth() {
        return this.day;
    }

    public int getDayOfYear() {
        return ISOChronology.getDayOfYearFromDate(this);
    }

    public DayOfWeek getDayOfWeek() {
        return ISOChronology.getDayOfWeekFromDate(this);
    }

    private LocalDate resolveDate(DateResolver dateResolver, int year, MonthOfYear month, int day) {
        ISOChronology.yearRule().checkValue(year);
        ISOChronology.dayOfMonthRule().checkValue(day);
        LocalDate date = dateResolver.resolveDate(year, month, day);
        ISOChronology.checkNotNull(date, "DateResolver implementation must not return null");
        return date;
    }

    public LocalDate with(DateAdjuster adjuster) {
        ISOChronology.checkNotNull(adjuster, "DateAdjuster must not be null");
        LocalDate date = adjuster.adjustDate(this);
        ISOChronology.checkNotNull(date, "DateAdjuster implementation must not return null");
        return date;
    }

    public LocalDate withYear(int year) {
        return this.withYear(year, DateResolvers.previousValid());
    }

    public LocalDate withYear(int year, DateResolver dateResolver) {
        ISOChronology.checkNotNull(dateResolver, "DateResolver must not be null");
        if (this.year == year) {
            return this;
        }
        return this.resolveDate(dateResolver, year, this.month, this.day);
    }

    public LocalDate withMonthOfYear(int monthOfYear) {
        return this.with(MonthOfYear.of(monthOfYear), DateResolvers.previousValid());
    }

    public LocalDate withMonthOfYear(int monthOfYear, DateResolver dateResolver) {
        return this.with(MonthOfYear.of(monthOfYear), dateResolver);
    }

    public LocalDate with(MonthOfYear monthOfYear) {
        return this.with(monthOfYear, DateResolvers.previousValid());
    }

    public LocalDate with(MonthOfYear monthOfYear, DateResolver dateResolver) {
        ISOChronology.checkNotNull((Object)monthOfYear, "MonthOfYear must not be null");
        ISOChronology.checkNotNull(dateResolver, "DateResolver must not be null");
        if (this.month == monthOfYear) {
            return this;
        }
        return this.resolveDate(dateResolver, this.year, monthOfYear, this.day);
    }

    public LocalDate withDayOfMonth(int dayOfMonth) {
        if (this.day == dayOfMonth) {
            return this;
        }
        return LocalDate.of(this.year, this.month, dayOfMonth);
    }

    public LocalDate withDayOfMonth(int dayOfMonth, DateResolver dateResolver) {
        ISOChronology.checkNotNull(dateResolver, "DateResolver must not be null");
        if (this.day == dayOfMonth) {
            return this;
        }
        return this.resolveDate(dateResolver, this.year, this.month, dayOfMonth);
    }

    public LocalDate withDayOfYear(int dayOfYear) {
        if (this.getDayOfYear() == dayOfYear) {
            return this;
        }
        return ISOChronology.getDateFromDayOfYear(this.year, dayOfYear);
    }

    public LocalDate plus(PeriodProvider periodProvider) {
        Period period = Period.from(periodProvider);
        if (((long)(period.getHours() | period.getMinutes() | period.getSeconds()) | period.getNanos()) != 0L) {
            throw new CalendricalException("Unable to add to date as the period contains time units");
        }
        return this.plusYears(period.getYears()).plusMonths(period.getMonths()).plusDays(period.getDays());
    }

    public LocalDate plusYears(int years) {
        return this.plusYears(years, DateResolvers.previousValid());
    }

    public LocalDate plusYears(int years, DateResolver dateResolver) {
        ISOChronology.checkNotNull(dateResolver, "DateResolver must not be null");
        if (years == 0) {
            return this;
        }
        int newYear = ISOChronology.addYears(this.year, years);
        return this.resolveDate(dateResolver, newYear, this.month, this.day);
    }

    public LocalDate plusMonths(int months) {
        return this.plusMonths(months, DateResolvers.previousValid());
    }

    public LocalDate plusMonths(int months, DateResolver dateResolver) {
        ISOChronology.checkNotNull(dateResolver, "DateResolver must not be null");
        if (months == 0) {
            return this;
        }
        long newMonth0 = this.month.getValue() - 1;
        int years = (int)((newMonth0 += (long)months) / 12L);
        if ((newMonth0 %= 12L) < 0L) {
            newMonth0 += 12L;
            --years;
        }
        int newYear = ISOChronology.addYears(this.year, years);
        MonthOfYear newMonth = MonthOfYear.of((int)(++newMonth0));
        return this.resolveDate(dateResolver, newYear, newMonth, this.day);
    }

    public LocalDate plusWeeks(int weeks) {
        return this.plusDays(7L * (long)weeks);
    }

    public LocalDate plusDays(long days) {
        if (days == 0L) {
            return this;
        }
        long mjDays = this.toModifiedJulianDays();
        try {
            mjDays = MathUtils.safeAdd(mjDays, days);
        }
        catch (ArithmeticException ae) {
            throw new CalendricalException(this + " + " + days + " days exceeds the current capacity");
        }
        return LocalDate.fromModifiedJulianDays(mjDays);
    }

    public LocalDate minus(PeriodProvider periodProvider) {
        Period period = Period.from(periodProvider);
        if (((long)(period.getHours() | period.getMinutes() | period.getSeconds()) | period.getNanos()) != 0L) {
            throw new CalendricalException("Unable to subtract from date as the period contains time units");
        }
        return this.minusYears(period.getYears()).minusMonths(period.getMonths()).minusDays(period.getDays());
    }

    public LocalDate minusYears(int years) {
        return this.minusYears(years, DateResolvers.previousValid());
    }

    public LocalDate minusYears(int years, DateResolver dateResolver) {
        ISOChronology.checkNotNull(dateResolver, "DateResolver must not be null");
        if (years == 0) {
            return this;
        }
        int newYear = ISOChronology.subtractYears(this.year, years);
        return this.resolveDate(dateResolver, newYear, this.month, this.day);
    }

    public LocalDate minusMonths(int months) {
        return this.minusMonths(months, DateResolvers.previousValid());
    }

    public LocalDate minusMonths(int months, DateResolver dateResolver) {
        ISOChronology.checkNotNull(dateResolver, "DateResolver must not be null");
        if (months == 0) {
            return this;
        }
        long newMonth0 = this.month.getValue() - 1;
        int years = (int)((newMonth0 -= (long)months) / 12L);
        if ((newMonth0 %= 12L) < 0L) {
            newMonth0 += 12L;
            --years;
        }
        int newYear = ISOChronology.subtractYears(this.year, -years);
        MonthOfYear newMonth = MonthOfYear.of((int)(++newMonth0));
        return this.resolveDate(dateResolver, newYear, newMonth, this.day);
    }

    public LocalDate minusWeeks(int weeks) {
        return this.minusDays(7L * (long)weeks);
    }

    public LocalDate minusDays(long days) {
        if (days == 0L) {
            return this;
        }
        long mjDays = this.toModifiedJulianDays();
        try {
            mjDays = MathUtils.safeSubtract(mjDays, days);
        }
        catch (ArithmeticException ae) {
            throw new CalendricalException(this + " - " + days + " days exceeds the current capacity");
        }
        return LocalDate.fromModifiedJulianDays(mjDays);
    }

    public boolean matches(CalendricalMatcher matcher) {
        return matcher.matchesCalendrical(this);
    }

    @Override
    public boolean matchesCalendrical(Calendrical calendrical) {
        return this.equals(calendrical.get(LocalDate.rule()));
    }

    @Override
    public LocalDate adjustDate(LocalDate date) {
        ISOChronology.checkNotNull(date, "LocalDate must not be null");
        return this.equals(date) ? date : this;
    }

    public LocalDateTime atTime(LocalTime time) {
        return LocalDateTime.from(this, time);
    }

    public LocalDateTime atTime(int hourOfDay, int minuteOfHour) {
        return this.atTime(LocalTime.of(hourOfDay, minuteOfHour));
    }

    public LocalDateTime atTime(int hourOfDay, int minuteOfHour, int secondOfMinute) {
        return this.atTime(LocalTime.of(hourOfDay, minuteOfHour, secondOfMinute));
    }

    public LocalDateTime atTime(int hourOfDay, int minuteOfHour, int secondOfMinute, int nanoOfSecond) {
        return this.atTime(LocalTime.of(hourOfDay, minuteOfHour, secondOfMinute, nanoOfSecond));
    }

    public LocalDateTime atMidnight() {
        return LocalDateTime.from(this, LocalTime.MIDNIGHT);
    }

    public OffsetDate atOffset(ZoneOffset offset) {
        return OffsetDate.from(this, offset);
    }

    public ZonedDateTime atStartOfDayInZone(TimeZone zone) {
        return ZonedDateTime.from(this, LocalTime.MIDNIGHT, zone, ZoneResolvers.postGapPreOverlap());
    }

    @Override
    public LocalDate toLocalDate() {
        return this;
    }

    public Year toYear() {
        return Year.of(this.year);
    }

    public long toEpochDays() {
        return this.toYearZeroDays() - 719528L;
    }

    public long toModifiedJulianDays() {
        return this.toYearZeroDays() - 678941L;
    }

    long toYearZeroDays() {
        long y = this.year;
        long m = this.month.getValue();
        long total = 0L;
        total += 365L * y;
        total = y >= 0L ? (total += (y + 3L) / 4L - (y + 99L) / 100L + (y + 399L) / 400L) : (total -= y / -4L - y / -100L + y / -400L);
        total += (367L * m - 362L) / 12L;
        total += (long)(this.day - 1);
        if (m > 2L) {
            --total;
            if (!ISOChronology.isLeapYear(this.year)) {
                --total;
            }
        }
        return total;
    }

    @Override
    public int compareTo(LocalDate other) {
        int cmp = MathUtils.safeCompare(this.year, other.year);
        if (cmp == 0 && (cmp = this.month.compareTo(other.month)) == 0) {
            cmp = MathUtils.safeCompare(this.day, other.day);
        }
        return cmp;
    }

    public boolean isAfter(LocalDate other) {
        return this.compareTo(other) > 0;
    }

    public boolean isBefore(LocalDate other) {
        return this.compareTo(other) < 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof LocalDate) {
            LocalDate otherDate = (LocalDate)other;
            return this.year == otherDate.year && this.month == otherDate.month && this.day == otherDate.day;
        }
        return false;
    }

    public int hashCode() {
        int yearValue = this.year;
        int monthValue = this.month.getValue();
        int dayValue = this.day;
        return yearValue & 0xFFFFF800 ^ (yearValue << 11) + (monthValue << 6) + dayValue;
    }

    public String toString() {
        int yearValue = this.year;
        int monthValue = this.month.getValue();
        int dayValue = this.day;
        int absYear = Math.abs(yearValue);
        StringBuilder buf = new StringBuilder(10);
        if (absYear < 1000) {
            if (yearValue < 0) {
                buf.append(yearValue - 10000).deleteCharAt(1);
            } else {
                buf.append(yearValue + 10000).deleteCharAt(0);
            }
        } else {
            if (yearValue > 9999) {
                buf.append('+');
            }
            buf.append(yearValue);
        }
        return buf.append(monthValue < 10 ? "-0" : "-").append(monthValue).append(dayValue < 10 ? "-0" : "-").append(dayValue).toString();
    }

    public static CalendricalRule<LocalDate> rule() {
        return Rule.INSTANCE;
    }

    static final class Rule
    extends CalendricalRule<LocalDate>
    implements Serializable {
        private static final CalendricalRule<LocalDate> INSTANCE = new Rule();
        private static final long serialVersionUID = 1L;

        private Rule() {
            super(LocalDate.class, ISOChronology.INSTANCE, "LocalDate", ISOChronology.periodDays(), null);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected LocalDate derive(Calendrical calendrical) {
            LocalDateTime ldt = calendrical.get(LocalDateTime.rule());
            if (ldt != null) {
                return ldt.toLocalDate();
            }
            OffsetDate od = calendrical.get(OffsetDate.rule());
            if (od != null) {
                return od.toLocalDate();
            }
            return null;
        }
    }
}

