/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import javax.time.CalendricalException;
import javax.time.MathUtils;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalMatcher;
import javax.time.calendar.CalendricalRule;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.LocalDate;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.OffsetTime;
import javax.time.calendar.TimeAdjuster;
import javax.time.calendar.TimeProvider;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.format.DateTimeFormatters;
import javax.time.period.Period;
import javax.time.period.PeriodProvider;

public final class LocalTime
implements Calendrical,
TimeProvider,
CalendricalMatcher,
TimeAdjuster,
Comparable<LocalTime>,
Serializable {
    public static final LocalTime MIDNIGHT;
    public static final LocalTime MIDDAY;
    private static final LocalTime[] HOURS;
    private static final long serialVersionUID = 798759096L;
    private static final int HOURS_PER_DAY = 24;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int MINUTES_PER_DAY = 1440;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_DAY = 86400;
    private static final long NANOS_PER_SECOND = 1000000000L;
    private static final long NANOS_PER_MINUTE = 60000000000L;
    private static final long NANOS_PER_HOUR = 3600000000000L;
    private static final long NANOS_PER_DAY = 86400000000000L;
    private final byte hour;
    private final byte minute;
    private final byte second;
    private final int nano;

    public static LocalTime of(int hourOfDay, int minuteOfHour) {
        ISOChronology.hourOfDayRule().checkValue(hourOfDay);
        if (minuteOfHour == 0) {
            return HOURS[hourOfDay];
        }
        ISOChronology.minuteOfHourRule().checkValue(minuteOfHour);
        return new LocalTime(hourOfDay, minuteOfHour, 0, 0);
    }

    public static LocalTime of(int hourOfDay, int minuteOfHour, int secondOfMinute) {
        ISOChronology.hourOfDayRule().checkValue(hourOfDay);
        if ((minuteOfHour | secondOfMinute) == 0) {
            return HOURS[hourOfDay];
        }
        ISOChronology.minuteOfHourRule().checkValue(minuteOfHour);
        ISOChronology.secondOfMinuteRule().checkValue(secondOfMinute);
        return new LocalTime(hourOfDay, minuteOfHour, secondOfMinute, 0);
    }

    public static LocalTime of(int hourOfDay, int minuteOfHour, int secondOfMinute, int nanoOfSecond) {
        ISOChronology.hourOfDayRule().checkValue(hourOfDay);
        ISOChronology.minuteOfHourRule().checkValue(minuteOfHour);
        ISOChronology.secondOfMinuteRule().checkValue(secondOfMinute);
        ISOChronology.nanoOfSecondRule().checkValue(nanoOfSecond);
        return LocalTime.create(hourOfDay, minuteOfHour, secondOfMinute, nanoOfSecond);
    }

    public static LocalTime from(TimeProvider timeProvider) {
        ISOChronology.checkNotNull(timeProvider, "TimeProvider must not be null");
        LocalTime result = timeProvider.toLocalTime();
        ISOChronology.checkNotNull(result, "TimeProvider implementation must not return null");
        return result;
    }

    public static LocalTime fromSecondOfDay(long secondOfDay) {
        ISOChronology.secondOfDayRule().checkValue(secondOfDay);
        int hours = (int)(secondOfDay / 3600L);
        int minutes = (int)((secondOfDay -= (long)(hours * 3600)) / 60L);
        return LocalTime.create(hours, minutes, (int)(secondOfDay -= (long)(minutes * 60)), 0);
    }

    public static LocalTime fromSecondOfDay(long secondOfDay, int nanoOfSecond) {
        ISOChronology.secondOfDayRule().checkValue(secondOfDay);
        ISOChronology.nanoOfSecondRule().checkValue(nanoOfSecond);
        int hours = (int)(secondOfDay / 3600L);
        int minutes = (int)((secondOfDay -= (long)(hours * 3600)) / 60L);
        return LocalTime.create(hours, minutes, (int)(secondOfDay -= (long)(minutes * 60)), nanoOfSecond);
    }

    public static LocalTime fromNanoOfDay(long nanoOfDay) {
        if (nanoOfDay < 0L) {
            throw new CalendricalException("Cannot create LocalTime from nanos of day as value " + nanoOfDay + " must not be negative");
        }
        if (nanoOfDay >= 86400000000000L) {
            throw new CalendricalException("Cannot create LocalTime from nanos of day as value " + nanoOfDay + " must be less than " + 86400000000000L);
        }
        int hours = (int)(nanoOfDay / 3600000000000L);
        int minutes = (int)((nanoOfDay -= (long)hours * 3600000000000L) / 60000000000L);
        int seconds = (int)((nanoOfDay -= (long)minutes * 60000000000L) / 1000000000L);
        return LocalTime.create(hours, minutes, seconds, (int)(nanoOfDay -= (long)seconds * 1000000000L));
    }

    public static LocalTime parse(String text) {
        return DateTimeFormatters.isoLocalTime().parse(text, LocalTime.rule());
    }

    private static LocalTime create(int hourOfDay, int minuteOfHour, int secondOfMinute, int nanoOfSecond) {
        if ((minuteOfHour | secondOfMinute | nanoOfSecond) == 0) {
            return HOURS[hourOfDay];
        }
        return new LocalTime(hourOfDay, minuteOfHour, secondOfMinute, nanoOfSecond);
    }

    private LocalTime(int hourOfDay, int minuteOfHour, int secondOfMinute, int nanoOfSecond) {
        this.hour = (byte)hourOfDay;
        this.minute = (byte)minuteOfHour;
        this.second = (byte)secondOfMinute;
        this.nano = nanoOfSecond;
    }

    private Object readResolve() {
        return LocalTime.create(this.hour, this.minute, this.second, this.nano);
    }

    public ISOChronology getChronology() {
        return ISOChronology.INSTANCE;
    }

    @Override
    public <T> T get(CalendricalRule<T> rule) {
        return LocalTime.rule().deriveValueFor(rule, this, this);
    }

    public int getHourOfDay() {
        return this.hour;
    }

    public int getMinuteOfHour() {
        return this.minute;
    }

    public int getSecondOfMinute() {
        return this.second;
    }

    public int getNanoOfSecond() {
        return this.nano;
    }

    public LocalTime with(TimeAdjuster adjuster) {
        LocalTime time = adjuster.adjustTime(this);
        if (time == null) {
            throw new NullPointerException("The implementation of TimeAdjuster must not return null");
        }
        return time;
    }

    public LocalTime withHourOfDay(int hourOfDay) {
        if (hourOfDay == this.hour) {
            return this;
        }
        ISOChronology.hourOfDayRule().checkValue(hourOfDay);
        return LocalTime.create(hourOfDay, this.minute, this.second, this.nano);
    }

    public LocalTime withMinuteOfHour(int minuteOfHour) {
        if (minuteOfHour == this.minute) {
            return this;
        }
        ISOChronology.minuteOfHourRule().checkValue(minuteOfHour);
        return LocalTime.create(this.hour, minuteOfHour, this.second, this.nano);
    }

    public LocalTime withSecondOfMinute(int secondOfMinute) {
        if (secondOfMinute == this.second) {
            return this;
        }
        ISOChronology.secondOfMinuteRule().checkValue(secondOfMinute);
        return LocalTime.create(this.hour, this.minute, secondOfMinute, this.nano);
    }

    public LocalTime withNanoOfSecond(int nanoOfSecond) {
        if (nanoOfSecond == this.nano) {
            return this;
        }
        ISOChronology.nanoOfSecondRule().checkValue(nanoOfSecond);
        return LocalTime.create(this.hour, this.minute, this.second, nanoOfSecond);
    }

    public LocalTime plus(PeriodProvider periodProvider) {
        Period period = Period.from(periodProvider);
        if ((period.getYears() | period.getMonths() | period.getDays()) != 0) {
            throw new CalendricalException("Unable to add to date as the period contains date units");
        }
        long totNanos = period.getNanos() % 86400000000000L + (long)(period.getSeconds() % 86400) * 1000000000L + (long)(period.getMinutes() % 1440) * 60000000000L + (long)(period.getHours() % 24) * 3600000000000L;
        return this.plusNanos(totNanos);
    }

    public LocalTime plusHours(int hours) {
        if (hours == 0) {
            return this;
        }
        int newHour = (hours % 24 + this.hour + 24) % 24;
        return LocalTime.create(newHour, this.minute, this.second, this.nano);
    }

    public LocalTime plusMinutes(int minutes) {
        if (minutes == 0) {
            return this;
        }
        int mofd = this.hour * 60 + this.minute;
        int newMofd = (minutes % 1440 + mofd + 1440) % 1440;
        if (mofd == newMofd) {
            return this;
        }
        int newHour = newMofd / 60;
        int newMinute = newMofd % 60;
        return LocalTime.create(newHour, newMinute, this.second, this.nano);
    }

    public LocalTime plusSeconds(int seconds) {
        if (seconds == 0) {
            return this;
        }
        int sofd = this.hour * 3600 + this.minute * 60 + this.second;
        int newSofd = (seconds % 86400 + sofd + 86400) % 86400;
        if (sofd == newSofd) {
            return this;
        }
        int newHour = newSofd / 3600;
        int newMinute = newSofd / 60 % 60;
        int newSecond = newSofd % 60;
        return LocalTime.create(newHour, newMinute, newSecond, this.nano);
    }

    public LocalTime plusNanos(long nanos) {
        long newNofd;
        if (nanos == 0L) {
            return this;
        }
        long nofd = this.toNanoOfDay();
        if (nofd == (newNofd = (nanos % 86400000000000L + nofd + 86400000000000L) % 86400000000000L)) {
            return this;
        }
        int newHour = (int)(newNofd / 3600000000000L);
        int newMinute = (int)(newNofd / 60000000000L % 60L);
        int newSecond = (int)(newNofd / 1000000000L % 60L);
        int newNano = (int)(newNofd % 1000000000L);
        return LocalTime.create(newHour, newMinute, newSecond, newNano);
    }

    public Overflow plusWithOverflow(int hours, int minutes, int seconds, long nanos) {
        return this.plusWithOverflow(hours, minutes, seconds, nanos, 1);
    }

    private Overflow plusWithOverflow(int hours, int minutes, int seconds, long nanos, int sign) {
        int totDays = (int)(nanos / 86400000000000L) + seconds / 86400 + minutes / 1440 + hours / 24;
        totDays *= sign;
        long totNanos = nanos % 86400000000000L + (long)(seconds % 86400) * 1000000000L + (long)(minutes % 1440) * 60000000000L + (long)(hours % 24) * 3600000000000L;
        if (totNanos == 0L) {
            return new Overflow(this, totDays);
        }
        long thisNanos = this.toNanoOfDay();
        totNanos = totNanos * (long)sign + thisNanos;
        totDays += (int)(totNanos / 86400000000000L);
        if ((totNanos %= 86400000000000L) < 0L) {
            --totDays;
            totNanos += 86400000000000L;
        }
        LocalTime newTime = totNanos == thisNanos ? this : LocalTime.fromNanoOfDay(totNanos);
        return new Overflow(newTime, totDays);
    }

    public LocalTime minus(PeriodProvider periodProvider) {
        Period period = Period.from(periodProvider);
        if ((period.getYears() | period.getMonths() | period.getDays()) != 0) {
            throw new CalendricalException("Unable to add to date as the period contains date units");
        }
        long totNanos = period.getNanos() % 86400000000000L + (long)(period.getSeconds() % 86400) * 1000000000L + (long)(period.getMinutes() % 1440) * 60000000000L + (long)(period.getHours() % 24) * 3600000000000L;
        return this.minusNanos(totNanos);
    }

    public LocalTime minusHours(int hours) {
        if (hours == 0) {
            return this;
        }
        int newHour = (-(hours % 24) + this.hour + 24) % 24;
        return LocalTime.create(newHour, this.minute, this.second, this.nano);
    }

    public LocalTime minusMinutes(int minutes) {
        if (minutes == 0) {
            return this;
        }
        int mofd = this.hour * 60 + this.minute;
        int newMofd = (-(minutes % 1440) + mofd + 1440) % 1440;
        if (mofd == newMofd) {
            return this;
        }
        int newHour = newMofd / 60;
        int newMinute = newMofd % 60;
        return LocalTime.create(newHour, newMinute, this.second, this.nano);
    }

    public LocalTime minusSeconds(int seconds) {
        if (seconds == 0) {
            return this;
        }
        int sofd = this.hour * 3600 + this.minute * 60 + this.second;
        int newSofd = (-(seconds % 86400) + sofd + 86400) % 86400;
        if (sofd == newSofd) {
            return this;
        }
        int newHour = newSofd / 3600;
        int newMinute = newSofd / 60 % 60;
        int newSecond = newSofd % 60;
        return LocalTime.create(newHour, newMinute, newSecond, this.nano);
    }

    public LocalTime minusNanos(long nanos) {
        long newNofd;
        if (nanos == 0L) {
            return this;
        }
        long nofd = this.toNanoOfDay();
        if (nofd == (newNofd = (-(nanos % 86400000000000L) + nofd + 86400000000000L) % 86400000000000L)) {
            return this;
        }
        int newHour = (int)(newNofd / 3600000000000L);
        int newMinute = (int)(newNofd / 60000000000L % 60L);
        int newSecond = (int)(newNofd / 1000000000L % 60L);
        int newNano = (int)(newNofd % 1000000000L);
        return LocalTime.create(newHour, newMinute, newSecond, newNano);
    }

    public Overflow minusWithOverflow(int hours, int minutes, int seconds, long nanos) {
        return this.plusWithOverflow(hours, minutes, seconds, nanos, -1);
    }

    public boolean matches(CalendricalMatcher matcher) {
        return matcher.matchesCalendrical(this);
    }

    @Override
    public boolean matchesCalendrical(Calendrical calendrical) {
        return this.equals(calendrical.get(LocalTime.rule()));
    }

    @Override
    public LocalTime adjustTime(LocalTime time) {
        ISOChronology.checkNotNull(time, "LocalTime must not be null");
        return this.equals(time) ? time : this;
    }

    public OffsetTime atOffset(ZoneOffset offset) {
        return OffsetTime.from(this, offset);
    }

    @Override
    public LocalTime toLocalTime() {
        return this;
    }

    public Overflow toOverflow(int daysOverflow) {
        return new Overflow(this, daysOverflow);
    }

    public int toSecondOfDay() {
        int total = this.hour * 3600;
        total += this.minute * 60;
        return total += this.second;
    }

    public long toNanoOfDay() {
        long total = (long)this.hour * 3600000000000L;
        total += (long)this.minute * 60000000000L;
        total += (long)this.second * 1000000000L;
        return total += (long)this.nano;
    }

    @Override
    public int compareTo(LocalTime other) {
        int cmp = MathUtils.safeCompare(this.hour, other.hour);
        if (cmp == 0 && (cmp = MathUtils.safeCompare(this.minute, other.minute)) == 0 && (cmp = MathUtils.safeCompare(this.second, other.second)) == 0) {
            cmp = MathUtils.safeCompare(this.nano, other.nano);
        }
        return cmp;
    }

    public boolean isAfter(LocalTime other) {
        return this.compareTo(other) > 0;
    }

    public boolean isBefore(LocalTime other) {
        return this.compareTo(other) < 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof LocalTime) {
            LocalTime localTime = (LocalTime)other;
            return this.hour == localTime.hour && this.minute == localTime.minute && this.second == localTime.second && this.nano == localTime.nano;
        }
        return false;
    }

    public int hashCode() {
        long nod = this.toNanoOfDay();
        return (int)(nod ^ nod >>> 32);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(18);
        byte hourValue = this.hour;
        byte minuteValue = this.minute;
        byte secondValue = this.second;
        int nanoValue = this.nano;
        buf.append(hourValue < 10 ? "0" : "").append(hourValue).append(minuteValue < 10 ? ":0" : ":").append(minuteValue);
        if (secondValue > 0 || nanoValue > 0) {
            buf.append(secondValue < 10 ? ":0" : ":").append(secondValue);
            if (nanoValue > 0) {
                buf.append('.');
                if (nanoValue % 1000000 == 0) {
                    buf.append(Integer.toString(nanoValue / 1000000 + 1000).substring(1));
                } else if (nanoValue % 1000 == 0) {
                    buf.append(Integer.toString(nanoValue / 1000 + 1000000).substring(1));
                } else {
                    buf.append(Integer.toString(nanoValue + 1000000000).substring(1));
                }
            }
        }
        return buf.toString();
    }

    public static CalendricalRule<LocalTime> rule() {
        return Rule.INSTANCE;
    }

    static {
        HOURS = new LocalTime[24];
        for (int i = 0; i < HOURS.length; ++i) {
            LocalTime.HOURS[i] = new LocalTime(i, 0, 0, 0);
        }
        MIDNIGHT = HOURS[0];
        MIDDAY = HOURS[12];
    }

    static final class Rule
    extends CalendricalRule<LocalTime>
    implements Serializable {
        private static final CalendricalRule<LocalTime> INSTANCE = new Rule();
        private static final long serialVersionUID = 1L;

        private Rule() {
            super(LocalTime.class, ISOChronology.INSTANCE, "LocalTime", ISOChronology.periodNanos(), ISOChronology.periodDays());
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected LocalTime derive(Calendrical calendrical) {
            LocalDateTime ldt = calendrical.get(LocalDateTime.rule());
            if (ldt != null) {
                return ldt.toLocalTime();
            }
            OffsetTime ot = calendrical.get(OffsetTime.rule());
            if (ot != null) {
                return ot.toLocalTime();
            }
            return null;
        }
    }

    public static final class Overflow {
        private final LocalTime time;
        private final int days;

        private Overflow(LocalTime time, int days) {
            this.time = time;
            this.days = days;
        }

        public LocalTime getResultTime() {
            return this.time;
        }

        public int getOverflowDays() {
            return this.days;
        }

        public LocalDateTime toLocalDateTime(LocalDate date) {
            return LocalDateTime.from(date.plusDays(this.getOverflowDays()), this.time);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Overflow) {
                Overflow other = (Overflow)obj;
                return this.time.equals(other.time) && this.days == other.days;
            }
            return false;
        }

        public int hashCode() {
            return this.time.hashCode() + this.days;
        }

        public String toString() {
            return this.getResultTime().toString() + " + P" + this.days + "D";
        }
    }
}

