/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import javax.time.MathUtils;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalMatcher;
import javax.time.calendar.CalendricalRule;
import javax.time.calendar.DateAdjuster;
import javax.time.calendar.DateResolver;
import javax.time.calendar.DateResolvers;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.InvalidCalendarFieldException;
import javax.time.calendar.LocalDate;
import javax.time.calendar.MonthOfYear;
import javax.time.calendar.format.DateTimeFormatter;
import javax.time.calendar.format.DateTimeFormatterBuilder;

public final class MonthDay
implements Calendrical,
CalendricalMatcher,
DateAdjuster,
Comparable<MonthDay>,
Serializable {
    private static final long serialVersionUID = -254395108L;
    private static final DateTimeFormatter PARSER = new DateTimeFormatterBuilder().appendLiteral("--").appendValue(ISOChronology.monthOfYearRule(), 2).appendLiteral('-').appendValue(ISOChronology.dayOfMonthRule(), 2).toFormatter();
    private final MonthOfYear month;
    private final int day;

    public static MonthDay of(MonthOfYear monthOfYear, int dayOfMonth) {
        ISOChronology.checkNotNull((Object)monthOfYear, "MonthOfYear must not be null");
        ISOChronology.dayOfMonthRule().checkValue(dayOfMonth);
        if (dayOfMonth > monthOfYear.maxLengthInDays()) {
            throw new InvalidCalendarFieldException("Illegal value for DayOfMonth field, value " + dayOfMonth + " is not valid for month " + monthOfYear.name(), ISOChronology.dayOfMonthRule());
        }
        return new MonthDay(monthOfYear, dayOfMonth);
    }

    public static MonthDay of(int monthOfYear, int dayOfMonth) {
        return MonthDay.of(MonthOfYear.of(monthOfYear), dayOfMonth);
    }

    public static MonthDay from(Calendrical calendrical) {
        MonthOfYear month = (MonthOfYear)((Object)ISOChronology.monthOfYearRule().getValueChecked(calendrical));
        Integer dom = (Integer)ISOChronology.dayOfMonthRule().getValueChecked(calendrical);
        return MonthDay.of(month, (int)dom);
    }

    public static MonthDay parse(String text) {
        return PARSER.parse(text, MonthDay.rule());
    }

    private MonthDay(MonthOfYear monthOfYear, int dayOfMonth) {
        this.month = monthOfYear;
        this.day = dayOfMonth;
    }

    private MonthDay with(MonthOfYear newMonth, int newDay) {
        if (this.month == newMonth && this.day == newDay) {
            return this;
        }
        return new MonthDay(newMonth, newDay);
    }

    public ISOChronology getChronology() {
        return ISOChronology.INSTANCE;
    }

    @Override
    public <T> T get(CalendricalRule<T> rule) {
        ISOChronology.checkNotNull(rule, "CalendricalRule must not be null");
        if (rule.equals(ISOChronology.monthOfYearRule())) {
            return rule.reify((Object)this.month);
        }
        if (rule.equals(ISOChronology.dayOfMonthRule())) {
            return rule.reify(this.day);
        }
        return MonthDay.rule().deriveValueFor(rule, this, this);
    }

    public MonthOfYear getMonthOfYear() {
        return this.month;
    }

    public int getDayOfMonth() {
        return this.day;
    }

    public MonthDay with(MonthOfYear monthOfYear) {
        ISOChronology.checkNotNull((Object)monthOfYear, "MonthOfYear must not be null");
        int maxDays = monthOfYear.maxLengthInDays();
        if (this.day > maxDays) {
            return this.with(monthOfYear, maxDays);
        }
        return this.with(monthOfYear, this.day);
    }

    public MonthDay withMonthOfYear(int monthOfYear) {
        return this.with(MonthOfYear.of(monthOfYear));
    }

    public MonthDay withDayOfMonth(int dayOfMonth) {
        ISOChronology.dayOfMonthRule().checkValue(dayOfMonth);
        int maxDays = this.month.maxLengthInDays();
        if (dayOfMonth > maxDays) {
            throw new InvalidCalendarFieldException("Day of month cannot be changed to " + dayOfMonth + " for the month " + (Object)((Object)this.month), ISOChronology.dayOfMonthRule());
        }
        return this.with(this.month, dayOfMonth);
    }

    public MonthDay rollMonthOfYear(int months) {
        return this.with(this.month.roll(months));
    }

    public MonthDay rollDayOfMonth(int days) {
        if (days == 0) {
            return this;
        }
        int monthLength = this.month.maxLengthInDays();
        int newDOM0 = days % monthLength + (this.day - 1);
        newDOM0 = (newDOM0 + monthLength) % monthLength;
        return this.withDayOfMonth(++newDOM0);
    }

    @Override
    public boolean matchesCalendrical(Calendrical calendrical) {
        return this.equals(calendrical.get(MonthDay.rule()));
    }

    @Override
    public LocalDate adjustDate(LocalDate date) {
        return this.adjustDate(date, DateResolvers.strict());
    }

    public LocalDate adjustDate(LocalDate date, DateResolver resolver) {
        ISOChronology.checkNotNull(date, "LocalDate must not be null");
        ISOChronology.checkNotNull(resolver, "DateResolver must not be null");
        if (date.getMonthOfYear() == this.month && date.getDayOfMonth() == this.day) {
            return date;
        }
        LocalDate resolved = resolver.resolveDate(date.getYear(), this.month, this.day);
        ISOChronology.checkNotNull(resolved, "The implementation of DateResolver must not return null");
        return resolved;
    }

    public boolean isValidYear(int year) {
        return !(this.day == 29 && this.month.isFebruary() && !ISOChronology.isLeapYear(year));
    }

    public LocalDate atYear(int year) {
        return LocalDate.of(year, this.month, this.day);
    }

    @Override
    public int compareTo(MonthDay other) {
        int cmp = this.month.compareTo(other.month);
        if (cmp == 0) {
            cmp = MathUtils.safeCompare(this.day, other.day);
        }
        return cmp;
    }

    public boolean isAfter(MonthDay other) {
        return this.compareTo(other) > 0;
    }

    public boolean isBefore(MonthDay other) {
        return this.compareTo(other) < 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MonthDay) {
            MonthDay otherMD = (MonthDay)other;
            return this.month == otherMD.month && this.day == otherMD.day;
        }
        return false;
    }

    public int hashCode() {
        return (this.month.getValue() << 6) + this.day;
    }

    public String toString() {
        int monthValue = this.month.getValue();
        int dayValue = this.day;
        return new StringBuilder(10).append("--").append(monthValue < 10 ? "0" : "").append(monthValue).append(dayValue < 10 ? "-0" : "-").append(dayValue).toString();
    }

    public static CalendricalRule<MonthDay> rule() {
        return Rule.INSTANCE;
    }

    static final class Rule
    extends CalendricalRule<MonthDay>
    implements Serializable {
        private static final CalendricalRule<MonthDay> INSTANCE = new Rule();
        private static final long serialVersionUID = 1L;

        private Rule() {
            super(MonthDay.class, ISOChronology.INSTANCE, "MonthDay", ISOChronology.periodDays(), ISOChronology.periodYears());
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected MonthDay derive(Calendrical calendrical) {
            MonthOfYear moy = calendrical.get(ISOChronology.monthOfYearRule());
            Integer dom = calendrical.get(ISOChronology.dayOfMonthRule());
            return moy != null && dom != null ? MonthDay.of(moy, (int)dom) : null;
        }
    }
}

