/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import javax.time.calendar.ISOChronology;
import javax.time.calendar.IllegalCalendarFieldValueException;
import javax.time.calendar.MonthOfYear;

public enum QuarterOfYear {
    Q1,
    Q2,
    Q3,
    Q4;


    public static QuarterOfYear of(int quarterOfYear) {
        switch (quarterOfYear) {
            case 1: {
                return Q1;
            }
            case 2: {
                return Q2;
            }
            case 3: {
                return Q3;
            }
            case 4: {
                return Q4;
            }
        }
        throw new IllegalCalendarFieldValueException(ISOChronology.quarterOfYearRule(), quarterOfYear, 1, 4);
    }

    public int getValue() {
        return this.ordinal() + 1;
    }

    public boolean isQ1() {
        return this == Q1;
    }

    public boolean isQ2() {
        return this == Q2;
    }

    public boolean isQ3() {
        return this == Q3;
    }

    public boolean isQ4() {
        return this == Q4;
    }

    public QuarterOfYear next() {
        return QuarterOfYear.values()[(this.ordinal() + 1) % 4];
    }

    public QuarterOfYear previous() {
        return QuarterOfYear.values()[(this.ordinal() + 4 - 1) % 4];
    }

    public QuarterOfYear roll(int quarters) {
        return QuarterOfYear.values()[(this.ordinal() + (quarters % 4 + 4)) % 4];
    }

    public MonthOfYear getFirstMonthOfQuarter() {
        switch (this) {
            case Q1: {
                return MonthOfYear.JANUARY;
            }
            case Q2: {
                return MonthOfYear.APRIL;
            }
            case Q3: {
                return MonthOfYear.JULY;
            }
        }
        return MonthOfYear.OCTOBER;
    }
}

