/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import java.util.Map;
import javax.time.CalendricalException;
import javax.time.Instant;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalRule;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.ZonedDateTime;
import javax.time.calendar.zone.ZoneRules;
import javax.time.calendar.zone.ZoneRulesGroup;

public final class TimeZone
implements Calendrical,
Serializable {
    private static final long serialVersionUID = 93618758758127L;
    public static final TimeZone UTC = new TimeZone("", "UTC", "", ZoneRules.fixed(ZoneOffset.UTC));
    private final String groupID;
    private final String regionID;
    private final String versionID;
    private volatile transient ZoneRules rules;

    public static TimeZone of(String timeZoneIdentifier, Map<String, TimeZone> aliasMap) {
        ISOChronology.checkNotNull(timeZoneIdentifier, "Time Zone ID must not be null");
        ISOChronology.checkNotNull(aliasMap, "Alias map must not be null");
        TimeZone zone = aliasMap.get(timeZoneIdentifier);
        return zone == null ? TimeZone.of(timeZoneIdentifier) : zone;
    }

    public static TimeZone of(String zoneID) {
        ZoneRulesGroup group;
        ISOChronology.checkNotNull(zoneID, "Time zone ID must not be null");
        if (zoneID.equals("UTC") || zoneID.equals("GMT")) {
            return UTC;
        }
        if (zoneID.equals("UTCZ") || zoneID.equals("GMTZ")) {
            throw new CalendricalException("Invalid time zone ID: " + zoneID);
        }
        if (zoneID.startsWith("UTC") || zoneID.startsWith("GMT")) {
            try {
                return TimeZone.of(ZoneOffset.of(zoneID.substring(3)));
            }
            catch (IllegalArgumentException ex) {
                throw new CalendricalException("Invalid time zone ID: " + ex.toString(), ex);
            }
        }
        int pos = zoneID.indexOf(58);
        if (pos >= 0) {
            group = ZoneRulesGroup.getGroup(zoneID.substring(0, pos));
            zoneID = zoneID.substring(pos + 1);
        } else {
            group = ZoneRulesGroup.getGroup("TZDB");
        }
        pos = zoneID.indexOf(35);
        String versionID = "";
        if (pos >= 0) {
            versionID = zoneID.substring(pos + 1);
            zoneID = zoneID.substring(0, pos);
        }
        ZoneRules rules = group.getRules(zoneID, versionID);
        return new TimeZone(group.getID(), zoneID, versionID, rules);
    }

    public static TimeZone of(ZoneOffset offset) {
        ISOChronology.checkNotNull(offset, "ZoneOffset must not be null");
        if (offset == ZoneOffset.UTC) {
            return UTC;
        }
        String id = "UTC" + offset.getID();
        ZoneRules zoneRules = ZoneRules.fixed(offset);
        return new TimeZone("", id, "", zoneRules);
    }

    private TimeZone(String groupID, String regionID, String versionID, ZoneRules rules) {
        this.groupID = groupID;
        this.regionID = regionID;
        this.versionID = versionID;
        this.rules = rules;
    }

    private Object readResolve() {
        if (this.isFixed()) {
            if ("UTC".equals(this.regionID)) {
                return UTC;
            }
            return TimeZone.of(this.getID());
        }
        return this;
    }

    public String getID() {
        if (this.isFixed()) {
            return this.regionID;
        }
        if (this.groupID.equals("TZDB")) {
            return this.regionID + (this.versionID.length() == 0 ? "" : "#" + this.versionID);
        }
        return this.groupID + ":" + this.regionID + (this.versionID.length() == 0 ? "" : "#" + this.versionID);
    }

    public String getGroupID() {
        return this.groupID;
    }

    public String getRegionID() {
        return this.regionID;
    }

    public String getVersionID() {
        return this.versionID;
    }

    public boolean isFixed() {
        return this.groupID.length() == 0;
    }

    public boolean isFloatingVersion() {
        return this.isFixed() || this.versionID.length() == 0;
    }

    public TimeZone withFloatingVersion() {
        if (this.isFloatingVersion()) {
            return this;
        }
        return new TimeZone(this.groupID, this.regionID, "", null);
    }

    public boolean isLatestVersion() {
        return this.isFloatingVersion() || this.versionID.equals(this.getGroup().getLatestVersionID(this.regionID));
    }

    public TimeZone withLatestVersion() {
        if (this.isFloatingVersion()) {
            return this;
        }
        String versionID = this.getGroup().getLatestVersionID(this.regionID);
        if (versionID.equals(this.versionID)) {
            return this;
        }
        return new TimeZone(this.groupID, this.regionID, versionID, this.rules);
    }

    public TimeZone withVersion(String versionID) {
        ISOChronology.checkNotNull(versionID, "Version ID must not be null");
        if (this.isFixed()) {
            if (versionID.length() > 0) {
                throw new CalendricalException("Fixed time zone does not provide versions");
            }
            return this;
        }
        ZoneRules rules = this.getGroup().getRules(this.regionID, versionID);
        if (versionID.equals(this.versionID)) {
            return this;
        }
        return new TimeZone(this.groupID, this.regionID, versionID, rules);
    }

    public TimeZone withLatestVersionValidFor(OffsetDateTime dateTime) {
        ISOChronology.checkNotNull(dateTime, "OffsetDateTime must not be null");
        if (this.isFixed()) {
            if (!this.getRules().getOffset(dateTime).equals(dateTime.getOffset())) {
                throw new CalendricalException("Fixed time zone " + this.getID() + " is invalid for date-time " + dateTime);
            }
            return this;
        }
        return this.withVersion(this.getGroup().getLatestVersionIDValidFor(this.regionID, dateTime));
    }

    public ZoneRulesGroup getGroup() {
        if (this.isFixed()) {
            throw new CalendricalException("Fixed time zone is not provided by a group");
        }
        return ZoneRulesGroup.getGroup(this.groupID);
    }

    public boolean isValid() {
        if (this.isFixed()) {
            return true;
        }
        if (!ZoneRulesGroup.isValidGroup(this.groupID)) {
            return false;
        }
        ZoneRulesGroup group = ZoneRulesGroup.getGroup(this.groupID);
        return group.isValidRules(this.regionID, this.versionID);
    }

    public ZoneRules getRules() {
        if (this.rules != null) {
            return this.rules;
        }
        ZoneRulesGroup group = ZoneRulesGroup.getGroup(this.groupID);
        ZoneRules r = group.getRules(this.regionID, this.versionID);
        if (this.versionID.length() > 0) {
            this.rules = r;
        }
        return r;
    }

    public boolean isValidFor(OffsetDateTime dateTime) {
        if (dateTime == null) {
            return false;
        }
        if (this.isFixed()) {
            return this.getRules().getOffset(dateTime).equals(dateTime.getOffset());
        }
        if (!ZoneRulesGroup.isValidGroup(this.groupID)) {
            return false;
        }
        ZoneRulesGroup group = ZoneRulesGroup.getGroup(this.groupID);
        return group.isValidRulesFor(this.regionID, this.versionID, dateTime);
    }

    public ZoneRules getRulesValidFor(OffsetDateTime dateTime) {
        ISOChronology.checkNotNull(dateTime, "OffsetDateTime must not be null");
        if (this.isFixed()) {
            if (!this.getRules().getOffset(dateTime).equals(dateTime.getOffset())) {
                throw new CalendricalException("Fixed time zone " + this.getID() + " is invalid for date-time " + dateTime);
            }
            return ZoneRules.fixed(this.getRules().getOffset(dateTime));
        }
        ZoneRulesGroup group = ZoneRulesGroup.getGroup(this.groupID);
        return group.getRulesValidFor(this.regionID, this.versionID, dateTime);
    }

    public String getName() {
        return this.regionID;
    }

    public String getShortName() {
        return this.regionID;
    }

    public boolean equals(Object otherZone) {
        if (this == otherZone) {
            return true;
        }
        if (otherZone instanceof TimeZone) {
            TimeZone zone = (TimeZone)otherZone;
            return this.regionID.equals(zone.regionID) && this.versionID.equals(zone.versionID) && this.groupID.equals(zone.groupID);
        }
        return false;
    }

    public int hashCode() {
        return this.groupID.hashCode() ^ this.regionID.hashCode() ^ this.versionID.hashCode();
    }

    public String toString() {
        return this.getID();
    }

    @Override
    public <T> T get(CalendricalRule<T> rule) {
        if (rule.equals(ZoneOffset.rule()) && this.isFixed()) {
            return rule.reify(this.getRules().getOffset(Instant.EPOCH));
        }
        return TimeZone.rule().deriveValueFor(rule, this, this);
    }

    public static CalendricalRule<TimeZone> rule() {
        return Rule.INSTANCE;
    }

    static final class Rule
    extends CalendricalRule<TimeZone>
    implements Serializable {
        private static final CalendricalRule<TimeZone> INSTANCE = new Rule();
        private static final long serialVersionUID = 1L;

        private Rule() {
            super(TimeZone.class, ISOChronology.INSTANCE, "TimeZone", null, null);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected TimeZone derive(Calendrical calendrical) {
            ZonedDateTime zdt = calendrical.get(ZonedDateTime.rule());
            return zdt != null ? zdt.getZone() : null;
        }
    }
}

