/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalRule;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.OffsetDate;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.OffsetTime;
import javax.time.calendar.TimeZone;
import javax.time.period.Period;
import javax.time.period.PeriodProvider;

public final class ZoneOffset
implements Calendrical,
Comparable<ZoneOffset>,
Serializable {
    private static final ReadWriteLock CACHE_LOCK = new ReentrantReadWriteLock();
    private static final Map<Integer, ZoneOffset> SECONDS_CACHE = new HashMap<Integer, ZoneOffset>();
    private static final Map<String, ZoneOffset> ID_CACHE = new HashMap<String, ZoneOffset>();
    public static final ZoneOffset UTC = ZoneOffset.hoursMinutesSeconds(0, 0, 0);
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int MINUTES_PER_HOUR = 60;
    private static final long serialVersionUID = 3552876348982168937L;
    private final String id;
    private final transient int amountSeconds;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZoneOffset of(String offsetID) {
        int seconds;
        int minutes;
        int hours;
        if (offsetID == null) {
            throw new NullPointerException("The offset ID must not be null");
        }
        CACHE_LOCK.readLock().lock();
        try {
            ZoneOffset offset = ID_CACHE.get(offsetID);
            if (offset != null) {
                ZoneOffset zoneOffset = offset;
                return zoneOffset;
            }
        }
        finally {
            CACHE_LOCK.readLock().unlock();
        }
        int len = offsetID.length();
        switch (len) {
            case 3: {
                hours = ZoneOffset.parseNumber(offsetID, 1, false);
                minutes = 0;
                seconds = 0;
                break;
            }
            case 5: {
                hours = ZoneOffset.parseNumber(offsetID, 1, false);
                minutes = ZoneOffset.parseNumber(offsetID, 3, false);
                seconds = 0;
                break;
            }
            case 6: {
                hours = ZoneOffset.parseNumber(offsetID, 1, false);
                minutes = ZoneOffset.parseNumber(offsetID, 4, true);
                seconds = 0;
                break;
            }
            case 7: {
                hours = ZoneOffset.parseNumber(offsetID, 1, false);
                minutes = ZoneOffset.parseNumber(offsetID, 3, false);
                seconds = ZoneOffset.parseNumber(offsetID, 5, false);
                break;
            }
            case 9: {
                hours = ZoneOffset.parseNumber(offsetID, 1, false);
                minutes = ZoneOffset.parseNumber(offsetID, 4, true);
                seconds = ZoneOffset.parseNumber(offsetID, 7, true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Zone offset id '" + offsetID + "' is invalid");
            }
        }
        char first = offsetID.charAt(0);
        if (first != '+' && first != '-') {
            throw new IllegalArgumentException("Zone offset id '" + offsetID + "' is invalid: Plus/minus not found when expected");
        }
        if (first == '-') {
            return ZoneOffset.hoursMinutesSeconds(-hours, -minutes, -seconds);
        }
        return ZoneOffset.hoursMinutesSeconds(hours, minutes, seconds);
    }

    private static int parseNumber(String offsetID, int pos, boolean precededByColon) {
        if (precededByColon && offsetID.charAt(pos - 1) != ':') {
            throw new IllegalArgumentException("Zone offset id '" + offsetID + "' is invalid: Colon not found when expected");
        }
        char ch1 = offsetID.charAt(pos);
        char ch2 = offsetID.charAt(pos + 1);
        if (ch1 < '0' || ch1 > '9' || ch2 < '0' || ch2 > '9') {
            throw new IllegalArgumentException("Zone offset id '" + offsetID + "' is invalid: Non numeric characters found");
        }
        return (ch1 - 48) * 10 + (ch2 - 48);
    }

    public static ZoneOffset hours(int hours) {
        return ZoneOffset.hoursMinutesSeconds(hours, 0, 0);
    }

    public static ZoneOffset hoursMinutes(int hours, int minutes) {
        return ZoneOffset.hoursMinutesSeconds(hours, minutes, 0);
    }

    public static ZoneOffset hoursMinutesSeconds(int hours, int minutes, int seconds) {
        ZoneOffset.validate(hours, minutes, seconds);
        int totalSeconds = ZoneOffset.totalSeconds(hours, minutes, seconds);
        return ZoneOffset.fromTotalSeconds(totalSeconds);
    }

    private static void validate(int hours, int minutes, int seconds) {
        if (hours < -18 || hours > 18) {
            throw new IllegalArgumentException("Zone offset hours not in valid range: value " + hours + " is not in the range -18 to 18");
        }
        if (hours > 0) {
            if (minutes < 0 || seconds < 0) {
                throw new IllegalArgumentException("Zone offset minutes and seconds must be positive because hours is positive");
            }
        } else if (hours < 0) {
            if (minutes > 0 || seconds > 0) {
                throw new IllegalArgumentException("Zone offset minutes and seconds must be negative because hours is negative");
            }
        } else if (minutes > 0 && seconds < 0 || minutes < 0 && seconds > 0) {
            throw new IllegalArgumentException("Zone offset minutes and seconds must have the same sign");
        }
        if (Math.abs(minutes) > 59) {
            throw new IllegalArgumentException("Zone offset minutes not in valid range: value " + Math.abs(minutes) + " is not in the range 0 to 59");
        }
        if (Math.abs(seconds) > 59) {
            throw new IllegalArgumentException("Zone offset seconds not in valid range: value " + Math.abs(seconds) + " is not in the range 0 to 59");
        }
        if (Math.abs(hours) == 18 && (Math.abs(minutes) > 0 || Math.abs(seconds) > 0)) {
            throw new IllegalArgumentException("Zone offset not in valid range: -18:00 to +18:00");
        }
    }

    private static int totalSeconds(int hours, int minutes, int seconds) {
        return hours * 3600 + minutes * 60 + seconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZoneOffset fromTotalSeconds(int totalSeconds) {
        if (Math.abs(totalSeconds) > 64800) {
            throw new IllegalArgumentException("Zone offset not in valid range: -18:00 to +18:00");
        }
        if (totalSeconds % 900 == 0) {
            ZoneOffset result;
            Integer totalSecs = totalSeconds;
            CACHE_LOCK.readLock().lock();
            try {
                result = SECONDS_CACHE.get(totalSecs);
                if (result != null) {
                    ZoneOffset zoneOffset = result;
                    return zoneOffset;
                }
            }
            finally {
                CACHE_LOCK.readLock().unlock();
            }
            CACHE_LOCK.writeLock().lock();
            try {
                result = SECONDS_CACHE.get(totalSecs);
                if (result == null) {
                    result = new ZoneOffset(totalSeconds);
                    SECONDS_CACHE.put(totalSecs, result);
                    ID_CACHE.put(result.getID(), result);
                }
                ZoneOffset zoneOffset = result;
                return zoneOffset;
            }
            finally {
                CACHE_LOCK.writeLock().unlock();
            }
        }
        return new ZoneOffset(totalSeconds);
    }

    private ZoneOffset(int totalSeconds) {
        this.amountSeconds = totalSeconds;
        if (this.amountSeconds == 0) {
            this.id = "Z";
        } else {
            int absTotalSeconds = Math.abs(this.amountSeconds);
            StringBuilder buf = new StringBuilder();
            int absHours = absTotalSeconds / 3600;
            int absMinutes = absTotalSeconds / 60 % 60;
            buf.append(this.amountSeconds < 0 ? "-" : "+").append(absHours < 10 ? "0" : "").append(absHours).append(absMinutes < 10 ? ":0" : ":").append(absMinutes);
            int absSeconds = absTotalSeconds % 60;
            if (absSeconds != 0) {
                buf.append(absSeconds < 10 ? ":0" : ":").append(absSeconds);
            }
            this.id = buf.toString();
        }
    }

    private Object readResolve() {
        return ZoneOffset.of(this.id);
    }

    public int getAmountSeconds() {
        return this.amountSeconds;
    }

    public String getID() {
        return this.id;
    }

    public int getHoursField() {
        return this.amountSeconds / 3600;
    }

    public int getMinutesField() {
        return this.amountSeconds / 60 % 60;
    }

    public int getSecondsField() {
        return this.amountSeconds % 60;
    }

    public ZoneOffset plus(PeriodProvider periodProvider) {
        Period otherPeriod = Period.from(periodProvider);
        otherPeriod = Period.hoursMinutesSeconds(otherPeriod.getHours(), otherPeriod.getMinutes(), otherPeriod.getSeconds());
        Period thisPeriod = this.toPeriod();
        Period combined = thisPeriod.plus(otherPeriod).normalized();
        return ZoneOffset.hoursMinutesSeconds(combined.getHours(), combined.getMinutes(), combined.getSeconds());
    }

    public Period toPeriod() {
        return Period.hoursMinutesSeconds(this.getHoursField(), this.getMinutesField(), this.getSecondsField());
    }

    public TimeZone toTimeZone() {
        return TimeZone.of(this);
    }

    @Override
    public int compareTo(ZoneOffset other) {
        return other.amountSeconds - this.amountSeconds;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ZoneOffset) {
            return this.amountSeconds == ((ZoneOffset)other).amountSeconds;
        }
        return false;
    }

    public int hashCode() {
        return this.amountSeconds;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public <T> T get(CalendricalRule<T> rule) {
        return ZoneOffset.rule().deriveValueFor(rule, this, this);
    }

    public static CalendricalRule<ZoneOffset> rule() {
        return Rule.INSTANCE;
    }

    static final class Rule
    extends CalendricalRule<ZoneOffset>
    implements Serializable {
        private static final CalendricalRule<ZoneOffset> INSTANCE = new Rule();
        private static final long serialVersionUID = 1L;

        private Rule() {
            super(ZoneOffset.class, ISOChronology.INSTANCE, "ZoneOffset", null, null);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected ZoneOffset derive(Calendrical calendrical) {
            OffsetDateTime odt = calendrical.get(OffsetDateTime.rule());
            if (odt != null) {
                return odt.getOffset();
            }
            OffsetDate od = calendrical.get(OffsetDate.rule());
            if (od != null) {
                return od.getOffset();
            }
            OffsetTime ot = calendrical.get(OffsetTime.rule());
            if (ot != null) {
                return ot.getOffset();
            }
            return null;
        }
    }
}

