/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import javax.time.CalendricalException;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.TimeZone;
import javax.time.calendar.ZonedDateTime;
import javax.time.calendar.zone.ZoneOffsetTransition;
import javax.time.calendar.zone.ZoneRules;

public abstract class ZoneResolver {
    protected ZoneResolver() {
    }

    public final OffsetDateTime resolve(TimeZone zone, LocalDateTime newDateTime, ZonedDateTime oldDateTime) {
        OffsetDateTime result;
        ZoneRules rules = oldDateTime != null ? oldDateTime.getApplicableRules() : zone.getRules();
        ZoneRules.OffsetInfo info = rules.getOffsetInfo(newDateTime);
        if (!info.isTransition()) {
            return OffsetDateTime.from(newDateTime, info.getOffset());
        }
        ZoneOffsetTransition discontinuity = info.getTransition();
        OffsetDateTime offsetDateTime = discontinuity.isGap() ? this.handleGap(zone, rules, discontinuity, newDateTime, oldDateTime != null ? oldDateTime.toOffsetDateTime() : null) : (result = this.handleOverlap(zone, rules, discontinuity, newDateTime, oldDateTime != null ? oldDateTime.toOffsetDateTime() : null));
        if (result == null) {
            throw new CalendricalException("ZoneResolver implementation must not return null: " + this.getClass().getName());
        }
        if (!zone.isValidFor(result)) {
            throw new CalendricalException("ZoneResolver implementation must return a valid date-time and offset for the zone: " + this.getClass().getName());
        }
        return result;
    }

    protected abstract OffsetDateTime handleGap(TimeZone var1, ZoneRules var2, ZoneOffsetTransition var3, LocalDateTime var4, OffsetDateTime var5);

    protected abstract OffsetDateTime handleOverlap(TimeZone var1, ZoneRules var2, ZoneOffsetTransition var3, LocalDateTime var4, OffsetDateTime var5);
}

