/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.format;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.time.calendar.Calendrical;
import javax.time.calendar.format.DateTimeFormatSymbols;
import javax.time.calendar.format.DateTimeParseContext;
import javax.time.calendar.format.DateTimeParser;
import javax.time.calendar.format.DateTimePrinter;

final class CompositePrinterParser
implements DateTimePrinter,
DateTimeParser {
    private final DateTimePrinter[] printers;
    private final DateTimeParser[] parsers;
    private final boolean optional;

    CompositePrinterParser(List<DateTimePrinter> printers, List<DateTimeParser> parsers, boolean optional) {
        this.printers = printers.contains(null) ? null : printers.toArray(new DateTimePrinter[printers.size()]);
        this.parsers = parsers.contains(null) ? null : parsers.toArray(new DateTimeParser[parsers.size()]);
        this.optional = optional;
    }

    public CompositePrinterParser withOptional(boolean optional) {
        if (optional == this.optional) {
            return this;
        }
        return new CompositePrinterParser(Arrays.asList(this.printers), Arrays.asList(this.parsers), optional);
    }

    public boolean isPrintSupported() {
        return this.printers != null;
    }

    @Override
    public void print(Calendrical calendrical, Appendable appendable, DateTimeFormatSymbols symbols) throws IOException {
        if (this.printers == null) {
            throw new UnsupportedOperationException("Formatter does not support printing");
        }
        if (this.optional) {
            for (DateTimePrinter printer : this.printers) {
                if (printer.isPrintDataAvailable(calendrical)) continue;
                return;
            }
        }
        for (DateTimePrinter printer : this.printers) {
            printer.print(calendrical, appendable, symbols);
        }
    }

    @Override
    public boolean isPrintDataAvailable(Calendrical calendrical) {
        if (this.optional) {
            return true;
        }
        for (DateTimePrinter printer : this.printers) {
            if (printer.isPrintDataAvailable(calendrical)) continue;
            return false;
        }
        return true;
    }

    public boolean isParseSupported() {
        return this.parsers != null;
    }

    @Override
    public int parse(DateTimeParseContext context, String parseText, int position) {
        DateTimeParser parser;
        if (this.parsers == null) {
            throw new UnsupportedOperationException("Formatter does not support parsing");
        }
        if (this.optional) {
            context.startOptional();
            int pos = position;
            for (DateTimeParser parser2 : this.parsers) {
                if ((pos = parser2.parse(context, parseText, pos)) >= 0) continue;
                context.endOptional(false);
                return position;
            }
            context.endOptional(true);
            return pos;
        }
        DateTimeParser[] arr$ = this.parsers;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (position = (parser = arr$[i$]).parse(context, parseText, position)) >= 0; ++i$) {
        }
        return position;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.printers != null) {
            buf.append(this.optional ? "[" : "(");
            for (DateTimePrinter printer : this.printers) {
                buf.append(printer);
            }
            buf.append(this.optional ? "]" : ")");
        }
        return buf.toString();
    }
}

