/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.format;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.time.calendar.Chronology;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.format.CaseSensitivePrinterParser;
import javax.time.calendar.format.CharLiteralPrinterParser;
import javax.time.calendar.format.CompositePrinterParser;
import javax.time.calendar.format.DateTimeFormatter;
import javax.time.calendar.format.DateTimeParser;
import javax.time.calendar.format.DateTimePrinter;
import javax.time.calendar.format.FractionPrinterParser;
import javax.time.calendar.format.LocalizedPrinterParser;
import javax.time.calendar.format.NumberPrinterParser;
import javax.time.calendar.format.PadPrinterParserDecorator;
import javax.time.calendar.format.StrictLenientPrinterParser;
import javax.time.calendar.format.StringLiteralPrinterParser;
import javax.time.calendar.format.TextPrinterParser;
import javax.time.calendar.format.ZoneOffsetPrinterParser;
import javax.time.calendar.format.ZonePrinterParser;

public final class DateTimeFormatterBuilder {
    private DateTimeFormatterBuilder active = this;
    private final DateTimeFormatterBuilder parent;
    private final List<DateTimePrinter> printers = new ArrayList<DateTimePrinter>();
    private final List<DateTimeParser> parsers = new ArrayList<DateTimeParser>();
    private final boolean optional;
    private int padNextWidth;
    private char padNextChar;
    private int valueParserIndex = -1;
    private static final Map<Character, DateTimeFieldRule<?>> RULE_MAP = new HashMap();

    public DateTimeFormatterBuilder() {
        this.parent = null;
        this.optional = false;
    }

    private DateTimeFormatterBuilder(DateTimeFormatterBuilder parent, boolean optional) {
        this.parent = parent;
        this.optional = optional;
    }

    static void checkNotNull(Object object, String errorMessage) {
        if (object == null) {
            throw new NullPointerException(errorMessage);
        }
    }

    public DateTimeFormatterBuilder parseCaseSensitive() {
        this.appendInternal(CaseSensitivePrinterParser.SENSITIVE, CaseSensitivePrinterParser.SENSITIVE);
        return this;
    }

    public DateTimeFormatterBuilder parseCaseInsensitive() {
        this.appendInternal(CaseSensitivePrinterParser.INSENSITIVE, CaseSensitivePrinterParser.INSENSITIVE);
        return this;
    }

    public DateTimeFormatterBuilder parseStrict() {
        this.appendInternal(StrictLenientPrinterParser.STRICT, StrictLenientPrinterParser.STRICT);
        return this;
    }

    public DateTimeFormatterBuilder parseLenient() {
        this.appendInternal(StrictLenientPrinterParser.LENIENT, StrictLenientPrinterParser.LENIENT);
        return this;
    }

    public DateTimeFormatterBuilder appendValue(DateTimeFieldRule<?> rule) {
        DateTimeFormatterBuilder.checkNotNull(rule, "DateTimeFieldRule must not be null");
        NumberPrinterParser pp = new NumberPrinterParser(rule, 1, 10, SignStyle.NORMAL);
        this.active.valueParserIndex = this.appendInternal(pp, pp);
        return this;
    }

    public DateTimeFormatterBuilder appendValue(DateTimeFieldRule<?> rule, int width) {
        DateTimeFormatterBuilder.checkNotNull(rule, "DateTimeFieldRule must not be null");
        if (width < 1 || width > 10) {
            throw new IllegalArgumentException("The width must be from 1 to 10 inclusive but was " + width);
        }
        NumberPrinterParser pp = new NumberPrinterParser(rule, width, width, SignStyle.NOT_NEGATIVE);
        if (this.active.valueParserIndex >= 0) {
            NumberPrinterParser basePP = (NumberPrinterParser)this.active.printers.get(this.active.valueParserIndex);
            basePP = basePP.withSubsequentWidth(width);
            int activeValueParser = this.active.valueParserIndex;
            this.active.printers.set(this.active.valueParserIndex, basePP);
            this.active.parsers.set(this.active.valueParserIndex, basePP);
            this.appendInternal(pp, pp);
            this.active.valueParserIndex = activeValueParser;
        } else {
            this.appendInternal(pp, pp);
        }
        return this;
    }

    public DateTimeFormatterBuilder appendValue(DateTimeFieldRule<?> rule, int minWidth, int maxWidth, SignStyle signStyle) {
        if (minWidth == maxWidth && signStyle == SignStyle.NOT_NEGATIVE) {
            return this.appendValue(rule, maxWidth);
        }
        DateTimeFormatterBuilder.checkNotNull(rule, "DateTimeFieldRule must not be null");
        DateTimeFormatterBuilder.checkNotNull((Object)signStyle, "SignStyle must not be null");
        if (minWidth < 1 || minWidth > 10) {
            throw new IllegalArgumentException("The minimum width must be from 1 to 10 inclusive but was " + minWidth);
        }
        if (maxWidth < 1 || maxWidth > 10) {
            throw new IllegalArgumentException("The maximum width must be from 1 to 10 inclusive but was " + maxWidth);
        }
        if (maxWidth < minWidth) {
            throw new IllegalArgumentException("The maximum width must exceed or equal the minimum width but " + maxWidth + " < " + minWidth);
        }
        NumberPrinterParser pp = new NumberPrinterParser(rule, minWidth, maxWidth, signStyle);
        if (minWidth == maxWidth) {
            this.appendInternal(pp, pp);
        } else {
            this.active.valueParserIndex = this.appendInternal(pp, pp);
        }
        return this;
    }

    public DateTimeFormatterBuilder appendFraction(DateTimeFieldRule<?> rule, int minWidth, int maxWidth) {
        DateTimeFormatterBuilder.checkNotNull(rule, "DateTimeFieldRule must not be null");
        if (!rule.isFixedValueSet()) {
            throw new IllegalArgumentException("The field does not have a fixed set of values");
        }
        if (rule.getMinimumValue() != 0) {
            throw new IllegalArgumentException("The field does not have a minimum value of zero");
        }
        if (minWidth < 0 || minWidth > 9) {
            throw new IllegalArgumentException("The minimum width must be from 0 to 9 inclusive but was " + minWidth);
        }
        if (maxWidth < 1 || maxWidth > 9) {
            throw new IllegalArgumentException("The maximum width must be from 1 to 9 inclusive but was " + maxWidth);
        }
        if (maxWidth < minWidth) {
            throw new IllegalArgumentException("The maximum width must exceed or equal the minimum width but " + maxWidth + " < " + minWidth);
        }
        FractionPrinterParser pp = new FractionPrinterParser(rule, minWidth, maxWidth);
        this.appendInternal(pp, pp);
        return this;
    }

    public DateTimeFormatterBuilder appendText(DateTimeFieldRule<?> rule) {
        return this.appendText(rule, TextStyle.FULL);
    }

    public DateTimeFormatterBuilder appendText(DateTimeFieldRule<?> rule, TextStyle textStyle) {
        DateTimeFormatterBuilder.checkNotNull(rule, "DateTimeFieldRule must not be null");
        DateTimeFormatterBuilder.checkNotNull((Object)textStyle, "TextStyle must not be null");
        TextPrinterParser pp = new TextPrinterParser(rule, textStyle);
        this.appendInternal(pp, pp);
        return this;
    }

    public DateTimeFormatterBuilder appendOffsetId() {
        return this.appendOffset("Z", true, true);
    }

    public DateTimeFormatterBuilder appendOffset(String utcText, boolean includeColon, boolean allowSeconds) {
        DateTimeFormatterBuilder.checkNotNull(utcText, "UTC text must not be null");
        ZoneOffsetPrinterParser pp = new ZoneOffsetPrinterParser(utcText, includeColon, allowSeconds);
        this.appendInternal(pp, pp);
        return this;
    }

    public DateTimeFormatterBuilder appendZoneId() {
        ZonePrinterParser pp = new ZonePrinterParser();
        this.appendInternal(pp, pp);
        return this;
    }

    public DateTimeFormatterBuilder appendZoneText(TextStyle textStyle) {
        DateTimeFormatterBuilder.checkNotNull((Object)textStyle, "TextStyle must not be null");
        ZonePrinterParser pp = new ZonePrinterParser(textStyle);
        this.appendInternal(pp, pp);
        return this;
    }

    public DateTimeFormatterBuilder appendLocalized(FormatStyle dateStyle, FormatStyle timeStyle) {
        return this.appendLocalized(dateStyle, timeStyle, ISOChronology.INSTANCE);
    }

    public DateTimeFormatterBuilder appendLocalized(FormatStyle dateStyle, FormatStyle timeStyle, Chronology chronology) {
        DateTimeFormatterBuilder.checkNotNull(chronology, "Chronology must not be null");
        if (dateStyle != null || timeStyle != null) {
            LocalizedPrinterParser pp = new LocalizedPrinterParser(dateStyle, timeStyle, chronology);
            this.appendInternal(pp, pp);
        }
        return this;
    }

    public DateTimeFormatterBuilder appendLiteral(char literal) {
        CharLiteralPrinterParser pp = new CharLiteralPrinterParser(literal);
        this.appendInternal(pp, pp);
        return this;
    }

    public DateTimeFormatterBuilder appendLiteral(String literal) {
        DateTimeFormatterBuilder.checkNotNull(literal, "Literal text must not be null");
        if (literal.length() > 0) {
            if (literal.length() == 1) {
                CharLiteralPrinterParser pp = new CharLiteralPrinterParser(literal.charAt(0));
                this.appendInternal(pp, pp);
            } else {
                StringLiteralPrinterParser pp = new StringLiteralPrinterParser(literal);
                this.appendInternal(pp, pp);
            }
        }
        return this;
    }

    public DateTimeFormatterBuilder append(DateTimePrinter printer, DateTimeParser parser) {
        if (printer == null && parser == null) {
            throw new NullPointerException("One of DateTimePrinter or DateTimeParser must be non-null");
        }
        this.appendInternal(printer, parser);
        return this;
    }

    public DateTimeFormatterBuilder append(DateTimeFormatter formatter) {
        DateTimeFormatterBuilder.checkNotNull(formatter, "DateTimeFormatter must not be null");
        CompositePrinterParser cpp = formatter.toPrinterParser(false);
        this.appendInternal(cpp, cpp);
        return this;
    }

    public DateTimeFormatterBuilder appendOptional(DateTimeFormatter formatter) {
        DateTimeFormatterBuilder.checkNotNull(formatter, "DateTimeFormatter must not be null");
        CompositePrinterParser cpp = formatter.toPrinterParser(true);
        this.appendInternal(cpp, cpp);
        return this;
    }

    public DateTimeFormatterBuilder appendPattern(String pattern) {
        DateTimeFormatterBuilder.checkNotNull(pattern, "Pattern must not be null");
        this.parsePattern(pattern);
        return this;
    }

    private void parsePattern(String pattern) {
        for (int pos = 0; pos < pattern.length(); ++pos) {
            int start;
            char cur = pattern.charAt(pos);
            if (cur >= 'A' && cur <= 'Z' || cur >= 'a' && cur <= 'z') {
                DateTimeFieldRule<?> rule;
                start = pos++;
                while (pos < pattern.length() && pattern.charAt(pos) == cur) {
                    ++pos;
                }
                int count = pos - start;
                if (cur == 'p') {
                    int pad = 0;
                    if (pos < pattern.length() && ((cur = pattern.charAt(pos)) >= 'A' && cur <= 'Z' || cur >= 'a' && cur <= 'z')) {
                        pad = count;
                        start = pos++;
                        while (pos < pattern.length() && pattern.charAt(pos) == cur) {
                            ++pos;
                        }
                        count = pos - start;
                    }
                    if (pad == 0) {
                        throw new IllegalArgumentException("Pad letter 'p' must be followed by valid pad pattern: " + pattern);
                    }
                    this.padNext(pad);
                }
                int fraction = 0;
                if (cur == 'f') {
                    if (pos < pattern.length() && ((cur = pattern.charAt(pos)) == 'H' || cur == 'K' || cur == 'm' || cur == 's' || cur == 'S' || cur == 'n')) {
                        fraction = count;
                        start = pos++;
                        while (pos < pattern.length() && pattern.charAt(pos) == cur) {
                            ++pos;
                        }
                        count = pos - start;
                    }
                    if (fraction == 0) {
                        throw new IllegalArgumentException("Fraction letter 'f' must be followed by valid fraction pattern: " + pattern);
                    }
                }
                if ((rule = RULE_MAP.get(Character.valueOf(cur))) == null) {
                    if (cur == 'z') {
                        if (count < 4) {
                            this.appendZoneText(TextStyle.SHORT);
                        } else {
                            this.appendZoneText(TextStyle.FULL);
                        }
                    } else if (cur == 'I') {
                        this.appendZoneId();
                    } else if (cur == 'Z') {
                        this.appendOffset(count == 1 ? "+0000" : (count == 2 ? "+00:00" : "Z"), count == 2 || count >= 4, count >= 3);
                    } else {
                        this.appendLiteral(pattern.substring(start, pos));
                    }
                } else {
                    this.parseRule(cur, count, rule, fraction);
                }
                fraction = 0;
                --pos;
                continue;
            }
            if (cur == '\'') {
                start = pos++;
                while (pos < pattern.length()) {
                    if (pattern.charAt(pos) == '\'') {
                        if (pos + 1 >= pattern.length() || pattern.charAt(pos + 1) != '\'') break;
                        ++pos;
                    }
                    ++pos;
                }
                if (pos >= pattern.length()) {
                    throw new IllegalArgumentException("Pattern ends with an incomplete string literal: " + pattern);
                }
                String str = pattern.substring(start + 1, pos);
                if (str.length() == 0) {
                    this.appendLiteral('\'');
                    continue;
                }
                this.appendLiteral(str.replace("''", "'"));
                continue;
            }
            if (cur == '[') {
                this.optionalStart();
                continue;
            }
            if (cur == ']') {
                if (this.active.parent == null) {
                    throw new IllegalArgumentException("Pattern invalid as it contains ] without previous [");
                }
                this.optionalEnd();
                continue;
            }
            this.appendLiteral(cur);
        }
    }

    private void parseRule(char cur, int count, DateTimeFieldRule<?> rule, int fraction) {
        block0 : switch (cur) {
            case 'x': 
            case 'y': {
                if (count < 4) {
                    this.appendValue(rule, count, 10, SignStyle.NORMAL);
                    break;
                }
                this.appendValue(rule, count, 10, SignStyle.EXCEEDS_PAD);
                break;
            }
            case 'M': {
                switch (count) {
                    case 1: {
                        this.appendValue(rule);
                        break block0;
                    }
                    case 2: {
                        this.appendValue(rule, 2);
                        break block0;
                    }
                    case 3: {
                        this.appendText(rule, TextStyle.SHORT);
                        break block0;
                    }
                }
                this.appendText(rule, TextStyle.FULL);
                break;
            }
            case 'E': 
            case 'a': {
                if (count < 4) {
                    this.appendText(rule, TextStyle.SHORT);
                    break;
                }
                this.appendText(rule, TextStyle.FULL);
                break;
            }
            default: {
                if (fraction > 0) {
                    this.appendFraction(rule, count, fraction == 1 ? count : 9);
                    break;
                }
                if (count == 1) {
                    this.appendValue(rule);
                    break;
                }
                this.appendValue(rule, count);
            }
        }
    }

    public DateTimeFormatterBuilder padNext(int padWidth) {
        return this.padNext(padWidth, ' ');
    }

    public DateTimeFormatterBuilder padNext(int padWidth, char padChar) {
        if (padWidth < 1) {
            throw new IllegalArgumentException("The pad width must be at least one but was " + padWidth);
        }
        this.active.padNextWidth = padWidth;
        this.active.padNextChar = padChar;
        this.active.valueParserIndex = -1;
        return this;
    }

    public DateTimeFormatterBuilder optionalStart() {
        this.active.valueParserIndex = -1;
        this.active = new DateTimeFormatterBuilder(this.active, true);
        return this;
    }

    public DateTimeFormatterBuilder optionalEnd() {
        if (this.active.parent == null) {
            throw new IllegalStateException("Cannot call optionalEnd() as there was no previous call to optionalStart()");
        }
        if (this.active.printers.size() > 0) {
            CompositePrinterParser cpp = new CompositePrinterParser(this.active.printers, this.active.parsers, this.active.optional);
            this.active = this.active.parent;
            this.appendInternal(cpp, cpp);
        } else {
            this.active = this.active.parent;
        }
        return this;
    }

    private int appendInternal(DateTimePrinter printer, DateTimeParser parser) {
        if (this.active.padNextWidth > 0) {
            if (printer != null || parser != null) {
                printer = new PadPrinterParserDecorator(printer, parser, this.active.padNextWidth, this.active.padNextChar);
            }
            this.active.padNextWidth = 0;
            this.active.padNextChar = '\u0000';
        }
        this.active.printers.add(printer);
        this.active.parsers.add(parser);
        this.active.valueParserIndex = -1;
        return this.active.printers.size() - 1;
    }

    public DateTimeFormatter toFormatter() {
        return this.toFormatter(Locale.getDefault());
    }

    public DateTimeFormatter toFormatter(Locale locale) {
        DateTimeFormatterBuilder.checkNotNull(locale, "Locale must not be null");
        while (this.active.parent != null) {
            this.optionalEnd();
        }
        return new DateTimeFormatter(locale, new CompositePrinterParser(this.printers, this.parsers, false));
    }

    static {
        RULE_MAP.put(Character.valueOf('y'), ISOChronology.yearRule());
        RULE_MAP.put(Character.valueOf('x'), ISOChronology.weekBasedYearRule());
        RULE_MAP.put(Character.valueOf('Q'), ISOChronology.quarterOfYearRule());
        RULE_MAP.put(Character.valueOf('M'), ISOChronology.monthOfYearRule());
        RULE_MAP.put(Character.valueOf('q'), ISOChronology.monthOfQuarterRule());
        RULE_MAP.put(Character.valueOf('w'), ISOChronology.weekOfWeekBasedYearRule());
        RULE_MAP.put(Character.valueOf('D'), ISOChronology.dayOfYearRule());
        RULE_MAP.put(Character.valueOf('d'), ISOChronology.dayOfMonthRule());
        RULE_MAP.put(Character.valueOf('F'), ISOChronology.weekOfMonthRule());
        RULE_MAP.put(Character.valueOf('E'), ISOChronology.dayOfWeekRule());
        RULE_MAP.put(Character.valueOf('e'), ISOChronology.dayOfWeekRule());
        RULE_MAP.put(Character.valueOf('a'), ISOChronology.amPmOfDayRule());
        RULE_MAP.put(Character.valueOf('H'), ISOChronology.hourOfDayRule());
        RULE_MAP.put(Character.valueOf('K'), ISOChronology.hourOfAmPmRule());
        RULE_MAP.put(Character.valueOf('h'), ISOChronology.clockHourOfAmPmRule());
        RULE_MAP.put(Character.valueOf('m'), ISOChronology.minuteOfHourRule());
        RULE_MAP.put(Character.valueOf('s'), ISOChronology.secondOfMinuteRule());
        RULE_MAP.put(Character.valueOf('S'), ISOChronology.milliOfSecondRule());
        RULE_MAP.put(Character.valueOf('n'), ISOChronology.nanoOfSecondRule());
    }

    public static enum FormatStyle {
        FULL,
        LONG,
        MEDIUM,
        SHORT;

    }

    public static enum TextStyle {
        FULL,
        SHORT,
        NARROW;

    }

    public static enum SignStyle {
        NORMAL,
        ALWAYS,
        NEVER,
        NOT_NEGATIVE,
        EXCEEDS_PAD;

    }
}

