/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.format;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.time.calendar.CalendricalContext;
import javax.time.calendar.CalendricalMerger;
import javax.time.calendar.CalendricalRule;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.format.DateTimeFormatSymbols;
import javax.time.calendar.format.DateTimeFormatter;

public final class DateTimeParseContext {
    private final DateTimeFormatSymbols symbols;
    private boolean caseSensitive = true;
    private boolean strict = true;
    private final ArrayList<Parsed> calendricals = new ArrayList();

    public DateTimeParseContext(DateTimeFormatSymbols symbols) {
        DateTimeFormatter.checkNotNull(symbols, "DateTimeFormatSymbols must not be null");
        this.symbols = symbols;
        this.calendricals.add(new Parsed());
    }

    public Locale getLocale() {
        return this.symbols.getLocale();
    }

    public DateTimeFormatSymbols getSymbols() {
        return this.symbols;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    private Parsed currentCalendrical() {
        return this.calendricals.get(this.calendricals.size() - 1);
    }

    public Object getParsed(CalendricalRule<?> rule) {
        DateTimeFormatter.checkNotNull(rule, "CalendricalRule must not be null");
        return this.currentCalendrical().values.get(rule);
    }

    public Set<CalendricalRule<?>> getParsedRules() {
        return this.currentCalendrical().values.keySet();
    }

    public void setParsed(CalendricalRule<?> rule, Object value) {
        DateTimeFormatter.checkNotNull(rule, "CalendricalRule must not be null");
        DateTimeFormatter.checkNotNull(value, "Value must not be null");
        this.currentCalendrical().values.put(rule, value);
    }

    public void setParsed(DateTimeFieldRule<?> rule, int value) {
        DateTimeFormatter.checkNotNull(rule, "DateTimeFieldRule must not be null");
        this.currentCalendrical().values.put(rule, value);
    }

    public void startOptional() {
        this.calendricals.add(this.currentCalendrical().clone());
    }

    public void endOptional(boolean successful) {
        if (successful) {
            this.calendricals.remove(this.calendricals.size() - 2);
        } else {
            this.calendricals.remove(this.calendricals.size() - 1);
        }
    }

    public CalendricalMerger toCalendricalMerger() {
        return new CalendricalMerger(new CalendricalContext(true, true), this.currentCalendrical().values);
    }

    public String toString() {
        return this.currentCalendrical().toString();
    }

    static class Parsed {
        Map<CalendricalRule<?>, Object> values = new HashMap();

        Parsed() {
        }

        protected Parsed clone() {
            Parsed cloned = new Parsed();
            cloned.values.putAll(this.values);
            return cloned;
        }

        public String toString() {
            return new TreeMap(this.values).toString();
        }
    }
}

