/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.format;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.time.calendar.Calendrical;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.format.DateTimeFormatSymbols;
import javax.time.calendar.format.DateTimeParseContext;
import javax.time.calendar.format.DateTimeParser;
import javax.time.calendar.format.DateTimePrinter;

final class FractionPrinterParser
implements DateTimePrinter,
DateTimeParser {
    private final DateTimeFieldRule<?> rule;
    private final int minWidth;
    private final int maxWidth;

    FractionPrinterParser(DateTimeFieldRule<?> rule, int minWidth, int maxWidth) {
        this.rule = rule;
        this.minWidth = minWidth;
        this.maxWidth = maxWidth;
    }

    @Override
    public void print(Calendrical calendrical, Appendable appendable, DateTimeFormatSymbols symbols) throws IOException {
        int value = this.rule.getInt(calendrical);
        BigDecimal fraction = this.rule.convertIntToFraction(value);
        if (fraction.scale() == 0) {
            if (this.minWidth > 0) {
                appendable.append(symbols.getDecimalPointChar());
                for (int i = 0; i < this.minWidth; ++i) {
                    appendable.append(symbols.getZeroChar());
                }
            }
        } else {
            int outputScale = Math.min(Math.max(fraction.scale(), this.minWidth), this.maxWidth);
            fraction = fraction.setScale(outputScale, RoundingMode.FLOOR);
            String str = fraction.toPlainString().substring(2);
            str = symbols.convertNumberToI18N(str);
            appendable.append(symbols.getDecimalPointChar());
            appendable.append(str);
        }
    }

    @Override
    public boolean isPrintDataAvailable(Calendrical calendrical) {
        return calendrical.get(this.rule) != null;
    }

    @Override
    public int parse(DateTimeParseContext context, String parseText, int position) {
        int minEndPos;
        int length = parseText.length();
        if (position == length) {
            if (this.minWidth > 0) {
                return ~position;
            }
            return position;
        }
        char point = parseText.charAt(position);
        if (point != context.getSymbols().getDecimalPointChar()) {
            if (this.minWidth > 0) {
                return ~position;
            }
            return position;
        }
        if ((minEndPos = ++position + this.minWidth) > length) {
            return ~position;
        }
        int maxEndPos = Math.min(position + this.maxWidth, length);
        int total = 0;
        int pos = position;
        while (pos < maxEndPos) {
            char ch = parseText.charAt(pos++);
            int digit = context.getSymbols().convertToDigit(ch);
            if (digit < 0) {
                if (pos < minEndPos) {
                    return ~position;
                }
                --pos;
                break;
            }
            total = total * 10 + digit;
        }
        BigDecimal fraction = new BigDecimal(total).movePointLeft(pos - position);
        int value = this.rule.convertFractionToInt(fraction);
        context.setParsed(this.rule, value);
        return pos;
    }

    public String toString() {
        return "Fraction(" + this.rule.getID() + "," + this.minWidth + "," + this.maxWidth + ")";
    }
}

