/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.format;

import java.io.IOException;
import javax.time.calendar.Calendrical;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.format.CalendricalPrintFieldException;
import javax.time.calendar.format.DateTimeFormatSymbols;
import javax.time.calendar.format.DateTimeFormatterBuilder;
import javax.time.calendar.format.DateTimeParseContext;
import javax.time.calendar.format.DateTimeParser;
import javax.time.calendar.format.DateTimePrinter;

final class NumberPrinterParser
implements DateTimePrinter,
DateTimeParser {
    private static final int[] EXCEED_POINTS = new int[]{0, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    private final DateTimeFieldRule<?> rule;
    private final int minWidth;
    private final int maxWidth;
    private final DateTimeFormatterBuilder.SignStyle signStyle;
    private final int subsequentWidth;

    NumberPrinterParser(DateTimeFieldRule<?> rule, int minWidth, int maxWidth, DateTimeFormatterBuilder.SignStyle signStyle) {
        this.rule = rule;
        this.minWidth = minWidth;
        this.maxWidth = maxWidth;
        this.signStyle = signStyle;
        this.subsequentWidth = 0;
    }

    private NumberPrinterParser(DateTimeFieldRule<?> rule, int minWidth, int maxWidth, DateTimeFormatterBuilder.SignStyle signStyle, int subsequentWidth) {
        this.rule = rule;
        this.minWidth = minWidth;
        this.maxWidth = maxWidth;
        this.signStyle = signStyle;
        this.subsequentWidth = subsequentWidth;
    }

    NumberPrinterParser withSubsequentWidth(int subsequentWidth) {
        return new NumberPrinterParser(this.rule, this.minWidth, this.maxWidth, this.signStyle, this.subsequentWidth + subsequentWidth);
    }

    @Override
    public void print(Calendrical calendrical, Appendable appendable, DateTimeFormatSymbols symbols) throws IOException {
        String str;
        int value = this.rule.getInt(calendrical);
        String string = str = value == Integer.MIN_VALUE ? "2147483648" : Integer.toString(Math.abs(value));
        if (str.length() > this.maxWidth) {
            throw new CalendricalPrintFieldException(this.rule, value, this.maxWidth);
        }
        str = symbols.convertNumberToI18N(str);
        if (value >= 0) {
            switch (this.signStyle) {
                case EXCEEDS_PAD: {
                    if (this.minWidth >= 10 || value < EXCEED_POINTS[this.minWidth]) break;
                    appendable.append(symbols.getPositiveSignChar());
                    break;
                }
                case ALWAYS: {
                    appendable.append(symbols.getPositiveSignChar());
                }
            }
        } else {
            switch (this.signStyle) {
                case EXCEEDS_PAD: 
                case ALWAYS: 
                case NORMAL: {
                    appendable.append(symbols.getNegativeSignChar());
                    break;
                }
                case NOT_NEGATIVE: {
                    throw new CalendricalPrintFieldException(this.rule, value);
                }
            }
        }
        for (int i = 0; i < this.minWidth - str.length(); ++i) {
            appendable.append(symbols.getZeroChar());
        }
        appendable.append(str);
    }

    @Override
    public boolean isPrintDataAvailable(Calendrical calendrical) {
        return calendrical.get(this.rule) != null;
    }

    @Override
    public int parse(DateTimeParseContext context, String parseText, int position) {
        int minEndPos;
        int length = parseText.length();
        if (position == length) {
            return ~position;
        }
        char sign = parseText.charAt(position);
        boolean negative = false;
        boolean positive = false;
        if (sign == context.getSymbols().getPositiveSignChar()) {
            positive = true;
            switch (this.signStyle) {
                case EXCEEDS_PAD: 
                case ALWAYS: {
                    ++position;
                    break;
                }
                default: {
                    if (context.isStrict()) {
                        return ~position;
                    }
                    ++position;
                    break;
                }
            }
        } else if (sign == context.getSymbols().getNegativeSignChar()) {
            negative = true;
            switch (this.signStyle) {
                case EXCEEDS_PAD: 
                case ALWAYS: 
                case NORMAL: {
                    ++position;
                    break;
                }
                default: {
                    if (context.isStrict()) {
                        return ~position;
                    }
                    ++position;
                    break;
                }
            }
        } else if (this.signStyle == DateTimeFormatterBuilder.SignStyle.ALWAYS && context.isStrict()) {
            return ~position;
        }
        if ((minEndPos = position + this.minWidth) > length) {
            return ~position;
        }
        int effMaxWidth = this.maxWidth + this.subsequentWidth;
        long total = 0L;
        int pos = position;
        for (int pass = 0; pass < 2; ++pass) {
            int maxEndPos = Math.min(pos + effMaxWidth, length);
            while (pos < maxEndPos) {
                char ch = parseText.charAt(pos++);
                int digit = context.getSymbols().convertToDigit(ch);
                if (digit < 0) {
                    if (--pos >= minEndPos) break;
                    return ~position;
                }
                total = total * 10L + (long)digit;
            }
            if (this.subsequentWidth <= 0 || pass != 0) break;
            int parseLen = pos - position;
            effMaxWidth = Math.max(this.minWidth, parseLen - this.subsequentWidth);
            pos = position;
            total = 0L;
        }
        if (negative) {
            if (total == 0L) {
                return ~(position - 1);
            }
            total = -total;
        } else if (this.signStyle == DateTimeFormatterBuilder.SignStyle.EXCEEDS_PAD && context.isStrict()) {
            int parseLen = pos - position;
            if (positive) {
                if (parseLen <= this.minWidth) {
                    return ~(position - 1);
                }
            } else if (parseLen > this.minWidth) {
                return ~position;
            }
        }
        if (total > Integer.MAX_VALUE || total < Integer.MIN_VALUE) {
            total /= 10L;
            --pos;
        }
        context.setParsed(this.rule, (int)total);
        return pos;
    }

    public String toString() {
        if (this.minWidth == 1 && this.maxWidth == 10 && this.signStyle == DateTimeFormatterBuilder.SignStyle.NORMAL) {
            return "Value(" + this.rule.getID() + ")";
        }
        if (this.minWidth == this.maxWidth && this.signStyle == DateTimeFormatterBuilder.SignStyle.NOT_NEGATIVE) {
            return "Value(" + this.rule.getID() + "," + this.minWidth + ")";
        }
        return "Value(" + this.rule.getID() + "," + this.minWidth + "," + this.maxWidth + "," + (Object)((Object)this.signStyle) + ")";
    }
}

