/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.format;

import java.io.IOException;
import javax.time.calendar.Calendrical;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.format.DateTimeFormatSymbols;
import javax.time.calendar.format.DateTimeFormatterBuilder;
import javax.time.calendar.format.DateTimeParseContext;
import javax.time.calendar.format.DateTimeParser;
import javax.time.calendar.format.DateTimePrinter;
import javax.time.calendar.format.NumberPrinterParser;

final class TextPrinterParser
implements DateTimePrinter,
DateTimeParser {
    private final DateTimeFieldRule<?> rule;
    private final DateTimeFormatterBuilder.TextStyle textStyle;
    private volatile NumberPrinterParser numberPrinterParser;

    TextPrinterParser(DateTimeFieldRule<?> rule, DateTimeFormatterBuilder.TextStyle textStyle) {
        this.rule = rule;
        this.textStyle = textStyle;
    }

    @Override
    public void print(Calendrical calendrical, Appendable appendable, DateTimeFormatSymbols symbols) throws IOException {
        String text;
        int value = this.rule.getInt(calendrical);
        DateTimeFieldRule.TextStore textStore = this.rule.getTextStore(symbols.getLocale(), this.textStyle);
        String string = text = textStore != null ? textStore.getValueText(value) : null;
        if (text != null) {
            appendable.append(text);
        } else {
            this.numberPrinterParser().print(calendrical, appendable, symbols);
        }
    }

    @Override
    public boolean isPrintDataAvailable(Calendrical calendrical) {
        return calendrical.get(this.rule) != null;
    }

    @Override
    public int parse(DateTimeParseContext context, String parseText, int position) {
        int length = parseText.length();
        if (position > length) {
            throw new IndexOutOfBoundsException();
        }
        if (context.isStrict()) {
            DateTimeFieldRule.TextStore textStore = this.rule.getTextStore(context.getLocale(), this.textStyle);
            if (textStore != null) {
                long match = textStore.matchText(!context.isCaseSensitive(), parseText.substring(position));
                if (match == 0L) {
                    return ~position;
                }
                if (match > 0L) {
                    position = (int)((long)position + (match >>> 32));
                    context.setParsed(this.rule, (int)match);
                    return position;
                }
            }
            return this.numberPrinterParser().parse(context, parseText, position);
        }
        for (DateTimeFormatterBuilder.TextStyle textStyle : DateTimeFormatterBuilder.TextStyle.values()) {
            long match;
            DateTimeFieldRule.TextStore textStore = this.rule.getTextStore(context.getLocale(), textStyle);
            if (textStore == null || (match = textStore.matchText(!context.isCaseSensitive(), parseText.substring(position))) <= 0L) continue;
            position = (int)((long)position + (match >>> 32));
            context.setParsed(this.rule, (int)match);
            return position;
        }
        return this.numberPrinterParser().parse(context, parseText, position);
    }

    private NumberPrinterParser numberPrinterParser() {
        if (this.numberPrinterParser == null) {
            this.numberPrinterParser = new NumberPrinterParser(this.rule, 1, 10, DateTimeFormatterBuilder.SignStyle.NORMAL);
        }
        return this.numberPrinterParser;
    }

    public String toString() {
        if (this.textStyle == DateTimeFormatterBuilder.TextStyle.FULL) {
            return "Text(" + this.rule.getID() + ")";
        }
        return "Text(" + this.rule.getID() + "," + (Object)((Object)this.textStyle) + ")";
    }
}

