/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.format;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.time.calendar.Calendrical;
import javax.time.calendar.TimeZone;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.format.CalendricalPrintException;
import javax.time.calendar.format.DateTimeFormatSymbols;
import javax.time.calendar.format.DateTimeFormatterBuilder;
import javax.time.calendar.format.DateTimeParseContext;
import javax.time.calendar.format.DateTimeParser;
import javax.time.calendar.format.DateTimePrinter;
import javax.time.calendar.format.ZoneOffsetPrinterParser;
import javax.time.calendar.zone.ZoneRulesGroup;

final class ZonePrinterParser
implements DateTimePrinter,
DateTimeParser {
    private final DateTimeFormatterBuilder.TextStyle textStyle;
    private static SubstringTree preparedTree;
    private static Set<String> preparedIDs;

    ZonePrinterParser() {
        this.textStyle = null;
    }

    ZonePrinterParser(DateTimeFormatterBuilder.TextStyle textStyle) {
        this.textStyle = textStyle;
    }

    @Override
    public void print(Calendrical calendrical, Appendable appendable, DateTimeFormatSymbols symbols) throws IOException {
        TimeZone zone = calendrical.get(TimeZone.rule());
        if (zone == null) {
            throw new CalendricalPrintException("Unable to print TimeZone");
        }
        if (this.textStyle == null) {
            appendable.append(zone.getID());
        } else if (this.textStyle == DateTimeFormatterBuilder.TextStyle.FULL) {
            appendable.append(zone.getName());
        } else {
            appendable.append(zone.getShortName());
        }
    }

    @Override
    public boolean isPrintDataAvailable(Calendrical calendrical) {
        return calendrical.get(TimeZone.rule()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int parse(DateTimeParseContext context, String parseText, int position) {
        int length = parseText.length();
        if (position > length) {
            throw new IndexOutOfBoundsException();
        }
        Set<String> ids = ZoneRulesGroup.getParsableIDs();
        if (ids.size() == 0) {
            return ~position;
        }
        Class<ZonePrinterParser> clazz = ZonePrinterParser.class;
        synchronized (ZonePrinterParser.class) {
            int nodeLength;
            if (preparedTree == null || preparedIDs.size() < ids.size()) {
                ids = new HashSet<String>(ids);
                preparedTree = ZonePrinterParser.prepareParser(ids);
                preparedIDs = ids;
            }
            SubstringTree tree = preparedTree;
            // ** MonitorExit[var7_6] (shouldn't be in output)
            if (parseText.substring(position).startsWith("UTC")) {
                int startPos;
                DateTimeParseContext newContext = new DateTimeParseContext(context.getSymbols());
                int endPos = new ZoneOffsetPrinterParser("", true, true).parse(newContext, parseText, startPos = position + 3);
                if (endPos < 0) {
                    context.setParsed(TimeZone.rule(), TimeZone.UTC);
                    return startPos;
                }
                TimeZone zone = TimeZone.of((ZoneOffset)newContext.getParsed(ZoneOffset.rule()));
                context.setParsed(TimeZone.rule(), zone);
                return endPos;
            }
            String parsedZoneId = null;
            int count = 0;
            while (tree != null && position + (nodeLength = tree.length) <= length) {
                parsedZoneId = parseText.substring(position, position + nodeLength);
                tree = tree.get(parsedZoneId);
                ++count;
            }
            if (parsedZoneId != null && preparedIDs.contains(parsedZoneId)) {
                TimeZone zone = TimeZone.of(parsedZoneId);
                context.setParsed(TimeZone.rule(), zone);
                return position + parsedZoneId.length();
            }
            return ~position;
        }
    }

    private static SubstringTree prepareParser(Set<String> availableIDs) {
        ArrayList<String> ids = new ArrayList<String>(availableIDs);
        Collections.sort(ids, new Comparator<String>(){

            @Override
            public int compare(String str1, String str2) {
                return str1.length() == str2.length() ? str1.compareTo(str2) : str1.length() - str2.length();
            }
        });
        SubstringTree tree = new SubstringTree(((String)ids.get(0)).length());
        for (String id : ids) {
            tree.add(id);
        }
        return tree;
    }

    public String toString() {
        if (this.textStyle == null) {
            return "ZoneId()";
        }
        return "ZoneText(" + (Object)((Object)this.textStyle) + ")";
    }

    private static class SubstringTree {
        final int length;
        private final Map<String, SubstringTree> substringMap = new HashMap<String, SubstringTree>();

        private SubstringTree(int length) {
            this.length = length;
        }

        private SubstringTree get(String substring2) {
            return this.substringMap.get(substring2);
        }

        private void add(String newSubstring) {
            int idLen = newSubstring.length();
            if (idLen == this.length) {
                this.substringMap.put(newSubstring, null);
            } else if (idLen > this.length) {
                String substring = newSubstring.substring(0, this.length);
                SubstringTree parserTree = this.substringMap.get(substring);
                if (parserTree == null) {
                    parserTree = new SubstringTree(idLen);
                    this.substringMap.put(substring, parserTree);
                }
                parserTree.add(newSubstring);
            }
        }
    }
}

