/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.zone;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.time.calendar.zone.ZoneRules;
import javax.time.calendar.zone.ZoneRulesDataProvider;
import javax.time.calendar.zone.ZoneRulesGroup;

class JarZoneRulesDataProvider
implements ZoneRulesDataProvider {
    private final String groupID;
    private final String versionID;
    private final Map<String, ZoneRules> zones;

    static void load() {
        List<ZoneRulesDataProvider> providers;
        try {
            providers = JarZoneRulesDataProvider.loadJars();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to load time zone rule data", ex);
        }
        for (ZoneRulesDataProvider provider : providers) {
            ZoneRulesGroup.registerProvider(provider);
        }
    }

    private static List<ZoneRulesDataProvider> loadJars() throws Exception {
        ArrayList<ZoneRulesDataProvider> providers = new ArrayList<ZoneRulesDataProvider>();
        Enumeration<URL> en = Thread.currentThread().getContextClassLoader().getResources("javax/time/calendar/zone/ZoneRuleInfo.dat");
        while (en.hasMoreElements()) {
            URL url = en.nextElement();
            boolean throwing = false;
            InputStream in = null;
            try {
                in = url.openStream();
                ObjectInputStream ois = new ObjectInputStream(in);
                int dataSets = ois.readInt();
                for (int i = 0; i < dataSets; ++i) {
                    String groupID = ois.readUTF();
                    String versionID = ois.readUTF();
                    Map zones = (Map)ois.readObject();
                    providers.add(new JarZoneRulesDataProvider(groupID, versionID, zones));
                }
            }
            catch (IOException ex) {
                throwing = true;
                throw ex;
            }
            finally {
                if (in == null) continue;
                try {
                    in.close();
                }
                catch (IOException ex) {
                    if (throwing) continue;
                    throw ex;
                }
            }
        }
        return providers;
    }

    public JarZoneRulesDataProvider(String groupID, String versionID, Map<String, ZoneRules> zones) {
        this.groupID = groupID;
        this.versionID = versionID;
        this.zones = zones;
    }

    @Override
    public String getGroupID() {
        return this.groupID;
    }

    @Override
    public Set<String> getIDs() {
        HashSet<String> ids = new HashSet<String>(this.zones.size());
        for (String id : this.zones.keySet()) {
            ids.add(id + '#' + this.versionID);
        }
        return Collections.unmodifiableSet(ids);
    }

    @Override
    public ZoneRules getZoneRules(String regionID, String versionID) {
        if (regionID == null || versionID == null || !versionID.equals(this.versionID)) {
            return null;
        }
        return this.zones.get(regionID);
    }
}

