/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.zone;

import java.io.Serializable;
import javax.time.Instant;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.zone.ZoneRules;
import javax.time.period.Period;

public final class ZoneOffsetTransition
implements Comparable<ZoneOffsetTransition>,
Serializable {
    private static final long serialVersionUID = 3582762487L;
    private final OffsetDateTime transition;
    private final OffsetDateTime transitionAfter;

    ZoneOffsetTransition(OffsetDateTime transition, ZoneOffset offsetAfter) {
        ZoneRules.checkNotNull(transition, "OffsetDateTime must not be null");
        ZoneRules.checkNotNull(transition, "ZoneOffset must not be null");
        this.transition = transition;
        this.transitionAfter = transition.withOffsetSameInstant(offsetAfter);
    }

    public Instant getInstant() {
        return this.transition.toInstant();
    }

    public LocalDateTime getLocal() {
        return this.transition.toLocalDateTime();
    }

    public OffsetDateTime getDateTime() {
        return this.transition;
    }

    public OffsetDateTime getDateTimeAfter() {
        return this.transitionAfter;
    }

    public ZoneOffset getOffsetBefore() {
        return this.transition.getOffset();
    }

    public ZoneOffset getOffsetAfter() {
        return this.transitionAfter.getOffset();
    }

    public Period getTransitionSize() {
        int secs = this.getOffsetAfter().getAmountSeconds() - this.getOffsetBefore().getAmountSeconds();
        return Period.seconds(secs).normalized();
    }

    public boolean isGap() {
        return this.getOffsetAfter().getAmountSeconds() > this.getOffsetBefore().getAmountSeconds();
    }

    public boolean isOverlap() {
        return this.getOffsetAfter().getAmountSeconds() < this.getOffsetBefore().getAmountSeconds();
    }

    public boolean isValidOffset(ZoneOffset offset) {
        return this.isGap() ? false : this.getOffsetBefore().equals(offset) || this.getOffsetAfter().equals(offset);
    }

    @Override
    public int compareTo(ZoneOffsetTransition transition) {
        return this.getInstant().compareTo(transition.getInstant());
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ZoneOffsetTransition) {
            ZoneOffsetTransition d = (ZoneOffsetTransition)other;
            return this.transition.equals(d.transition) && this.transitionAfter.getOffset().equals(d.transitionAfter.getOffset());
        }
        return false;
    }

    public int hashCode() {
        return this.transition.hashCode() ^ this.transitionAfter.getOffset().hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Transition[").append(this.isGap() ? "Gap" : "Overlap").append(" at ").append(this.transition).append(" to ").append(this.transitionAfter.getOffset()).append(']');
        return buf.toString();
    }
}

