/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.zone;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.time.calendar.DateAdjusters;
import javax.time.calendar.DayOfWeek;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.LocalDate;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.LocalTime;
import javax.time.calendar.MonthOfYear;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.zone.StandardZoneRules;
import javax.time.calendar.zone.ZoneOffsetTransition;
import javax.time.calendar.zone.ZoneOffsetTransitionRule;
import javax.time.calendar.zone.ZoneRules;
import javax.time.period.Period;

public class ZoneRulesBuilder {
    private static final long serialVersionUID = 9375261659767L;
    private static final LocalDateTime MAX_DATE_TIME = LocalDateTime.of(Integer.MAX_VALUE, 12, 31, 23, 59, 59, 999999999);
    private List<TZWindow> windowList = new ArrayList<TZWindow>();
    private Map<Object, Object> deduplicateMap;

    private static void checkNotNull(Object object, String errorMessage) {
        if (object == null) {
            throw new NullPointerException(errorMessage);
        }
    }

    public ZoneRulesBuilder addWindow(ZoneOffset standardOffset, LocalDateTime until, TimeDefinition untilDefinition) {
        ZoneRulesBuilder.checkNotNull(standardOffset, "Standard offset must not be null");
        ZoneRulesBuilder.checkNotNull(until, "Until date-time must not be null");
        ZoneRulesBuilder.checkNotNull((Object)untilDefinition, "Time definition must not be null");
        TZWindow window = new TZWindow(standardOffset, until, untilDefinition);
        if (this.windowList.size() > 0) {
            TZWindow previous = this.windowList.get(this.windowList.size() - 1);
            window.validateWindowOrder(previous);
        }
        this.windowList.add(window);
        return this;
    }

    public ZoneRulesBuilder addWindowForever(ZoneOffset standardOffset) {
        return this.addWindow(standardOffset, MAX_DATE_TIME, TimeDefinition.WALL);
    }

    public ZoneRulesBuilder setFixedSavingsToWindow(Period fixedSavingAmount) {
        ZoneRulesBuilder.checkNotNull(fixedSavingAmount, "Fixed savings amount must not be null");
        if (this.windowList.isEmpty()) {
            throw new IllegalStateException("Must add a window before setting the fixed savings");
        }
        TZWindow window = this.windowList.get(this.windowList.size() - 1);
        window.setFixedSavings(fixedSavingAmount);
        return this;
    }

    public ZoneRulesBuilder addRuleToWindow(LocalDateTime dateTime, TimeDefinition timeDefinition, Period savingAmount) {
        ZoneRulesBuilder.checkNotNull(dateTime, "Rule end date-time must not be null");
        return this.addRuleToWindow(dateTime.getYear(), dateTime.getYear(), dateTime.getMonthOfYear(), dateTime.getDayOfMonth(), null, dateTime.toLocalTime(), timeDefinition, savingAmount);
    }

    public ZoneRulesBuilder addRuleToWindow(int year, MonthOfYear month, int dayOfMonth, LocalTime time, TimeDefinition timeDefinition, Period savingAmount) {
        return this.addRuleToWindow(year, year, month, dayOfMonth, null, time, timeDefinition, savingAmount);
    }

    public ZoneRulesBuilder addRuleToWindow(int startYear, int endYear, MonthOfYear month, int dayOfMonth, DayOfWeek dayOfWeek, LocalTime time, TimeDefinition timeDefinition, Period savingAmount) {
        ZoneRulesBuilder.checkNotNull((Object)month, "Rule end month must not be null");
        ZoneRulesBuilder.checkNotNull(time, "Rule end time must not be null");
        ZoneRulesBuilder.checkNotNull((Object)timeDefinition, "Time definition must not be null");
        ZoneRulesBuilder.checkNotNull(savingAmount, "Savings amount must not be null");
        ISOChronology.yearRule().checkValue(startYear);
        ISOChronology.yearRule().checkValue(endYear);
        if (dayOfMonth != -1) {
            ISOChronology.dayOfMonthRule().checkValue(dayOfMonth);
        }
        if (this.windowList.isEmpty()) {
            throw new IllegalStateException("Must add a window before adding a rule");
        }
        TZWindow window = this.windowList.get(this.windowList.size() - 1);
        window.addRule(startYear, endYear, month, dayOfMonth, dayOfWeek, time, timeDefinition, savingAmount);
        return this;
    }

    public ZoneRules toRules(String id) {
        return this.toRules(id, new HashMap<Object, Object>());
    }

    ZoneRules toRules(String id, Map<Object, Object> deduplicateMap) {
        ZoneRulesBuilder.checkNotNull(id, "Time zone id must not be null");
        if (this.windowList.isEmpty()) {
            throw new IllegalStateException("No windows have been added to the builder");
        }
        this.deduplicateMap = deduplicateMap;
        ArrayList<OffsetDateTime> standardOffsetList = new ArrayList<OffsetDateTime>(4);
        ArrayList<ZoneOffsetTransition> transitionList = new ArrayList<ZoneOffsetTransition>(256);
        ArrayList<ZoneOffsetTransitionRule> lastTransitionRuleList = new ArrayList<ZoneOffsetTransitionRule>(2);
        TZWindow firstWindow = this.windowList.get(0);
        ZoneOffset standardOffset = firstWindow.standardOffset;
        Period savings = Period.ZERO;
        if (firstWindow.fixedSavingAmount != null) {
            savings = firstWindow.fixedSavingAmount;
        }
        ZoneOffset firstWallOffset = this.deduplicate(standardOffset.plus(savings));
        OffsetDateTime windowStart = this.deduplicate(OffsetDateTime.of(-2147483646, 1, 1, 0, 0, firstWallOffset));
        for (TZWindow window : this.windowList) {
            window.tidy(windowStart.getYear());
            Period effectiveSavings = window.fixedSavingAmount;
            if (effectiveSavings == null) {
                TZRule rule;
                ZoneOffsetTransition trans;
                effectiveSavings = Period.ZERO;
                Iterator i$ = window.ruleList.iterator();
                while (i$.hasNext() && !(trans = (rule = (TZRule)i$.next()).toTransition(standardOffset, savings)).getDateTime().isAfter(windowStart)) {
                    effectiveSavings = rule.savingAmount;
                }
            }
            if (!standardOffset.equals(window.standardOffset)) {
                standardOffset = this.deduplicate(window.standardOffset);
                standardOffsetList.add(this.deduplicate(windowStart.withOffsetSameInstant(standardOffset)));
            }
            ZoneOffset effectiveWallOffset = this.deduplicate(standardOffset.plus(effectiveSavings));
            if (!windowStart.getOffset().equals(effectiveWallOffset)) {
                ZoneOffsetTransition trans = new ZoneOffsetTransition(windowStart, effectiveWallOffset);
                transitionList.add(trans);
            }
            savings = effectiveSavings;
            for (TZRule rule : window.ruleList) {
                ZoneOffsetTransition trans = rule.toTransition(standardOffset, savings);
                if (trans.getDateTime().isBefore(windowStart) || !trans.getDateTime().isBefore(window.createDateTime(savings)) || trans.getOffsetBefore().equals(trans.getOffsetAfter())) continue;
                transitionList.add(trans);
                savings = rule.savingAmount;
            }
            for (TZRule lastRule : window.lastRuleList) {
                ZoneOffsetTransitionRule transitionRule = lastRule.toTransitionRule(standardOffset, savings);
                lastTransitionRuleList.add(transitionRule);
                savings = lastRule.savingAmount;
            }
            windowStart = this.deduplicate(window.createDateTime(savings));
        }
        return new StandardZoneRules(firstWindow.standardOffset, firstWallOffset, standardOffsetList, transitionList, lastTransitionRuleList);
    }

    <T> T deduplicate(T object) {
        if (!this.deduplicateMap.containsKey(object)) {
            this.deduplicateMap.put(object, object);
        }
        return (T)this.deduplicateMap.get(object);
    }

    class TZRule
    implements Comparable<TZRule> {
        private int year;
        private final MonthOfYear month;
        private final int dayOfMonth;
        private final DayOfWeek dayOfWeek;
        private final LocalTime time;
        private final TimeDefinition timeDefinition;
        private final Period savingAmount;

        TZRule(int year, MonthOfYear month, int dayOfMonth, DayOfWeek dayOfWeek, LocalTime time, TimeDefinition timeDefinition, Period savingAfter) {
            this.year = year;
            this.month = month;
            this.dayOfMonth = dayOfMonth;
            this.dayOfWeek = dayOfWeek;
            this.time = time;
            this.timeDefinition = timeDefinition;
            this.savingAmount = savingAfter;
        }

        ZoneOffsetTransition toTransition(ZoneOffset standardOffset, Period savingsBefore) {
            LocalDate date;
            ZoneOffset offsetAfter = standardOffset.plus(this.savingAmount);
            if (this.dayOfMonth == -1) {
                date = LocalDate.of(this.year, this.month, this.month.getLastDayOfMonth(ISOChronology.isLeapYear(this.year)));
                if (this.dayOfWeek != null) {
                    date = date.with(DateAdjusters.previousOrCurrent(this.dayOfWeek));
                }
            } else {
                date = LocalDate.of(this.year, this.month, this.dayOfMonth);
                if (this.dayOfWeek != null) {
                    date = date.with(DateAdjusters.nextOrCurrent(this.dayOfWeek));
                }
            }
            date = ZoneRulesBuilder.this.deduplicate(date);
            LocalDateTime ldt = ZoneRulesBuilder.this.deduplicate(LocalDateTime.from(date, this.time));
            ZoneOffset wallOffset = ZoneRulesBuilder.this.deduplicate(standardOffset.plus(savingsBefore));
            OffsetDateTime dt = ZoneRulesBuilder.this.deduplicate(this.timeDefinition.createDateTime(ldt, standardOffset, wallOffset));
            return new ZoneOffsetTransition(dt, offsetAfter);
        }

        ZoneOffsetTransitionRule toTransitionRule(ZoneOffset standardOffset, Period savingsBefore) {
            int dom = this.dayOfMonth == -1 ? (this.month == MonthOfYear.FEBRUARY ? -1 : this.month.maxLengthInDays() - 6) : this.dayOfMonth;
            ZoneOffsetTransition trans = this.toTransition(standardOffset, savingsBefore);
            return new ZoneOffsetTransitionRule(this.month, dom, this.dayOfWeek, this.time, this.timeDefinition, standardOffset, trans.getOffsetBefore(), trans.getOffsetAfter());
        }

        @Override
        public int compareTo(TZRule other) {
            int cmp = this.year - other.year;
            cmp = cmp == 0 ? this.month.compareTo(other.month) : cmp;
            cmp = cmp == 0 ? this.dayOfMonth - other.dayOfMonth : cmp;
            cmp = cmp == 0 ? this.time.compareTo(other.time) : cmp;
            return cmp;
        }
    }

    class TZWindow {
        private final ZoneOffset standardOffset;
        private final LocalDateTime windowEnd;
        private final TimeDefinition timeDefinition;
        private Period fixedSavingAmount;
        private List<TZRule> ruleList = new ArrayList<TZRule>();
        private int maxLastRuleStartYear = -2147483646;
        private List<TZRule> lastRuleList = new ArrayList<TZRule>();

        TZWindow(ZoneOffset standardOffset, LocalDateTime windowEnd, TimeDefinition timeDefinition) {
            this.windowEnd = windowEnd;
            this.timeDefinition = timeDefinition;
            this.standardOffset = standardOffset;
        }

        void setFixedSavings(Period fixedSavingAmount) {
            if (this.ruleList.size() > 0 || this.lastRuleList.size() > 0) {
                throw new IllegalStateException("Window has DST rules, so cannot have fixed savings");
            }
            this.fixedSavingAmount = fixedSavingAmount;
        }

        void addRule(int startYear, int endYear, MonthOfYear month, int dayOfMonth, DayOfWeek dayOfWeek, LocalTime time, TimeDefinition timeDefinition, Period savingAmount) {
            if (this.fixedSavingAmount != null) {
                throw new IllegalStateException("Window has a fixed DST saving, so cannot have DST rules");
            }
            if (this.ruleList.size() >= 2000) {
                throw new IllegalStateException("Window has reached the maximum number of allowed rules");
            }
            boolean lastRule = false;
            if (endYear == Integer.MAX_VALUE) {
                lastRule = true;
                endYear = startYear;
            }
            for (int year = startYear; year <= endYear; ++year) {
                TZRule rule = new TZRule(year, month, dayOfMonth, dayOfWeek, time, timeDefinition, savingAmount);
                if (lastRule) {
                    this.lastRuleList.add(rule);
                    this.maxLastRuleStartYear = Math.max(startYear, this.maxLastRuleStartYear);
                    continue;
                }
                this.ruleList.add(rule);
            }
        }

        void validateWindowOrder(TZWindow previous) {
            if (this.windowEnd.isBefore(previous.windowEnd)) {
                throw new IllegalStateException("Windows must be added in date-time order: " + this.windowEnd + " < " + previous.windowEnd);
            }
        }

        void tidy(int windowStartYear) {
            if (this.lastRuleList.size() == 1) {
                throw new IllegalStateException("Cannot have only one rule defined as being forever");
            }
            if (this.windowEnd.equals(MAX_DATE_TIME)) {
                this.maxLastRuleStartYear = Math.max(this.maxLastRuleStartYear, windowStartYear) + 1;
                for (TZRule lastRule : this.lastRuleList) {
                    this.addRule(lastRule.year, this.maxLastRuleStartYear, lastRule.month, lastRule.dayOfMonth, lastRule.dayOfWeek, lastRule.time, lastRule.timeDefinition, lastRule.savingAmount);
                    lastRule.year = this.maxLastRuleStartYear + 1;
                }
                if (this.maxLastRuleStartYear == Integer.MAX_VALUE) {
                    this.lastRuleList.clear();
                } else {
                    ++this.maxLastRuleStartYear;
                }
            } else {
                int endYear = this.windowEnd.getYear();
                for (TZRule lastRule : this.lastRuleList) {
                    this.addRule(lastRule.year, endYear + 1, lastRule.month, lastRule.dayOfMonth, lastRule.dayOfWeek, lastRule.time, lastRule.timeDefinition, lastRule.savingAmount);
                }
                this.lastRuleList.clear();
                this.maxLastRuleStartYear = Integer.MAX_VALUE;
            }
            Collections.sort(this.ruleList);
            Collections.sort(this.lastRuleList);
            if (this.ruleList.size() == 0 && this.fixedSavingAmount == null) {
                this.fixedSavingAmount = Period.ZERO;
            }
        }

        OffsetDateTime createDateTime(Period savings) {
            ZoneOffset wallOffset = this.standardOffset.plus(savings);
            return this.timeDefinition.createDateTime(this.windowEnd, this.standardOffset, wallOffset);
        }
    }

    public static enum TimeDefinition {
        UTC,
        WALL,
        STANDARD;


        public OffsetDateTime createDateTime(LocalDateTime dateTime, ZoneOffset standardOffset, ZoneOffset wallOffset) {
            switch (this) {
                case UTC: {
                    return OffsetDateTime.from(dateTime, ZoneOffset.UTC).withOffsetSameInstant(wallOffset);
                }
                case STANDARD: {
                    return OffsetDateTime.from(dateTime, standardOffset).withOffsetSameInstant(wallOffset);
                }
            }
            return OffsetDateTime.from(dateTime, wallOffset);
        }
    }
}

