/*
 * Decompiled with CFR 0.152.
 */
package javax.time.i18n;

import java.util.Locale;
import javax.time.calendar.IllegalCalendarFieldValueException;
import javax.time.calendar.format.DateTimeFormatterBuilder;
import javax.time.i18n.HistoricChronology;

public enum HistoricEra {
    BCE,
    CE;


    public static HistoricEra of(int era) {
        switch (era) {
            case 0: {
                return BCE;
            }
            case 1: {
                return CE;
            }
        }
        throw new IllegalCalendarFieldValueException(HistoricChronology.standardCutover().eraRule(), era, 0, 1);
    }

    public int getValue() {
        return this.ordinal();
    }

    public String getShortText(Locale locale) {
        return HistoricChronology.standardCutover().eraRule().getText(this.getValue(), locale, DateTimeFormatterBuilder.TextStyle.SHORT);
    }

    public String getText(Locale locale) {
        return HistoricChronology.standardCutover().eraRule().getText(this.getValue(), locale, DateTimeFormatterBuilder.TextStyle.FULL);
    }
}

