/*
 * Decompiled with CFR 0.152.
 */
package javax.time.period;

import java.io.Serializable;
import java.util.TreeMap;
import javax.time.CalendricalException;
import javax.time.Duration;
import javax.time.MathUtils;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.PeriodUnit;
import javax.time.period.PeriodField;
import javax.time.period.PeriodFields;
import javax.time.period.PeriodParser;
import javax.time.period.PeriodProvider;

public final class Period
implements PeriodProvider,
Serializable {
    public static final Period ZERO = new Period(0, 0, 0, 0, 0, 0, 0L);
    private static final long serialVersionUID = 1L;
    private static final PeriodUnit[] UNITS = new PeriodUnit[]{ISOChronology.periodYears(), ISOChronology.periodMonths(), ISOChronology.periodDays(), ISOChronology.periodHours(), ISOChronology.periodMinutes(), ISOChronology.periodSeconds(), ISOChronology.periodNanos()};
    private final int years;
    private final int months;
    private final int days;
    private final int hours;
    private final int minutes;
    private final int seconds;
    private final long nanos;
    private volatile transient PeriodFields periodFields;
    private volatile transient String string;

    public static Period from(PeriodProvider periodProvider) {
        PeriodFields.checkNotNull(periodProvider, "PeriodProvider must not be null");
        if (periodProvider instanceof Period) {
            return (Period)periodProvider;
        }
        PeriodFields periodFields = PeriodFields.from(periodProvider);
        periodFields = periodFields.toEquivalentPeriod(UNITS);
        int years = periodFields.getAmountInt(ISOChronology.periodYears());
        int months = periodFields.getAmountInt(ISOChronology.periodMonths());
        int days = periodFields.getAmountInt(ISOChronology.periodDays());
        int hours = periodFields.getAmountInt(ISOChronology.periodHours());
        int minutes = periodFields.getAmountInt(ISOChronology.periodMinutes());
        int seconds = periodFields.getAmountInt(ISOChronology.periodSeconds());
        long nanos = periodFields.getAmount(ISOChronology.periodNanos());
        return Period.of(years, months, days, hours, minutes, seconds, nanos);
    }

    public static Period of(int years, int months, int days, int hours, int minutes, int seconds) {
        if ((years | months | days | hours | minutes | seconds) == 0) {
            return ZERO;
        }
        return new Period(years, months, days, hours, minutes, seconds, 0L);
    }

    public static Period of(int years, int months, int days, int hours, int minutes, int seconds, long nanos) {
        if (((long)(years | months | days | hours | minutes | seconds) | nanos) == 0L) {
            return ZERO;
        }
        return new Period(years, months, days, hours, minutes, seconds, nanos);
    }

    public static Period yearsMonths(int years, int months) {
        if ((years | months) == 0) {
            return ZERO;
        }
        return new Period(years, months, 0, 0, 0, 0, 0L);
    }

    public static Period yearsMonthsDays(int years, int months, int days) {
        if ((years | months | days) == 0) {
            return ZERO;
        }
        return new Period(years, months, days, 0, 0, 0, 0L);
    }

    public static Period hoursMinutesSeconds(int hours, int minutes, int seconds) {
        if ((hours | minutes | seconds) == 0) {
            return ZERO;
        }
        return new Period(0, 0, 0, hours, minutes, seconds, 0L);
    }

    public static Period years(int years) {
        if (years == 0) {
            return ZERO;
        }
        return new Period(years, 0, 0, 0, 0, 0, 0L);
    }

    public static Period months(int months) {
        if (months == 0) {
            return ZERO;
        }
        return new Period(0, months, 0, 0, 0, 0, 0L);
    }

    public static Period days(int days) {
        if (days == 0) {
            return ZERO;
        }
        return new Period(0, 0, days, 0, 0, 0, 0L);
    }

    public static Period hours(int hours) {
        if (hours == 0) {
            return ZERO;
        }
        return new Period(0, 0, 0, hours, 0, 0, 0L);
    }

    public static Period minutes(int minutes) {
        if (minutes == 0) {
            return ZERO;
        }
        return new Period(0, 0, 0, 0, minutes, 0, 0L);
    }

    public static Period seconds(int seconds) {
        if (seconds == 0) {
            return ZERO;
        }
        return new Period(0, 0, 0, 0, 0, seconds, 0L);
    }

    public static Period nanos(long nanos) {
        if (nanos == 0L) {
            return ZERO;
        }
        return new Period(0, 0, 0, 0, 0, 0, nanos);
    }

    public static Period parse(String text) {
        PeriodFields.checkNotNull(text, "Text to parse must not be null");
        return PeriodParser.getInstance().parse(text);
    }

    private Period(int years, int months, int days, int hours, int minutes, int seconds, long nanos) {
        this.years = years;
        this.months = months;
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
        this.nanos = nanos;
    }

    private Object readResolve() {
        if (((long)(this.years | this.months | this.days | this.hours | this.minutes | this.seconds) | this.nanos) == 0L) {
            return ZERO;
        }
        return this;
    }

    public boolean isZero() {
        return this == ZERO;
    }

    public boolean isPositive() {
        return ((long)(this.years | this.months | this.days | this.hours | this.minutes | this.seconds) | this.nanos) >= 0L;
    }

    public int getYears() {
        return this.years;
    }

    public int getMonths() {
        return this.months;
    }

    public int getDays() {
        return this.days;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public long getNanos() {
        return this.nanos;
    }

    public int getNanosInt() {
        return MathUtils.safeToInt(this.nanos);
    }

    public Period withYears(int years) {
        if (years == this.years) {
            return this;
        }
        return Period.of(years, this.months, this.days, this.hours, this.minutes, this.seconds, this.nanos);
    }

    public Period withMonths(int months) {
        if (months == this.months) {
            return this;
        }
        return Period.of(this.years, months, this.days, this.hours, this.minutes, this.seconds, this.nanos);
    }

    public Period withDays(int days) {
        if (days == this.days) {
            return this;
        }
        return Period.of(this.years, this.months, days, this.hours, this.minutes, this.seconds, this.nanos);
    }

    public Period withHours(int hours) {
        if (hours == this.hours) {
            return this;
        }
        return Period.of(this.years, this.months, this.days, hours, this.minutes, this.seconds, this.nanos);
    }

    public Period withMinutes(int minutes) {
        if (minutes == this.minutes) {
            return this;
        }
        return Period.of(this.years, this.months, this.days, this.hours, minutes, this.seconds, this.nanos);
    }

    public Period withSeconds(int seconds) {
        if (seconds == this.seconds) {
            return this;
        }
        return Period.of(this.years, this.months, this.days, this.hours, this.minutes, seconds, this.nanos);
    }

    public Period withNanos(long nanos) {
        if (nanos == this.nanos) {
            return this;
        }
        return Period.of(this.years, this.months, this.days, this.hours, this.minutes, this.seconds, nanos);
    }

    public Period plus(PeriodProvider periodProvider) {
        Period other = Period.from(periodProvider);
        return Period.of(MathUtils.safeAdd(this.years, other.years), MathUtils.safeAdd(this.months, other.months), MathUtils.safeAdd(this.days, other.days), MathUtils.safeAdd(this.hours, other.hours), MathUtils.safeAdd(this.minutes, other.minutes), MathUtils.safeAdd(this.seconds, other.seconds), MathUtils.safeAdd(this.nanos, other.nanos));
    }

    public Period plusYears(int years) {
        return this.withYears(MathUtils.safeAdd(this.years, years));
    }

    public Period plusMonths(int months) {
        return this.withMonths(MathUtils.safeAdd(this.months, months));
    }

    public Period plusDays(int days) {
        return this.withDays(MathUtils.safeAdd(this.days, days));
    }

    public Period plusHours(int hours) {
        return this.withHours(MathUtils.safeAdd(this.hours, hours));
    }

    public Period plusMinutes(int minutes) {
        return this.withMinutes(MathUtils.safeAdd(this.minutes, minutes));
    }

    public Period plusSeconds(int seconds) {
        return this.withSeconds(MathUtils.safeAdd(this.seconds, seconds));
    }

    public Period plusNanos(long nanos) {
        return this.withNanos(MathUtils.safeAdd(this.nanos, nanos));
    }

    public Period minus(PeriodProvider periodProvider) {
        Period other = Period.from(periodProvider);
        return Period.of(MathUtils.safeSubtract(this.years, other.years), MathUtils.safeSubtract(this.months, other.months), MathUtils.safeSubtract(this.days, other.days), MathUtils.safeSubtract(this.hours, other.hours), MathUtils.safeSubtract(this.minutes, other.minutes), MathUtils.safeSubtract(this.seconds, other.seconds), MathUtils.safeSubtract(this.nanos, other.nanos));
    }

    public Period minusYears(int years) {
        return this.withYears(MathUtils.safeSubtract(this.years, years));
    }

    public Period minusMonths(int months) {
        return this.withMonths(MathUtils.safeSubtract(this.months, months));
    }

    public Period minusDays(int days) {
        return this.withDays(MathUtils.safeSubtract(this.days, days));
    }

    public Period minusHours(int hours) {
        return this.withHours(MathUtils.safeSubtract(this.hours, hours));
    }

    public Period minusMinutes(int minutes) {
        return this.withMinutes(MathUtils.safeSubtract(this.minutes, minutes));
    }

    public Period minusSeconds(int seconds) {
        return this.withSeconds(MathUtils.safeSubtract(this.seconds, seconds));
    }

    public Period minusNanos(long nanos) {
        return this.withNanos(MathUtils.safeSubtract(this.nanos, nanos));
    }

    public Period multipliedBy(int scalar) {
        if (this == ZERO || scalar == 1) {
            return this;
        }
        return Period.of(MathUtils.safeMultiply(this.years, scalar), MathUtils.safeMultiply(this.months, scalar), MathUtils.safeMultiply(this.days, scalar), MathUtils.safeMultiply(this.hours, scalar), MathUtils.safeMultiply(this.minutes, scalar), MathUtils.safeMultiply(this.seconds, scalar), MathUtils.safeMultiply(this.nanos, scalar));
    }

    public Period dividedBy(int divisor) {
        if (divisor == 0) {
            throw new ArithmeticException("Cannot divide by zero");
        }
        if (this == ZERO || divisor == 1) {
            return this;
        }
        return Period.of(this.years / divisor, this.months / divisor, this.days / divisor, this.hours / divisor, this.minutes / divisor, this.seconds / divisor, this.nanos / (long)divisor);
    }

    public Period negated() {
        return this.multipliedBy(-1);
    }

    public Period normalized() {
        if (this == ZERO) {
            return ZERO;
        }
        int years = this.years;
        int months = this.months;
        if (months >= 12) {
            years = MathUtils.safeAdd(years, months / 12);
            months %= 12;
        }
        long total = (long)this.hours * 60L * 60L + (long)this.minutes * 60L + (long)this.seconds;
        total = MathUtils.safeMultiply(total, 1000000000);
        total = MathUtils.safeAdd(total, this.nanos);
        long nanos = total % 1000000000L;
        int seconds = (int)((total /= 1000000000L) % 60L);
        int minutes = (int)((total /= 60L) % 60L);
        int hours = MathUtils.safeToInt(total /= 60L);
        return Period.of(years, months, this.days, hours, minutes, seconds, nanos);
    }

    public Period normalizedWith24HourDays() {
        if (this == ZERO) {
            return ZERO;
        }
        int years = this.years;
        int months = this.months;
        if (months >= 12) {
            years = MathUtils.safeAdd(years, months / 12);
            months %= 12;
        }
        long total = (long)this.days * 24L * 60L * 60L + (long)this.hours * 60L * 60L + (long)this.minutes * 60L + (long)this.seconds;
        total = MathUtils.safeMultiply(total, 1000000000);
        total = MathUtils.safeAdd(total, this.nanos);
        long nanos = total % 1000000000L;
        int seconds = (int)((total /= 1000000000L) % 60L);
        int minutes = (int)((total /= 60L) % 60L);
        int hours = (int)((total /= 60L) % 24L);
        int days = MathUtils.safeToInt(total /= 24L);
        return Period.of(years, months, days, hours, minutes, seconds, nanos);
    }

    public long totalYears() {
        return MathUtils.safeAdd((long)this.years, (long)(this.months / 12));
    }

    public long totalMonths() {
        return MathUtils.safeAdd(MathUtils.safeMultiply((long)this.years, 12), (long)this.months);
    }

    public long totalDaysWith24HourDays() {
        if (this == ZERO) {
            return 0L;
        }
        return (long)this.days + ((long)this.hours + ((long)this.minutes + ((long)this.seconds + this.nanos / 1000000000L) / 60L) / 60L) / 24L;
    }

    public long totalHours() {
        if (this == ZERO) {
            return 0L;
        }
        return (long)this.hours + ((long)this.minutes + ((long)this.seconds + this.nanos / 1000000000L) / 60L) / 60L;
    }

    public long totalHoursWith24HourDays() {
        if (this == ZERO) {
            return 0L;
        }
        return (long)this.days * 24L + (long)this.hours + ((long)this.minutes + ((long)this.seconds + this.nanos / 1000000000L) / 60L) / 60L;
    }

    public long totalMinutes() {
        if (this == ZERO) {
            return 0L;
        }
        return (long)this.hours * 60L + (long)this.minutes + ((long)this.seconds + this.nanos / 1000000000L) / 60L;
    }

    public long totalMinutesWith24HourDays() {
        if (this == ZERO) {
            return 0L;
        }
        return ((long)this.days * 24L + (long)this.hours) * 60L + (long)this.minutes + ((long)this.seconds + this.nanos / 1000000000L) / 60L;
    }

    public long totalSeconds() {
        if (this == ZERO) {
            return 0L;
        }
        return ((long)this.hours * 60L + (long)this.minutes) * 60L + (long)this.seconds + this.nanos / 1000000000L;
    }

    public long totalSecondsWith24HourDays() {
        if (this == ZERO) {
            return 0L;
        }
        return (((long)this.days * 24L + (long)this.hours) * 60L + (long)this.minutes) * 60L + (long)this.seconds + this.nanos / 1000000000L;
    }

    public long totalNanos() {
        if (this == ZERO) {
            return 0L;
        }
        long secs = ((long)this.hours * 60L + (long)this.minutes) * 60L + (long)this.seconds;
        long otherNanos = MathUtils.safeMultiply(secs, 1000000000L);
        return MathUtils.safeAdd(otherNanos, this.nanos);
    }

    public long totalNanosWith24HourDays() {
        if (this == ZERO) {
            return 0L;
        }
        long secs = (((long)this.days * 24L + (long)this.hours) * 60L + (long)this.minutes) * 60L + (long)this.seconds;
        long otherNanos = MathUtils.safeMultiply(secs, 1000000000L);
        return MathUtils.safeAdd(otherNanos, this.nanos);
    }

    @Override
    public PeriodFields toPeriodFields() {
        PeriodFields fields = this.periodFields;
        if (fields == null) {
            TreeMap<PeriodUnit, PeriodField> map = new TreeMap<PeriodUnit, PeriodField>();
            if (this.years != 0) {
                map.put(ISOChronology.periodYears(), PeriodField.of(this.years, ISOChronology.periodYears()));
            }
            if (this.months != 0) {
                map.put(ISOChronology.periodMonths(), PeriodField.of(this.months, ISOChronology.periodMonths()));
            }
            if (this.days != 0) {
                map.put(ISOChronology.periodDays(), PeriodField.of(this.days, ISOChronology.periodDays()));
            }
            if (this.hours != 0) {
                map.put(ISOChronology.periodHours(), PeriodField.of(this.hours, ISOChronology.periodHours()));
            }
            if (this.minutes != 0) {
                map.put(ISOChronology.periodMinutes(), PeriodField.of(this.minutes, ISOChronology.periodMinutes()));
            }
            if (this.seconds != 0) {
                map.put(ISOChronology.periodSeconds(), PeriodField.of(this.seconds, ISOChronology.periodSeconds()));
            }
            if (this.nanos != 0L) {
                map.put(ISOChronology.periodNanos(), PeriodField.of(this.nanos, ISOChronology.periodNanos()));
            }
            this.periodFields = fields = PeriodFields.create(map);
        }
        return fields;
    }

    public Duration toDuration() {
        if ((this.years | this.months | this.days) > 0) {
            throw new CalendricalException("Unable to convert period to duration as years/months/days are present: " + this);
        }
        long secs = ((long)this.hours * 60L + (long)this.minutes) * 60L + (long)this.seconds;
        return Duration.seconds(secs, this.nanos);
    }

    public Duration toDurationWith24HourDays() {
        if ((this.years | this.months) > 0) {
            throw new CalendricalException("Unable to convert period to duration as years/months are present: " + this);
        }
        long secs = (((long)this.days * 24L + (long)this.hours) * 60L + (long)this.minutes) * 60L + (long)this.seconds;
        return Duration.seconds(secs, this.nanos);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Period) {
            Period other = (Period)obj;
            return this.years == other.years && this.months == other.months && this.days == other.days & this.hours == other.hours && this.minutes == other.minutes && this.seconds == other.seconds && this.nanos == other.nanos;
        }
        return false;
    }

    public int hashCode() {
        return (this.years << 27 | this.years >>> 5) ^ (this.hours << 22 | this.hours >>> 10) ^ (this.months << 18 | this.months >>> 14) ^ (this.minutes << 12 | this.minutes >>> 20) ^ (this.days << 6 | this.days >>> 26) ^ this.seconds ^ (int)this.nanos + 37;
    }

    public String toString() {
        String str = this.string;
        if (str == null) {
            if (this == ZERO) {
                str = "PT0S";
            } else {
                StringBuilder buf = new StringBuilder();
                buf.append('P');
                if (this.years != 0) {
                    buf.append(this.years).append('Y');
                }
                if (this.months != 0) {
                    buf.append(this.months).append('M');
                }
                if (this.days != 0) {
                    buf.append(this.days).append('D');
                }
                if ((this.hours | this.minutes | this.seconds) != 0 || this.nanos != 0L) {
                    buf.append('T');
                    if (this.hours != 0) {
                        buf.append(this.hours).append('H');
                    }
                    if (this.minutes != 0) {
                        buf.append(this.minutes).append('M');
                    }
                    if (this.seconds != 0 || this.nanos != 0L) {
                        if (this.nanos == 0L) {
                            buf.append(this.seconds).append('S');
                        } else {
                            long s = (long)this.seconds + this.nanos / 1000000000L;
                            long n = this.nanos % 1000000000L;
                            if (s < 0L && n > 0L) {
                                n -= 1000000000L;
                                ++s;
                            } else if (s > 0L && n < 0L) {
                                n += 1000000000L;
                                --s;
                            }
                            if (n < 0L) {
                                n = -n;
                                if (s == 0L) {
                                    buf.append('-');
                                }
                            }
                            buf.append(s).append('.').append(n);
                            while (buf.charAt(buf.length() - 1) == '0') {
                                buf.setLength(buf.length() - 1);
                            }
                            buf.append('S');
                        }
                    }
                }
                str = buf.toString();
            }
            this.string = str;
        }
        return str;
    }
}

