/*
 * Decompiled with CFR 0.152.
 */
package javax.time.scales;

import javax.time.scales.ScaleUtil;
import javax.time.scales.UTCPeriod;
import javax.time.scales.UTC_TAI;

public class EarlyUTC_TAI {
    public static final long START_EPOCH_SECONDS = ScaleUtil.epochSeconds(1958, 1, 1);
    public static final long END_EPOCH_SECONDS = ScaleUtil.epochSeconds(1972, 1, 1);
    private static final long SECONDS_PER_DAY = 86400L;
    private static final int NANOS_PER_SECOND = 1000000000;
    private static final UTC_TAI<Entry> entries = new UTC_TAI((UTCPeriod[])new Entry[]{new Entry(1958, 1, 0, 36204, 1296000), new Entry(1961, 1, 1422818, 37300, 1296000), new Entry(1961, 8, 1372818), new Entry(1962, 1, 1845858, 37665, 1123200), new Entry(1963, 11, 1945858), new Entry(1964, 1, 3240130, 38761, 1296000), new Entry(1964, 4, 3340130), new Entry(1964, 9, 3440130), new Entry(1965, 1, 3540130), new Entry(1965, 3, 3640130), new Entry(1965, 7, 3740130), new Entry(1965, 9, 3840130), new Entry(1966, 1, 4313170, 39126, 2592000), new Entry(1968, 2, 4213170)});

    public static UTC_TAI<Entry> list() {
        return entries;
    }

    static {
        ((Entry)entries.get(entries.size() - 1)).endEpochSeconds = EarlyUTC_TAI.END_EPOCH_SECONDS;
        long nextDelta = 10000000000L;
        int i = entries.size();
        while (--i >= 0) {
            Entry e = (Entry)entries.get(i);
            long delta = e.getUTCDeltaNanoseconds(e.getEndEpochSeconds(), 0);
            long step = nextDelta - delta;
            if (step != 0L) {
                e.taiGapNanoseconds = (int)step;
                step -= Math.round(e.utcRate * 1.0E-9 * (double)step);
                e.utcGapNanoseconds = (int)step;
            }
            nextDelta = e.getUTCDeltaNanoseconds(e.getStartEpochSeconds(), 0);
        }
    }

    public static class Entry
    extends UTCPeriod {
        private long endEpochSeconds;
        private long deltaNanoseconds;
        private int originMJD;
        private int rateNanoseconds;
        private long originEpochSeconds;
        private double utcRate;
        private double taiRate;
        private int utcGapNanoseconds;
        private int taiGapNanoseconds;

        Entry(int startYear, int startMonth, int deltaMicroseconds) {
            super(startYear, startMonth, 1);
            this.deltaNanoseconds = 1000L * (long)deltaMicroseconds;
        }

        Entry(int startYear, int startMonth, int deltaMicroseconds, int originMJD, int rateNanoseconds) {
            this(startYear, startMonth, deltaMicroseconds);
            this.originMJD = originMJD;
            this.rateNanoseconds = rateNanoseconds;
        }

        @Override
        void initialise(UTCPeriod previous) {
            Entry p = (Entry)previous;
            if (p != null) {
                p.endEpochSeconds = this.getStartEpochSeconds();
            }
            if (this.originMJD == 0) {
                this.originMJD = p.originMJD;
                this.rateNanoseconds = p.rateNanoseconds;
                this.originEpochSeconds = p.originEpochSeconds;
                this.utcRate = p.utcRate;
                this.taiRate = p.taiRate;
            } else {
                this.originEpochSeconds = 86400L * (long)(this.originMJD - ScaleUtil.MJD_EPOCH);
                this.utcRate = (double)this.rateNanoseconds / 86400.0;
                this.taiRate = this.utcRate / (1.0 + this.utcRate / 1.0E9);
            }
            super.initialise(previous);
        }

        @Override
        public Entry getNext() {
            return (Entry)super.getNext();
        }

        @Override
        public Entry getPrevious() {
            return (Entry)super.getPrevious();
        }

        public long getEndEpochSeconds() {
            return this.endEpochSeconds;
        }

        public long getDeltaNanoseconds() {
            return this.deltaNanoseconds;
        }

        public int getOriginMJD() {
            return this.originMJD;
        }

        public int getRateNanoseconds() {
            return this.rateNanoseconds;
        }

        @Override
        public long getUTCDeltaNanoseconds(long utcEpochSeconds, int nanoOfSecond) {
            return this.deltaNanoseconds + Math.round(this.utcRate * ((double)(utcEpochSeconds - this.originEpochSeconds) + 1.0E-9 * (double)nanoOfSecond));
        }

        @Override
        public long getTAIDeltaNanoseconds(long taiEpochSeconds, int nanoOfSecond) {
            return this.deltaNanoseconds + Math.round(this.taiRate * ((double)(taiEpochSeconds - this.originEpochSeconds) + 1.0E-9 * (double)((long)nanoOfSecond - this.deltaNanoseconds)));
        }

        public int getUTCGapNanoseconds() {
            return this.utcGapNanoseconds;
        }

        public int getTaiGapNanoseconds() {
            return this.taiGapNanoseconds;
        }
    }
}

