/*
 * Decompiled with CFR 0.152.
 */
package javax.time.scales;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.time.CalendricalException;
import javax.time.scales.ScaleUtil;
import javax.time.scales.UTCPeriod;
import javax.time.scales.UTC_TAI;

public class LeapSeconds {
    public static final long START_EPOCH_SECONDS = ScaleUtil.epochSeconds(1972, 1, 1);
    private static UTC_TAI<Entry> list;
    private static long nextPossibleLeap;

    public static synchronized UTC_TAI<Entry> list() {
        if (list == null) {
            LeapSeconds.loadLeapSeconds();
        }
        return list;
    }

    public static synchronized long getNextPossibleLeap() {
        if (nextPossibleLeap == 0L) {
            LeapSeconds.loadLeapSeconds();
        }
        return nextPossibleLeap;
    }

    private static void loadLeapSeconds() {
        InputStream in = LeapSeconds.class.getResourceAsStream("LeapSeconds.txt");
        if (in == null) {
            throw new CalendricalException("LeapSeconds.txt resource missing");
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            ArrayList<Entry> entries = new ArrayList<Entry>();
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0 || line.charAt(0) == '#') continue;
                int index = 0;
                boolean possible = false;
                if (line.charAt(0) == '?') {
                    possible = true;
                    index = 1;
                }
                int x = line.indexOf(45, index);
                int year = Integer.parseInt(line.substring(index, x));
                index = x + 1;
                x = line.indexOf(45, index);
                int month = Integer.parseInt(line.substring(index, x));
                index = x + 1;
                x = line.indexOf(32);
                int day = Integer.parseInt(x < 0 ? line.substring(index) : line.substring(index, x));
                if (possible) {
                    nextPossibleLeap = ScaleUtil.epochSeconds(year, month, day);
                    continue;
                }
                entries.add(new Entry(year, month, day));
            }
            UTCPeriod[] entryArray = new Entry[entries.size()];
            entries.toArray(entryArray);
            list = new UTC_TAI(entryArray);
            in.close();
        }
        catch (IOException e) {
            throw new CalendricalException("Exception reading LeapSeconds.txt", e);
        }
    }

    public static class Entry
    extends UTCPeriod {
        private int deltaSeconds;
        private long deltaNanoseconds;

        Entry(int year, int month, int day) {
            super(year, month, day);
        }

        @Override
        public Entry getNext() {
            return (Entry)super.getNext();
        }

        @Override
        public Entry getPrevious() {
            return (Entry)super.getPrevious();
        }

        public int getDeltaSeconds() {
            return this.deltaSeconds;
        }

        @Override
        void initialise(UTCPeriod previous) {
            this.deltaSeconds = previous == null ? 10 : ((Entry)previous).deltaSeconds + 1;
            this.deltaNanoseconds = (long)this.deltaSeconds * 1000000000L;
            super.initialise(previous);
        }

        @Override
        public long getUTCDeltaNanoseconds(long utcEpochSeconds, int nanoOfSecond) {
            return this.deltaNanoseconds;
        }

        @Override
        public long getTAIDeltaNanoseconds(long taiEpochSeconds, int nanoOfSecond) {
            return this.deltaNanoseconds;
        }
    }
}

