/*
 * Decompiled with CFR 0.152.
 */
package javax.time.scales;

import javax.time.Duration;
import javax.time.MathUtils;
import javax.time.scales.EarlyUTC_TAI;
import javax.time.scales.LeapSeconds;
import javax.time.scales.TAI;
import javax.time.scales.TimeScaleInstant;

public class ScaleUtil {
    public static final int NANOS_PER_SECOND = 1000000000;
    private static long SECONDS_PER_DAY = 86400L;
    public static int MJD_EPOCH = ScaleUtil.modifiedJulianDay(1970, 1, 1);
    public static final long START_TAI = ScaleUtil.epochSeconds(1958, 1, 1);
    public static final long START_LEAP_SECONDS = ScaleUtil.epochSeconds(1972, 1, 1);
    public static final long TAI_START_LEAP_SECONDS = START_LEAP_SECONDS + 10L;

    private ScaleUtil() {
    }

    static void checkNotNull(Object object, String errorMessage) {
        if (object == null) {
            throw new NullPointerException(errorMessage);
        }
    }

    static TimeScaleInstant adjustUTCAroundGaps(TimeScaleInstant t, long resultEpochSeconds, int resultNanoOfSecond) {
        EarlyUTC_TAI.Entry e = EarlyUTC_TAI.list().entryFromUTC(resultEpochSeconds);
        if (resultEpochSeconds + 1L == e.getEndEpochSeconds() && resultNanoOfSecond - e.getUTCGapNanoseconds() > 1000000000) {
            int z = t.getEpochSeconds() < resultEpochSeconds ? -1 : (t.getEpochSeconds() > resultEpochSeconds ? 1 : t.getNanoOfSecond() - resultNanoOfSecond);
            if (z <= 0) {
                ++resultEpochSeconds;
                resultNanoOfSecond = 0;
            } else {
                resultNanoOfSecond = 1000000000 + e.getUTCGapNanoseconds();
            }
        }
        return TimeScaleInstant.seconds(t.getTimeScale(), resultEpochSeconds, 0, resultNanoOfSecond);
    }

    static TimeScaleInstant tai(long utcEpochSeconds, int nanoOfSecond) {
        if (utcEpochSeconds < START_TAI) {
            return TimeScaleInstant.seconds(TAI.INSTANCE, utcEpochSeconds, nanoOfSecond);
        }
        if (utcEpochSeconds < START_LEAP_SECONDS) {
            return ScaleUtil.fromEarlyInstant(utcEpochSeconds, nanoOfSecond);
        }
        return ScaleUtil.fromModernInstant(utcEpochSeconds, 0, nanoOfSecond);
    }

    static TimeScaleInstant tai(long utcEpochSeconds, int leapSecond, int nanoOfSecond) {
        if (utcEpochSeconds < START_TAI) {
            return TimeScaleInstant.seconds(TAI.INSTANCE, utcEpochSeconds, nanoOfSecond);
        }
        if (utcEpochSeconds < START_LEAP_SECONDS) {
            return ScaleUtil.fromEarlyInstant(utcEpochSeconds, nanoOfSecond);
        }
        return ScaleUtil.fromModernInstant(utcEpochSeconds, leapSecond, nanoOfSecond);
    }

    private static TimeScaleInstant fromEarlyInstant(long utcEpochSeconds, int nanoOfSecond) {
        EarlyUTC_TAI.Entry e = EarlyUTC_TAI.list().entryFromUTC(utcEpochSeconds);
        long nanos = (long)nanoOfSecond + e.getUTCDeltaNanoseconds(utcEpochSeconds, nanoOfSecond);
        TimeScaleInstant ts = TimeScaleInstant.seconds(TAI.INSTANCE, MathUtils.safeAdd(utcEpochSeconds, nanos / 1000000000L), (int)(nanos % 1000000000L));
        if (e.getNext() != null && ts.isAfter(e.getNext().getStartTAI())) {
            ts = e.getNext().getStartTAI();
        }
        return ts;
    }

    private static TimeScaleInstant fromModernInstant(long utcEpochSeconds, int leapSecond, int nanoOfSecond) {
        LeapSeconds.Entry e = LeapSeconds.list().entryFromUTC(utcEpochSeconds);
        return TimeScaleInstant.seconds(TAI.INSTANCE, MathUtils.safeAdd(utcEpochSeconds, (long)(e.getDeltaSeconds() + leapSecond)), nanoOfSecond);
    }

    static TimeScaleInstant.Validity checkEarlyValidity(TimeScaleInstant instant) {
        EarlyUTC_TAI.Entry e = EarlyUTC_TAI.list().entryFromUTC(instant.getEpochSeconds());
        int gap = e.getUTCGapNanoseconds();
        if (gap == 0 || instant.getEpochSeconds() < e.getEndEpochSeconds() - 1L) {
            return TimeScaleInstant.Validity.VALID;
        }
        if (instant.getNanoOfSecond() <= 1000000000 - Math.abs(gap)) {
            return TimeScaleInstant.Validity.VALID;
        }
        return gap < 0 ? TimeScaleInstant.Validity.INVALID : TimeScaleInstant.Validity.AMBIGUOUS;
    }

    public static TimeScaleInstant simpleAdd(TimeScaleInstant t, Duration d) {
        if (t.getTimeScale().supportsLeapSecond()) {
            throw new UnsupportedOperationException("simpleAdd does not support timescales with leap seconds");
        }
        long seconds = d.getSeconds();
        int nanos = d.getNanosInSecond();
        if (seconds == 0L && nanos == 0) {
            return t;
        }
        seconds = MathUtils.safeAdd(t.getEpochSeconds(), seconds);
        if ((nanos += t.getNanoOfSecond()) >= 1000000000) {
            nanos -= 1000000000;
            seconds = MathUtils.safeIncrement(seconds);
        }
        return TimeScaleInstant.seconds(t.getTimeScale(), seconds, nanos);
    }

    public static TimeScaleInstant simpleSubtract(TimeScaleInstant t, Duration d) {
        if (t.getTimeScale().supportsLeapSecond()) {
            throw new UnsupportedOperationException("simpleAdd does not support timescales with leap seconds");
        }
        long seconds = d.getSeconds();
        int nanos = d.getNanosInSecond();
        if (seconds == 0L && nanos == 0) {
            return t;
        }
        seconds = MathUtils.safeSubtract(t.getEpochSeconds(), seconds);
        nanos = t.getNanoOfSecond() - nanos;
        if (nanos < 0) {
            nanos += 1000000000;
            seconds = MathUtils.safeDecrement(seconds);
        }
        return TimeScaleInstant.seconds(t.getTimeScale(), seconds, nanos);
    }

    public static Duration durationBetween(TimeScaleInstant start, TimeScaleInstant end) {
        if (start.getTimeScale() != end.getTimeScale()) {
            throw new IllegalArgumentException("Start and end must be on the same time scale");
        }
        long secs = MathUtils.safeSubtract(end.getEpochSeconds(), start.getEpochSeconds());
        int nanos = end.getNanoOfSecond() - start.getNanoOfSecond();
        if (nanos < 0) {
            nanos += 1000000000;
            secs = MathUtils.safeDecrement(secs);
        }
        return Duration.seconds(secs, nanos);
    }

    public static int julianDayNumber(int year, int month, int day) {
        int a = (14 - month) / 12;
        int y = year + 4800 - a;
        int m = month + 12 * a - 3;
        return day + (153 * m + 2) / 5 + 365 * y + y / 4 - y / 100 + y / 400 - 32045;
    }

    public static int modifiedJulianDay(int year, int month, int day) {
        return ScaleUtil.julianDayNumber(year, month, day) - 2400001;
    }

    public static long epochSeconds(int year, int month, int day) {
        return SECONDS_PER_DAY * (long)(ScaleUtil.modifiedJulianDay(year, month, day) - MJD_EPOCH);
    }
}

