/*
 * Decompiled with CFR 0.152.
 */
package javax.time.scales;

import java.io.Serializable;
import javax.time.Duration;
import javax.time.Instant;
import javax.time.InstantProvider;
import javax.time.MathUtils;
import javax.time.scales.EarlyUTC_TAI;
import javax.time.scales.LeapSeconds;
import javax.time.scales.ScaleUtil;
import javax.time.scales.TAI;
import javax.time.scales.TimeScale;
import javax.time.scales.TimeScaleInstant;

class TrueUTC
implements TimeScale,
Serializable {
    static final TrueUTC INSTANCE = new TrueUTC();
    static final String NAME = "TrueUTC";
    private static final long serialVersionUID = 1L;

    private TrueUTC() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean supportsLeapSecond() {
        return true;
    }

    @Override
    public Instant toInstant(TimeScaleInstant tsi) {
        if (tsi.getTimeScale() != this) {
            return tsi.getTimeScale().toInstant(tsi);
        }
        return Instant.seconds(tsi.getEpochSeconds(), tsi.getNanoOfSecond());
    }

    @Override
    public TimeScaleInstant toTAI(TimeScaleInstant tsi) {
        if (tsi.getTimeScale() != this) {
            return tsi.getTimeScale().toTAI(tsi);
        }
        return ScaleUtil.tai(tsi.getEpochSeconds(), tsi.getLeapSecond(), tsi.getNanoOfSecond());
    }

    @Override
    public TimeScaleInstant toTimeScaleInstant(InstantProvider provider) {
        Instant t = Instant.from(provider);
        return TimeScaleInstant.seconds(this, t.getEpochSeconds(), t.getNanoOfSecond());
    }

    @Override
    public TimeScaleInstant toTimeScaleInstant(TimeScaleInstant tsi) {
        if (tsi.getTimeScale() == this) {
            return tsi;
        }
        String name = tsi.getTimeScale().getName();
        if (name == "UTC") {
            return TimeScaleInstant.seconds(this, tsi.getEpochSeconds(), tsi.getNanoOfSecond());
        }
        if (name != "TAI") {
            tsi = tsi.getTimeScale().toTAI(tsi);
        }
        return this.fromTAI(tsi);
    }

    private TimeScaleInstant fromTAI(TimeScaleInstant tsi) {
        if (tsi.compareTo(TAI.START_LEAP_SECONDS) >= 0) {
            return this.fromModernTAI(tsi);
        }
        if (tsi.compareTo(TAI.START_TAI) > 0) {
            return this.fromEarlyTAI(tsi);
        }
        return TimeScaleInstant.seconds(this, tsi.getEpochSeconds(), tsi.getNanoOfSecond());
    }

    private TimeScaleInstant fromModernTAI(TimeScaleInstant tsi) {
        int leapSecond;
        LeapSeconds.Entry e = LeapSeconds.list().entryFromTAI(tsi);
        long s = tsi.getEpochSeconds() - (long)e.getDeltaSeconds();
        if (e.getNext() != null && s >= e.getNext().getStartEpochSeconds()) {
            leapSecond = 1 + (int)(s - e.getNext().getStartEpochSeconds());
            s -= (long)leapSecond;
        } else {
            leapSecond = 0;
        }
        return TimeScaleInstant.seconds(this, s, leapSecond, tsi.getNanoOfSecond());
    }

    private TimeScaleInstant fromEarlyTAI(TimeScaleInstant tsi) {
        EarlyUTC_TAI.Entry e = EarlyUTC_TAI.list().entryFromTAI(tsi);
        long nanos = (long)tsi.getNanoOfSecond() - e.getTAIDeltaNanoseconds(tsi.getEpochSeconds(), tsi.getNanoOfSecond());
        long s = MathUtils.safeAdd(tsi.getEpochSeconds(), nanos / 1000000000L);
        if ((nanos %= 1000000000L) < 0L) {
            --s;
            nanos += 1000000000L;
        }
        if (s == e.getEndEpochSeconds() && (nanos -= (long)e.getUTCGapNanoseconds()) < 0L) {
            --s;
            nanos += 1000000000L;
        }
        return TimeScaleInstant.seconds(this, s, (int)nanos);
    }

    @Override
    public TimeScaleInstant.Validity getValidity(TimeScaleInstant tsi) {
        if (tsi.getTimeScale() != this) {
            return tsi.getTimeScale().getValidity(tsi);
        }
        if (tsi.getLeapSecond() != 0) {
            return tsi.getEpochSeconds() <= ScaleUtil.START_LEAP_SECONDS ? TimeScaleInstant.Validity.INVALID : this.checkLeapSecondValidity(tsi);
        }
        return tsi.getEpochSeconds() < ScaleUtil.START_LEAP_SECONDS && tsi.getEpochSeconds() > ScaleUtil.START_TAI ? ScaleUtil.checkEarlyValidity(tsi) : TimeScaleInstant.Validity.VALID;
    }

    private TimeScaleInstant.Validity checkLeapSecondValidity(TimeScaleInstant tsi) {
        if (tsi.getEpochSeconds() >= LeapSeconds.getNextPossibleLeap()) {
            return TimeScaleInstant.Validity.POSSIBLE;
        }
        LeapSeconds.Entry e = LeapSeconds.list().entryFromUTC(tsi.getEpochSeconds());
        return e.getNext() != null && tsi.getEpochSeconds() == e.getNext().getStartEpochSeconds() - 1L ? TimeScaleInstant.Validity.VALID : TimeScaleInstant.Validity.INVALID;
    }

    @Override
    public TimeScaleInstant add(TimeScaleInstant tsi, Duration dur) {
        if (tsi.getTimeScale() != this) {
            return tsi.getTimeScale().add(tsi, dur);
        }
        long seconds = dur.getSeconds();
        int nanos = dur.getNanosInSecond();
        if (seconds == 0L && nanos == 0) {
            return tsi;
        }
        seconds = MathUtils.safeAdd(tsi.getEpochSeconds(), seconds);
        if (tsi.getLeapSecond() != 0) {
            seconds = MathUtils.safeIncrement(seconds);
        }
        if ((nanos += tsi.getNanoOfSecond()) >= 1000000000) {
            nanos -= 1000000000;
            seconds = MathUtils.safeDecrement(seconds);
        }
        if (seconds < ScaleUtil.START_TAI && tsi.getEpochSeconds() < ScaleUtil.START_TAI) {
            return TimeScaleInstant.seconds(this, seconds, nanos);
        }
        return this.adjustResult(tsi, seconds, nanos);
    }

    private TimeScaleInstant adjustResult(TimeScaleInstant tsi, long resultEpochSeconds, int resultNanoOfSecond) {
        int leapSecond;
        LeapSeconds.Entry e;
        LeapSeconds.Entry et = tsi.getEpochSeconds() <= ScaleUtil.START_LEAP_SECONDS ? (LeapSeconds.Entry)LeapSeconds.list().get(0) : LeapSeconds.list().entryFromUTC(tsi.getEpochSeconds());
        if ((e = (resultEpochSeconds += (long)et.getDeltaSeconds()) <= ScaleUtil.TAI_START_LEAP_SECONDS ? (LeapSeconds.Entry)LeapSeconds.list().get(0) : LeapSeconds.list().entryFromTAI(resultEpochSeconds, resultNanoOfSecond)).getNext() != null && (resultEpochSeconds -= (long)e.getDeltaSeconds()) >= e.getNext().getStartEpochSeconds()) {
            --resultEpochSeconds;
            leapSecond = 1;
        } else {
            leapSecond = 0;
            if (resultEpochSeconds < ScaleUtil.START_LEAP_SECONDS && resultEpochSeconds > ScaleUtil.START_TAI) {
                return ScaleUtil.adjustUTCAroundGaps(tsi, resultEpochSeconds, resultNanoOfSecond);
            }
        }
        return TimeScaleInstant.seconds(this, resultEpochSeconds, leapSecond, resultNanoOfSecond);
    }

    @Override
    public TimeScaleInstant subtract(TimeScaleInstant tsi, Duration dur) {
        if (tsi.getTimeScale() != this) {
            return tsi.getTimeScale().subtract(tsi, dur);
        }
        long seconds = dur.getSeconds();
        int nanos = dur.getNanosInSecond();
        if (seconds == 0L && nanos == 0) {
            return tsi;
        }
        seconds = MathUtils.safeSubtract(tsi.getEpochSeconds(), seconds);
        if (tsi.getLeapSecond() != 0) {
            seconds = MathUtils.safeIncrement(seconds);
        }
        if ((nanos = tsi.getNanoOfSecond() - nanos) < 0) {
            nanos += 1000000000;
            seconds = MathUtils.safeDecrement(seconds);
        }
        if (seconds < ScaleUtil.START_TAI && tsi.getEpochSeconds() < ScaleUtil.START_TAI) {
            return TimeScaleInstant.seconds(tsi.getTimeScale(), seconds, nanos);
        }
        return this.adjustResult(tsi, seconds, nanos);
    }

    private int differenceAdjust(TimeScaleInstant tsi) {
        return (tsi.getEpochSeconds() <= ScaleUtil.START_LEAP_SECONDS ? 10 : LeapSeconds.list().entryFromUTC(tsi.getEpochSeconds()).getDeltaSeconds()) + tsi.getLeapSecond();
    }

    @Override
    public Duration durationBetween(TimeScaleInstant start, TimeScaleInstant end) {
        int adjust;
        if (start.getTimeScale() != this) {
            start = this.toTimeScaleInstant(start);
        }
        if (end.getTimeScale() != this) {
            end = this.toTimeScaleInstant(end);
        }
        long secs = MathUtils.safeSubtract(end.getEpochSeconds(), start.getEpochSeconds());
        int nanos = end.getNanoOfSecond() - start.getNanoOfSecond();
        if (nanos < 0) {
            nanos += 1000000000;
            secs = MathUtils.safeDecrement(secs);
        }
        if ((adjust = this.differenceAdjust(end) - this.differenceAdjust(start)) != 0) {
            secs = MathUtils.safeAdd(secs, (long)adjust);
        }
        return Duration.seconds(secs, nanos);
    }
}

