/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader.jdbm;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import jdbm.RecordManager;
import jdbm.RecordManagerFactory;
import jdbm.btree.BTree;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.TreeCache;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.loader.ExtendedCacheLoader;
import org.jboss.cache.loader.jdbm.Null;
import org.jboss.cache.marshall.RegionManager;
import org.jboss.cache.optimistic.FqnComparator;

public class JdbmCacheLoader
implements ExtendedCacheLoader {
    private static final Log log = LogFactory.getLog((Class)JdbmCacheLoader.class);
    private static final String KEYS = "K";
    private static final String NODE = "N";
    private static final String NAME = "JdbmCacheLoader";
    private String locationStr;
    private TreeCache treeCache;
    private String cacheDbName;
    private RecordManager recman;
    private BTree tree;
    private Map transactions = new ConcurrentHashMap();
    private RegionManager manager;

    public void create() throws Exception {
        this.checkNotOpen();
    }

    public void destroy() {
    }

    public void start() throws Exception {
        File homeDir;
        boolean created;
        File location;
        log.trace((Object)"Starting JdbmCacheLoader instance.");
        this.checkNotOpen();
        this.checkNonNull(this.treeCache, "TreeCache object is required");
        if (this.locationStr == null) {
            this.locationStr = System.getProperty("java.io.tmpdir");
        }
        if (!(location = new File(this.locationStr)).exists() && !(created = location.mkdirs())) {
            throw new IOException("Unable to create cache loader location " + location);
        }
        if (!location.isDirectory()) {
            throw new IOException("Cache loader location [" + location + "] is not a directory!");
        }
        int offset = this.locationStr.indexOf(35);
        if (offset >= 0 && offset < this.locationStr.length() - 1) {
            homeDir = new File(this.locationStr.substring(0, offset));
            this.cacheDbName = this.locationStr.substring(offset + 1);
        } else {
            homeDir = new File(this.locationStr);
            this.cacheDbName = this.treeCache.getClusterName();
        }
        try {
            this.openDatabase(new File(homeDir, this.cacheDbName));
        }
        catch (Exception e) {
            this.destroy();
            throw e;
        }
    }

    private void openDatabase(File f) throws Exception {
        Properties props = new Properties();
        this.recman = RecordManagerFactory.createRecordManager((String)f.toString(), (Properties)props);
        long recid = this.recman.getNamedObject(NAME);
        log.debug((Object)("JdbmCacheLoader located as " + recid));
        if (recid == 0L) {
            this.tree = BTree.createInstance((RecordManager)this.recman, (Comparator)new FqnComparator());
            this.recman.setNamedObject(NAME, this.tree.getRecid());
        } else {
            this.tree = BTree.load((RecordManager)this.recman, (long)recid);
        }
        log.info((Object)("JDBM database " + f + " opened with " + this.tree.size() + " entries"));
    }

    private void closeDatabases() {
        if (this.recman != null) {
            try {
                this.recman.close();
            }
            catch (Exception shouldNotOccur) {
                log.warn((Object)"Caught unexpected exception", (Throwable)shouldNotOccur);
            }
        }
        this.recman = null;
        this.tree = null;
    }

    public void stop() {
        log.debug((Object)"stop");
        this.closeDatabases();
    }

    public void setConfig(Properties props) {
        this.checkNotOpen();
        String string = this.locationStr = props != null ? props.getProperty("location") : null;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Configuring cache loader with location = " + this.locationStr));
        }
    }

    public void setCache(TreeCache c) {
        this.checkNotOpen();
        this.treeCache = c;
    }

    private Fqn keys(Fqn name) {
        return new Fqn(name, KEYS);
    }

    private Fqn key(Fqn name, Object key) {
        return new Fqn(name, KEYS, this.nullMask(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getChildrenNames(Fqn name) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("getChildrenNames " + name));
        }
        BTree bTree = this.tree;
        synchronized (bTree) {
            return this.getChildrenNames0(name);
        }
    }

    private Set getChildrenNames0(Fqn name) throws IOException {
        Fqn fqn;
        int size;
        Tuple t;
        TupleBrowser browser = this.tree.browse((Object)name);
        if (browser.getNext(t = new Tuple())) {
            if (!t.getValue().equals(NODE)) {
                log.trace((Object)" not a node");
                return null;
            }
        } else {
            log.trace((Object)" no nodes");
            return null;
        }
        HashSet<Object> set = new HashSet<Object>();
        int depth = name.size() + 1;
        while (browser.getNext(t) && (size = (fqn = (Fqn)t.getKey()).size()) >= depth) {
            if (size != depth || !t.getValue().equals(NODE)) continue;
            set.add(fqn.getLast());
        }
        if (set.isEmpty()) {
            return null;
        }
        return Collections.unmodifiableSet(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map get(Fqn name) throws Exception {
        this.checkOpen();
        this.checkNonNull(name, "name");
        if (this.tree.find((Object)name) == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("get, no node: " + name));
            }
            return null;
        }
        Fqn keys = this.keys(name);
        Tuple t = new Tuple();
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        BTree bTree = this.tree;
        synchronized (bTree) {
            Fqn fqn;
            TupleBrowser browser = this.tree.browse((Object)keys);
            while (browser.getNext(t) && (fqn = (Fqn)t.getKey()).isChildOf(keys)) {
                Object k = fqn.getLast();
                Object v = t.getValue();
                map.put(this.nullUnmask(k), this.nullUnmask(v));
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("get " + name + " map=" + map));
        }
        return map;
    }

    public boolean exists(Fqn name) throws IOException {
        return this.tree.find((Object)name) != null;
    }

    private void commit() throws Exception {
        this.recman.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Fqn name, Object key, Object value) throws Exception {
        Object object;
        try {
            object = this.put0(name, key, value);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.commit();
            throw throwable;
        }
        this.commit();
        return object;
    }

    private Object put0(Fqn name, Object key, Object value) throws Exception {
        this.checkNonNull(name, "name");
        this.makeNode(name);
        Fqn rec = this.key(name, key);
        Object oldValue = this.insert(rec, value);
        if (log.isTraceEnabled()) {
            log.trace((Object)("put " + rec + " value=" + value + " old=" + oldValue));
        }
        return oldValue;
    }

    public void put(Fqn name, Map values) throws Exception {
        this.put0(name, values);
        this.commit();
    }

    private void put0(Fqn name, Map values) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("put " + name + " values=" + values));
        }
        this.makeNode(name);
        if (values == null) {
            return;
        }
        Iterator i = values.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry me = i.next();
            Fqn rec = this.key(name, me.getKey());
            this.insert(rec, this.nullMask(me.getValue()));
        }
    }

    private void makeNode(Fqn fqn) throws IOException {
        int size;
        Fqn child;
        Object existing;
        if (this.exists(fqn)) {
            return;
        }
        for (int i = size = fqn.size(); i >= 0 && (existing = this.tree.insert((Object)(child = fqn.getFqnChild(i)), (Object)NODE, false)) == null; --i) {
        }
    }

    private Object insert(Fqn fqn, Object value) throws IOException {
        return this.nullUnmask(this.tree.insert((Object)fqn, this.nullMask(value), true));
    }

    private void erase0(Fqn name) throws IOException {
        this.erase0(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void erase0(Fqn name, boolean self) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("erase " + name + " self=" + self));
        }
        BTree bTree = this.tree;
        synchronized (bTree) {
            Fqn fqn;
            TupleBrowser browser = this.tree.browse((Object)name);
            Tuple t = new Tuple();
            if (browser.getNext(t) && self) {
                this.tree.remove(t.getKey());
            }
            while (browser.getNext(t) && (fqn = (Fqn)t.getKey()).isChildOf(name)) {
                this.tree.remove((Object)fqn);
            }
        }
    }

    private Object eraseKey0(Fqn name, Object key) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("eraseKey " + name + " key " + key));
        }
        Fqn fqnKey = this.key(name, key);
        try {
            return this.tree.remove((Object)fqnKey);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public void put(List modifications) throws Exception {
        this.checkOpen();
        this.checkNonNull(modifications, "modifications");
        this.apply(modifications);
        this.commit();
    }

    private void apply(List modifications) throws Exception {
        Iterator i = modifications.iterator();
        block8: while (i.hasNext()) {
            Modification mod = (Modification)i.next();
            Fqn name = mod.getFqn();
            switch (mod.getType()) {
                case 1: {
                    Object oldVal = this.put0(name, mod.getKey(), mod.getValue());
                    mod.setOldValue(oldVal);
                    continue block8;
                }
                case 2: {
                    this.put0(name, mod.getData());
                    continue block8;
                }
                case 3: {
                    this.erase0(name);
                    this.put0(name, mod.getData());
                    continue block8;
                }
                case 5: {
                    Object oldVal = this.eraseKey0(name, mod.getKey());
                    mod.setOldValue(oldVal);
                    continue block8;
                }
                case 4: {
                    this.erase0(name);
                    continue block8;
                }
                case 6: {
                    this.erase0(name, false);
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Unknown Modification type: " + mod.getType());
        }
    }

    public void remove(Fqn name) throws Exception {
        this.erase0(name);
        this.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Fqn name, Object key) throws Exception {
        Object object;
        try {
            object = this.eraseKey0(name, key);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.commit();
            throw throwable;
        }
        this.commit();
        return object;
    }

    public void removeData(Fqn name) throws Exception {
        this.erase0(name, false);
    }

    public void prepare(Object tx, List modifications, boolean onePhase) throws Exception {
        if (onePhase) {
            this.put(modifications);
        } else {
            this.transactions.put(tx, modifications);
        }
    }

    public void commit(Object tx) throws Exception {
        List modifications = (List)this.transactions.remove(tx);
        if (modifications == null) {
            throw new IllegalStateException("transaction " + tx + " not found in transaction table");
        }
        this.put(modifications);
        this.commit();
    }

    public void rollback(Object tx) {
        this.transactions.remove(tx);
    }

    public byte[] loadEntireState() throws Exception {
        return this.loadState(Fqn.ROOT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] loadState(Fqn subtree) throws Exception {
        ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
        try {
            this.setUnmarshallingClassLoader(subtree);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            Object object = this.tree;
            synchronized (object) {
                Fqn fqn;
                TupleBrowser browser = this.tree.browse((Object)subtree);
                Tuple t = new Tuple();
                while (browser.getNext(t) && (fqn = (Fqn)t.getKey()).isChildOrEquals(subtree)) {
                    oos.writeObject(fqn);
                    oos.writeObject(t.getValue());
                }
            }
            oos.flush();
            object = baos.toByteArray();
            Object var11_10 = null;
            Thread.currentThread().setContextClassLoader(currentCL);
            return object;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            Thread.currentThread().setContextClassLoader(currentCL);
            throw throwable;
        }
    }

    public void storeEntireState(byte[] state) throws Exception {
        this.storeState(state, Fqn.ROOT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeState(byte[] state, Fqn subtree) throws Exception {
        ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
        try {
            this.setUnmarshallingClassLoader(subtree);
            ByteArrayInputStream bais = new ByteArrayInputStream(state);
            ObjectInputStream ois = new ObjectInputStream(bais);
            this.erase0(subtree);
            boolean moveToBuddy = subtree.isChildOf(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN) && subtree.size() > 1;
            Fqn storeFqn = null;
            while (bais.available() > 0) {
                Fqn fqn = (Fqn)ois.readObject();
                storeFqn = moveToBuddy ? BuddyManager.getBackupFqn(subtree, fqn) : fqn;
                Object value = ois.readObject();
                this.tree.insert((Object)storeFqn, value, true);
            }
            this.commit();
            Object var11_10 = null;
            Thread.currentThread().setContextClassLoader(currentCL);
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            Thread.currentThread().setContextClassLoader(currentCL);
            throw throwable;
        }
    }

    private void checkOpen() {
        if (this.tree == null) {
            throw new IllegalStateException("Operation not allowed before calling create()");
        }
    }

    private void checkNotOpen() {
        if (this.tree != null) {
            throw new IllegalStateException("Operation not allowed after calling create()");
        }
    }

    private void checkNonNull(Object param, String paramName) {
        if (param == null) {
            throw new NullPointerException("Parameter must not be null: " + paramName);
        }
    }

    private Object nullMask(Object o) {
        return o == null ? Null.NULL : o;
    }

    private Object nullUnmask(Object o) {
        return o == Null.NULL ? null : o;
    }

    public void dump() throws IOException {
        this.dump(Fqn.ROOT);
    }

    public void dump(Object key) throws IOException {
        TupleBrowser browser = this.tree.browse(key);
        Tuple t = new Tuple();
        log.debug((Object)("contents: " + key));
        while (browser.getNext(t)) {
            log.debug((Object)(t.getKey() + "\t" + t.getValue()));
        }
        log.debug((Object)"");
    }

    public void setRegionManager(RegionManager manager) {
        this.manager = manager;
    }

    private void setUnmarshallingClassLoader(Fqn subtree) {
        if (this.manager != null) {
            this.manager.setUnmarshallingClassLoader(subtree);
        }
    }

    public String toString() {
        BTree bt = this.tree;
        int size = bt == null ? -1 : bt.size();
        return "JdbmCacheLoader locationStr=" + this.locationStr + " size=" + size;
    }
}

