/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profiler.jvmti;

import gnu.trove.TLongObjectHashMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.jboss.logging.Logger;
import org.jboss.profiler.jvmti.InventoryDataPoint;
import org.jboss.profiler.jvmti.JVMTICallBack;
import org.jboss.profiler.jvmti.JVMTIInterfaceMBean;
import org.jboss.profiler.jvmti.ReferenceDataPoint;

public class JVMTIInterface
implements JVMTIInterfaceMBean {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$profiler$jvmti$JVMTIInterface == null ? (class$org$jboss$profiler$jvmti$JVMTIInterface = JVMTIInterface.class$("org.jboss.profiler.jvmti.JVMTIInterface")) : class$org$jboss$profiler$jvmti$JVMTIInterface));
    private static boolean isLoaded = true;
    static /* synthetic */ Class class$org$jboss$profiler$jvmti$JVMTIInterface;

    private void addTo(Collection coll, Field[] obj) {
        for (int i = 0; i < obj.length; ++i) {
            coll.add(obj[i]);
            obj[i].setAccessible(true);
        }
    }

    public Field[] retrieveAllFields(Class clazz) {
        ArrayList list = new ArrayList();
        for (Class superClass = clazz; superClass != null; superClass = superClass.getSuperclass()) {
            this.addTo(list, superClass.getDeclaredFields());
        }
        return list.toArray(new Field[list.size()]);
    }

    public native void forceGC();

    public Class getClassByName(String className) {
        Class[] classes = this.getLoadedClasses();
        for (int i = 0; i < classes.length; ++i) {
            if (!classes[i].getName().equals(className)) continue;
            return classes[i];
        }
        return null;
    }

    public native void releaseTags();

    public native void notifyInventory(boolean var1, String var2, String var3, JVMTICallBack var4);

    public void notifyOnReferences(String temporaryFile, JVMTICallBack callback) {
        this.notifyInventory(false, temporaryFile, null, callback);
    }

    public native Object[] getReferenceHolders(Object[] var1);

    public native Class[] getLoadedClasses();

    public native Object[] getAllObjects(Class var1);

    public native long getTagOnObject(Object var1);

    public native Object getObjectOnTag(long var1);

    private native boolean internalIsConfiguredProperly();

    public boolean isActive() {
        if (!isLoaded) {
            return false;
        }
        return this.internalIsConfiguredProperly();
    }

    public Field getObjectField(Class clazz, int fieldId) {
        ArrayList list = new ArrayList();
        list.add(clazz);
        while ((clazz = clazz.getSuperclass()) != null) {
            list.add(clazz);
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            Field[] fields = ((Class)list.get(i)).getDeclaredFields();
            if (fieldId < fields.length) {
                return fields[fieldId];
            }
            fieldId -= fields.length;
        }
        return null;
    }

    public native String getMethodName(long var1);

    public native String getMethodSignature(long var1);

    public native Class getMethodClass(long var1);

    public Class[] retrieveLoadedClasses() {
        return this.getLoadedClasses();
    }

    protected static native void heapSnapshot(String var0, String var1, String var2);

    public void heapSnapshot(String basicFileName, String suffix) {
        this.forceGC();
        JVMTIInterface.heapSnapshot(basicFileName + "_classes" + "." + suffix, basicFileName + "_references" + "." + suffix, basicFileName + "_objects" + "." + suffix);
    }

    public Object[] getAllObjects(String clazz) {
        ArrayList<Object> list = new ArrayList<Object>();
        Class[] classes = this.getLoadedClasses();
        for (int i = 0; i < classes.length; ++i) {
            if (!classes[i].getName().equals(clazz)) continue;
            Object[] objs = this.getAllObjects(classes[i]);
            for (int count = 0; count < objs.length; ++count) {
                list.add(objs[count]);
            }
        }
        return list.toArray();
    }

    private String callToString(Object obj, boolean callToString) {
        try {
            if (obj == null) {
                return "null";
            }
            if (callToString) {
                return obj.toString();
            }
            if (obj instanceof Class) {
                return obj.toString();
            }
            return obj.getClass().getName() + "@" + System.identityHashCode(obj);
        }
        catch (Throwable e) {
            return obj.getClass().getName() + " toString had an Exception ";
        }
    }

    private void exploreObject(PrintWriter out, Object source, int currentLevel, int maxLevel, boolean useToString, boolean weakAndSoft, HashMap mapDataPoints, HashSet alreadyExplored) {
        String level = null;
        StringBuffer levelStr = new StringBuffer();
        for (int i = 0; i <= currentLevel; ++i) {
            levelStr.append("!--");
        }
        level = levelStr.toString();
        if (maxLevel >= 0 && currentLevel >= maxLevel) {
            out.println("<br>" + level + "<b>MaxLevel</b>");
            return;
        }
        Integer index = new Integer(System.identityHashCode(source));
        if (alreadyExplored.contains(index)) {
            if (source instanceof Class) {
                out.println("<br>" + level + " object instanceOf " + source + "@" + index + " was already described before on this report");
            } else {
                out.println("<br>" + level + " object instanceOf " + source.getClass() + "@" + index + " was already described before on this report");
            }
            return;
        }
        alreadyExplored.add(index);
        log.info((Object)("resolving references of " + this.callToString(source, useToString) + "..."));
        Long sourceTag = new Long(this.getTagOnObject(source));
        ArrayList listPoints = (ArrayList)mapDataPoints.get(sourceTag);
        if (listPoints == null) {
            log.info((Object)"didn't find references");
            return;
        }
        log.info((Object)"References found");
        Iterator iter = listPoints.iterator();
        while (iter.hasNext()) {
            ReferenceDataPoint point = (ReferenceDataPoint)iter.next();
            Object nextReference = this.treatReference(level, out, point, useToString);
            if (nextReference != null && !weakAndSoft && (nextReference instanceof WeakReference || nextReference instanceof SoftReference)) {
                nextReference = null;
            }
            if (nextReference == null) continue;
            this.exploreObject(out, nextReference, currentLevel + 1, maxLevel, useToString, weakAndSoft, mapDataPoints, alreadyExplored);
        }
    }

    public Object treatReference(String level, PrintWriter out, ReferenceDataPoint point, boolean useToString) {
        Object referenceHolder = null;
        referenceHolder = point.getReferenceHolder() == 0L || point.getReferenceHolder() == -1L ? null : this.getObjectOnTag(point.getReferenceHolder());
        Object nextReference = null;
        switch (point.getReferenceType()) {
            case 1: {
                out.print("<br>" + level + "InstanceOfReference:");
                out.println("ToString=" + this.callToString(referenceHolder, useToString));
                nextReference = referenceHolder;
                break;
            }
            case 2: {
                Class<?> clazz;
                Field field;
                String fieldName = null;
                fieldName = referenceHolder == null ? "Reference GONE" : ((field = this.getObjectField(clazz = referenceHolder.getClass(), (int)point.getIndex())) == null ? "UndefinedField@" + referenceHolder : field.toString());
                out.print("<br>" + level + " FieldReference " + fieldName + "=" + this.callToString(referenceHolder, useToString));
                nextReference = referenceHolder;
                break;
            }
            case 3: {
                if (referenceHolder == null) {
                    out.println("<br>" + level + " arrayRef Position " + point.getIndex() + " is gone");
                } else {
                    out.println("<br>" + level + " arrayRef " + referenceHolder.getClass().getName() + "[" + point.getIndex() + "] id=@" + System.identityHashCode(referenceHolder));
                }
                nextReference = referenceHolder;
                break;
            }
            case 4: {
                out.println("<br>" + level + "ClassLoaderReference @ " + this.callToString(referenceHolder, useToString));
                nextReference = referenceHolder;
                break;
            }
            case 5: {
                out.println("<br>" + level + "ReferenceSigner@" + this.callToString(referenceHolder, useToString));
                nextReference = referenceHolder;
                break;
            }
            case 6: {
                out.println("<br>" + level + "ProtectionDomain@" + this.callToString(referenceHolder, useToString));
                nextReference = referenceHolder;
                break;
            }
            case 7: {
                out.println("<br>" + level + "ReferenceInterface@" + this.callToString(referenceHolder, useToString));
                nextReference = referenceHolder;
                break;
            }
            case 8: {
                Class clazz = (Class)referenceHolder;
                Field field = this.getObjectField(clazz, (int)point.getIndex());
                String fieldName = null;
                fieldName = field == null ? "UndefinedField@" + referenceHolder : field.toString();
                out.println("<br>" + level + " StaticFieldReference " + fieldName);
                nextReference = null;
                break;
            }
            case 9: {
                out.println("<br>" + level + "ReferenceInterface@" + this.callToString(referenceHolder, useToString));
                nextReference = referenceHolder;
                break;
            }
            case 10: {
                out.println("<br>" + level + "Root");
                nextReference = null;
                break;
            }
            case 11: {
                Class methodClass = this.getMethodClass(point.getMethod());
                if (methodClass != null) {
                    String className = null;
                    if (methodClass != null) {
                        className = methodClass.getName();
                    }
                    Thread.yield();
                    String methodName = this.getMethodName(point.getMethod());
                    out.println("<br>" + level + " Reference inside a method - " + className + "::" + methodName);
                }
                nextReference = null;
                break;
            }
            default: {
                log.warn((Object)("unexpected reference " + point));
            }
        }
        return nextReference;
    }

    public HashMap createIndexMatrix() throws IOException {
        final HashMap referencesMap = new HashMap();
        File tmpFile = File.createTempFile("tmpRefs", ".tmp");
        this.notifyOnReferences(tmpFile.getAbsolutePath(), new JVMTICallBack(){
            int count = 0;

            public void notifyReference(long referenceHolder, long referencedObject, long classTag, long index, long method, byte referenceType) {
                if (this.count == 0) {
                    log.info((Object)"started receiving references");
                }
                ++this.count;
                if (this.count % 1000 == 0) {
                    log.info((Object)(this.count + " references received"));
                }
                ReferenceDataPoint dataPoint = new ReferenceDataPoint(referenceHolder, referencedObject, classTag, index, method, referenceType);
                Long indexLong = new Long(referencedObject);
                ArrayList<ReferenceDataPoint> arrayList = (ArrayList<ReferenceDataPoint>)referencesMap.get(indexLong);
                if (arrayList == null) {
                    arrayList = new ArrayList<ReferenceDataPoint>();
                    referencesMap.put(indexLong, arrayList);
                }
                arrayList.add(dataPoint);
            }

            public void notifyClass(long classTag, Class clazz) {
            }

            public void notifyObject(long classTag, long objectId, long bytes) {
            }
        });
        tmpFile.delete();
        return referencesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exploreClassReferences(String className, int maxLevel, boolean solveReferencesOnClasses, boolean solveReferencesOnClassLoaders, boolean useToString, boolean weakAndSoft, boolean printObjects) {
        this.forceGC();
        if (!(solveReferencesOnClasses || solveReferencesOnClassLoaders || printObjects)) {
            return "<b> you have to select at least solveReferences || solveClassLoaders || printObjects </b>";
        }
        HashMap referencesMap = null;
        try {
            referencesMap = this.createIndexMatrix();
        }
        catch (Exception e) {
            CharArrayWriter charArray = new CharArrayWriter();
            PrintWriter out = new PrintWriter(charArray);
            e.printStackTrace(out);
            return charArray.toString();
        }
        try {
            String string = this.exploreClassReferences(className, maxLevel, solveReferencesOnClasses, solveReferencesOnClassLoaders, useToString, weakAndSoft, printObjects, referencesMap);
            return string;
        }
        finally {
            referencesMap.clear();
            this.releaseTags();
        }
    }

    public String exploreClassReferences(String className, int maxLevel, boolean solveReferencesOnClasses, boolean solveReferencesOnClassLoaders, boolean useToString, boolean weakAndSoft, boolean printObjects, HashMap referencesMap) {
        CharArrayWriter charArray = new CharArrayWriter();
        PrintWriter out = new PrintWriter(charArray);
        try {
            Class[] loadClasses = this.getLoadedClasses();
            for (int i = 0; i < loadClasses.length; ++i) {
                if (!loadClasses[i].getName().equals(className)) continue;
                out.println("<br><br><br><b>References to " + loadClasses[i] + "</b>");
                if (solveReferencesOnClasses) {
                    this.exploreObject(out, loadClasses[i], 0, maxLevel, useToString, weakAndSoft, referencesMap, new HashSet());
                }
                if (solveReferencesOnClassLoaders && loadClasses[i].getClassLoader() != null) {
                    out.println("<br><b><i>references to its classloader " + loadClasses[i].getClassLoader() + "</i></b>");
                    this.exploreObject(out, loadClasses[i].getClassLoader(), 0, maxLevel, useToString, weakAndSoft, referencesMap, new HashSet());
                }
                out.println("<br>");
                if (!printObjects) continue;
                Object[] objects = this.getAllObjects(loadClasses[i]);
                for (int j = 0; j < objects.length; ++j) {
                    out.println("obj[" + j + "]=" + objects[j]);
                }
            }
            loadClasses = null;
            return charArray.toString();
        }
        catch (Exception e) {
            charArray = new CharArrayWriter();
            out = new PrintWriter(charArray);
            e.printStackTrace(out);
            return charArray.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exploreObjectReferences(String className, int maxLevel, boolean useToString) {
        this.forceGC();
        Object[] obj = this.getAllObjects(className);
        HashMap referencesMap = null;
        try {
            referencesMap = this.createIndexMatrix();
        }
        catch (Exception e) {
            CharArrayWriter charArray = new CharArrayWriter();
            PrintWriter out2 = new PrintWriter(charArray);
            e.printStackTrace(out2);
            return charArray.toString();
        }
        CharArrayWriter charArray = new CharArrayWriter();
        PrintWriter out = new PrintWriter(charArray);
        try {
            if (obj.length > 100) {
                out.println("obj List too big (>100)=" + obj.length);
                String out2 = charArray.toString();
                return out2;
            }
            for (int i = 0; i < obj.length; ++i) {
                out.println("<br><b>References to obj[" + i + "]=" + (useToString ? obj[i].toString() : obj[i].getClass().getName()));
                out.println(this.exploreObjectReferences(referencesMap, obj[i], maxLevel, useToString));
            }
            String string = charArray.toString();
            return string;
        }
        finally {
            referencesMap.clear();
            this.releaseTags();
        }
    }

    public String exploreObjectReferences(HashMap referencesMap, Object thatObject, int maxLevel, boolean useToString) {
        CharArrayWriter charArray = new CharArrayWriter();
        PrintWriter out = new PrintWriter(charArray);
        try {
            this.exploreObject(out, thatObject, 0, maxLevel, useToString, false, referencesMap, new HashSet());
            out.println("<br>");
            return charArray.toString();
        }
        catch (Exception e) {
            charArray = new CharArrayWriter();
            out = new PrintWriter(charArray);
            e.printStackTrace(out);
            return charArray.toString();
        }
    }

    public void forceReleaseOnSoftReferences() {
        SoftReference<Object> reference = new SoftReference<Object>(new Object());
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        try {
            do {
                list.add("A Big String A Big String A Big String A Big String A Big String A Big String A Big String A Big String A Big String A Big String A Big String " + i++);
            } while (i % 1000 != 0 || reference.get() != null);
            System.out.println("Break as the soft reference was gone");
        }
        catch (Throwable e) {
            // empty catch block
        }
        list.clear();
        try {
            ByteArrayOutputStream byteout = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(byteout);
            out.writeObject(new Dummy());
            ByteArrayInputStream byteInput = new ByteArrayInputStream(byteout.toByteArray());
            ObjectInputStream input = new ObjectInputStream(byteInput);
            input.readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.forceGC();
    }

    public String listClassesHTMLReport() throws Exception {
        try {
            ClassLoader loader;
            Iterator iterClassLoader;
            this.forceGC();
            CharArrayWriter charArray = new CharArrayWriter();
            PrintWriter out = new PrintWriter(charArray);
            Collection classSet = this.createTreeSet(new ClassSorterByClassName());
            boolean printedHeader = false;
            ClassLoader systemClassLoaderDummy = new ClassLoader(){

                public String toString() {
                    return "SystemClassLoader";
                }
            };
            ArrayList<ClassLoader> classLoaderDuplicates = new ArrayList<ClassLoader>();
            Iterator iter = classSet.iterator();
            String currentName = null;
            Class currentClass = null;
            while (iter.hasNext()) {
                ClassLoader loader2;
                currentClass = (Class)iter.next();
                if (currentName != currentClass.getName()) {
                    if (classLoaderDuplicates.size() > 1) {
                        if (!printedHeader) {
                            out.println("<br><b>List of duplicated classes</b>");
                            printedHeader = true;
                        }
                        out.println("<br><b> Class " + currentName + " was loaded on these classLoaders:</b>");
                        iterClassLoader = classLoaderDuplicates.iterator();
                        while (iterClassLoader.hasNext()) {
                            loader = (ClassLoader)iterClassLoader.next();
                            out.println("<br>" + loader.toString());
                        }
                    }
                    currentName = currentClass.getName();
                    classLoaderDuplicates.clear();
                }
                if ((loader2 = currentClass.getClassLoader()) == null) {
                    loader2 = systemClassLoaderDummy;
                }
                classLoaderDuplicates.add(loader2);
                currentName = currentClass.getName();
            }
            if (classLoaderDuplicates.size() > 1) {
                out.println("<br><b> Class " + currentName + " was loaded on these classLoaders:</b>");
                iterClassLoader = classLoaderDuplicates.iterator();
                while (iterClassLoader.hasNext()) {
                    loader = (ClassLoader)iterClassLoader.next();
                    out.println("<br>" + loader.toString());
                }
            }
            out.println("<br><b>List of classes by ClassLoader</b>");
            classSet = this.retrieveLoadedClassesByClassLoader();
            ClassLoader currentClassLoader = new ClassLoader(){};
            out.println("<br>");
            iter = classSet.iterator();
            while (iter.hasNext()) {
                Class clazz = (Class)iter.next();
                if (currentClassLoader != clazz.getClassLoader()) {
                    currentClassLoader = clazz.getClassLoader();
                    out.println("<br><b>ClassLoader = " + (currentClassLoader == null ? "System Class Loader" : currentClassLoader.toString()) + "</b>");
                }
                out.println("Class = " + clazz.getName());
            }
            return new String(charArray.toCharArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public Collection retrieveLoadedClassesByClassName() {
        Collection classSet = this.createTreeSet(new ClassSorterByClassName());
        return classSet;
    }

    public Collection retrieveLoadedClassesByClassLoader() {
        Collection classSet = this.createTreeSet(new ClassSorterByClassLoader());
        return classSet;
    }

    private Collection createTreeSet(Comparator comparator) {
        Class[] classes = this.getLoadedClasses();
        ArrayList<Class> classSet = new ArrayList<Class>();
        for (int i = 0; i < classes.length; ++i) {
            classSet.add(classes[i]);
        }
        Collections.sort(classSet, comparator);
        return classSet;
    }

    public boolean compareInventories(PrintStream reportOutput, Map map1, Map map2, Class[] ignoredClasses, String[] prefixesToIgnore, InventoryDataPoint[] expectedIncreases) {
        HashSet<Class> ignoredItems = new HashSet<Class>();
        if (ignoredClasses != null) {
            for (int i = 0; i < ignoredClasses.length; ++i) {
                ignoredItems.add(ignoredClasses[i]);
            }
        }
        HashMap<Class, InventoryDataPoint> expectedIncreasesHash = new HashMap<Class, InventoryDataPoint>();
        if (expectedIncreases != null) {
            for (int i = 0; i < expectedIncreases.length; ++i) {
                Class clazz = expectedIncreases[i].getClazz();
                expectedIncreasesHash.put(clazz, expectedIncreases[i]);
            }
        }
        this.addExpectedIncrease(expectedIncreasesHash, "java.lang.ref.ReferenceQueue$Lock", 1);
        this.addExpectedIncrease(expectedIncreasesHash, "java.util.WeakHashMap", 1);
        this.addExpectedIncrease(expectedIncreasesHash, "java.lang.ref.ReferenceQueue", 1);
        this.addExpectedIncrease(expectedIncreasesHash, "[Ljava.util.WeakHashMap$Entry;", 1);
        this.addExpectedIncrease(expectedIncreasesHash, "java.lang.ref.WeakReference", map1.size());
        this.addExpectedIncrease(expectedIncreasesHash, "java.util.WeakHashMap$Entry", map1.size());
        boolean reportOK = true;
        Iterator iterMap1 = map1.entrySet().iterator();
        while (iterMap1.hasNext()) {
            Map.Entry entry = iterMap1.next();
            Class clazz = (Class)entry.getKey();
            boolean isIgnoredPrefix = false;
            if (prefixesToIgnore != null) {
                for (int i = 0; i < prefixesToIgnore.length; ++i) {
                    if (!clazz.getName().startsWith(prefixesToIgnore[i])) continue;
                    isIgnoredPrefix = true;
                    break;
                }
            }
            if (isIgnoredPrefix || ignoredItems.contains(entry.getKey())) continue;
            InventoryDataPoint point1 = (InventoryDataPoint)entry.getValue();
            InventoryDataPoint point2 = (InventoryDataPoint)map2.get(clazz);
            if (point2 == null || point2.getInstances() <= point1.getInstances()) continue;
            InventoryDataPoint expectedIncrease = (InventoryDataPoint)expectedIncreasesHash.get(clazz);
            boolean failed = true;
            if (expectedIncrease != null && point2.getInstances() - point1.getInstances() <= expectedIncrease.getInstances()) {
                failed = false;
            }
            if (!failed) continue;
            int expected = 0;
            if (expectedIncrease != null) {
                expected = expectedIncrease.getInstances();
            }
            reportOK = false;
            reportOutput.println("<br> Class " + clazz.getName() + " had an increase of " + (point2.getInstances() - point1.getInstances() - expected) + " instances represented by " + (point2.getBytes() - point1.getBytes()) + " bytes");
            if (expectedIncrease == null) continue;
            reportOutput.print("<br> " + (point2.getInstances() - point1.getInstances() - expectedIncrease.getInstances()) + " higher than expected");
        }
        return reportOK;
    }

    private void addExpectedIncrease(HashMap expectedIncreasesHash, String name, int numberOfInstances) {
        Class tmpClass = this.getClassByName(name);
        if (tmpClass != null) {
            expectedIncreasesHash.put(tmpClass, new InventoryDataPoint(tmpClass, numberOfInstances));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map produceInventory() throws IOException {
        this.forceGC();
        InnerCallBack callBack = new InnerCallBack();
        File tmpFileObjects = File.createTempFile("delete-me", ".objects");
        try {
            this.notifyInventory(true, null, tmpFileObjects.getAbsolutePath(), callBack);
        }
        finally {
            if (tmpFileObjects.exists()) {
                try {
                    tmpFileObjects.delete();
                }
                catch (Exception exception) {}
            }
        }
        return callBack.maps;
    }

    public String inventoryReport() throws Exception {
        Map map = this.produceInventory();
        TreeSet valuesSet = new TreeSet(map.values());
        Iterator iterDataPoints = valuesSet.iterator();
        CharArrayWriter charArray = new CharArrayWriter();
        PrintWriter out = new PrintWriter(charArray);
        out.println("<table><tr><td>Class</td><td>#Instances</td><td>#Bytes</td></tr>");
        while (iterDataPoints.hasNext()) {
            InventoryDataPoint point = (InventoryDataPoint)iterDataPoints.next();
            out.println("<tr><td>" + point.getClazz().getName() + "</td><td>" + point.getInstances() + "</td><td>" + point.getBytes() + "</td></tr>");
        }
        out.println("</table>");
        return charArray.toString();
    }

    public String printObjects(String className) throws Exception {
        CharArrayWriter charArray = new CharArrayWriter();
        PrintWriter out = new PrintWriter(charArray);
        Object[] objects = this.getAllObjects(className);
        out.println("<table>");
        for (int i = 0; i < objects.length; ++i) {
            out.println("<tr><td>");
            out.println(objects[i]);
            if (!(objects[i] instanceof Object[])) continue;
            out.println("</td><td>");
            out.println("array of " + ((Object[])objects[i]).length);
            out.println("</td></tr>");
        }
        out.println("</table>");
        return charArray.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            System.loadLibrary("jbossAgent");
        }
        catch (Throwable e) {
            isLoaded = false;
            log.error((Object)"The DLL couldn't be loaded, you won't be able to use any JVMTIInterface feature", e);
        }
    }

    static class InnerCallBack
    implements JVMTICallBack {
        TLongObjectHashMap classesMap = new TLongObjectHashMap();
        WeakHashMap maps = new WeakHashMap();

        InnerCallBack() {
        }

        public void notifyClass(long classTag, Class clazz) {
            this.classesMap.put(classTag, (Object)clazz);
        }

        public void notifyObject(long classTag, long objectId, long bytes) {
            Class clazz = (Class)this.classesMap.get(classTag);
            if (clazz != null) {
                InventoryDataPoint point = (InventoryDataPoint)this.maps.get(clazz);
                if (point == null) {
                    point = new InventoryDataPoint(clazz);
                    this.maps.put(clazz, point);
                }
                point.bytes += bytes;
                ++point.instances;
            }
        }

        public void notifyReference(long referenceHolder, long referencedObject, long classTag, long index, long method, byte referenceType) {
        }
    }

    static class Dummy
    implements Serializable {
        private static final long serialVersionUID = 1L;

        Dummy() {
        }
    }

    static class ClassSorterByClassName
    implements Comparator {
        ClassSorterByClassName() {
        }

        public int compare(Object o1, Object o2) {
            Class left = (Class)o1;
            Class right = (Class)o2;
            int compare = left.getName().compareTo(right.getName());
            return compare;
        }
    }

    static class ClassSorterByClassLoader
    implements Comparator {
        ClassSorterByClassLoader() {
        }

        public int compare(Object o1, Object o2) {
            Class left = (Class)o1;
            Class right = (Class)o2;
            int compare = 0;
            compare = this.compareClassLoader(left.getClassLoader(), right.getClassLoader());
            if (compare != 0) {
                return compare;
            }
            return left.getName().compareTo(right.getName());
        }

        public int compareClassLoader(ClassLoader left, ClassLoader right) {
            if (left == null || right == null) {
                if (left == right) {
                    return 0;
                }
                if (left == null) {
                    return -1;
                }
                return 1;
            }
            return left.toString().compareTo(right.toString());
        }
    }
}

