/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.util.uuid;

import java.io.DataInput;
import java.io.IOException;
import java.io.Serializable;
import java.util.StringTokenizer;
import org.apache.jackrabbit.util.uuid.Bytes;
import org.apache.jackrabbit.util.uuid.Constants;
import org.apache.jackrabbit.util.uuid.VersionFourGenerator;

public class UUID
implements Constants,
Serializable,
Comparable {
    private byte[] rawBytes = new byte[16];
    private Long node = null;
    private long timestamp = -1L;
    private Short clockSq = null;
    private int version = -1;
    private int variant = -1;
    private String stringValue = null;
    private static VersionFourGenerator versionFourGenereator = new VersionFourGenerator();

    public UUID() {
    }

    public UUID(UUID copyFrom) {
        this.rawBytes = copyFrom.getRawBytes();
    }

    public UUID(byte[] byteArray) throws IllegalArgumentException {
        if (byteArray.length != 16) {
            throw new IllegalArgumentException("UUID must be contructed using a 16 byte array.");
        }
        System.arraycopy(byteArray, 0, this.rawBytes, 0, 16);
    }

    public UUID(DataInput input) throws IOException {
        input.readFully(this.rawBytes, 0, 16);
    }

    public UUID(long mostSignificant, long leastSignificant) {
        this.rawBytes = Bytes.append(Bytes.toBytes(mostSignificant), Bytes.toBytes(leastSignificant));
    }

    public UUID(String uuidString) {
        this(UUID.fromString(uuidString));
    }

    public static UUID fromString(String uuidString) throws IllegalArgumentException {
        String leanString = uuidString.toLowerCase();
        UUID tmpUUID = null;
        int pos = uuidString.lastIndexOf(":");
        if (pos > 1) {
            leanString = uuidString.substring(++pos, uuidString.length());
        }
        if (leanString.length() != 36) {
            throw new IllegalArgumentException();
        }
        StringTokenizer tok = new StringTokenizer(leanString, "-");
        if (tok.countTokens() != 5) {
            throw new IllegalArgumentException();
        }
        StringBuffer buf = new StringBuffer(32);
        String token = null;
        int count = 0;
        while (tok.hasMoreTokens()) {
            token = tok.nextToken();
            if (token.length() != TOKEN_LENGTHS[count++]) {
                throw new IllegalArgumentException();
            }
            buf.append(token);
        }
        String s = buf.toString();
        byte[] bytes = new byte[16];
        int j = 0;
        for (int i = 0; i < 32; i += 2) {
            bytes[j++] = (byte)Integer.parseInt(s.substring(i, i + 2), 16);
        }
        tmpUUID = new UUID(bytes);
        return tmpUUID;
    }

    public String toString() {
        if (this.stringValue == null) {
            char[] chars = new char[36];
            int j = 0;
            for (int i = 0; i < 16; ++i) {
                chars[j++] = hexDigits[this.rawBytes[i] >> 4 & 0xF];
                chars[j++] = hexDigits[this.rawBytes[i] & 0xF];
                if (i != 3 && i != 5 && i != 7 && i != 9) continue;
                chars[j++] = 45;
            }
            this.stringValue = new String(chars);
        }
        return this.stringValue;
    }

    public String toUrn() {
        return "urn:uuid:" + this.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UUID)) {
            return false;
        }
        return Bytes.areEqual(((UUID)obj).getRawBytes(), this.rawBytes);
    }

    public int hashCode() {
        int iConstant = 37;
        int iTotal = 17;
        for (int i = 0; i < this.rawBytes.length; ++i) {
            iTotal = iTotal * iConstant + this.rawBytes[i];
        }
        return iTotal;
    }

    public int compareTo(Object compareTo) throws ClassCastException {
        if (!(compareTo instanceof UUID)) {
            throw new ClassCastException();
        }
        return Bytes.compareTo(this.rawBytes, ((UUID)compareTo).getRawBytes());
    }

    public int clockSequence() throws UnsupportedOperationException {
        if (this.variant() != 2 || this.version() != 1) {
            throw new UnsupportedOperationException("Not a ietf variant 2 or version 1 (time-based UUID)");
        }
        if (this.clockSq == null) {
            byte[] b = new byte[]{(byte)(this.rawBytes[8] & 0x3F), this.rawBytes[9]};
            this.clockSq = new Short(Bytes.toShort(b));
        }
        return this.clockSq.intValue();
    }

    public int version() {
        if (this.version == -1) {
            this.version = this.rawBytes[6] >>> 4 & 0xF;
        }
        return this.version;
    }

    public int variant() {
        if (this.variant == -1) {
            this.variant = (this.rawBytes[8] & 0x80) == 0 ? 0 : ((this.rawBytes[8] & 0x40) == 0 ? 2 : ((this.rawBytes[8] & 0x20) == 0 ? 6 : 7));
        }
        return this.variant;
    }

    public long node() throws UnsupportedOperationException {
        if (this.variant() != 2 || this.version() != 1) {
            throw new UnsupportedOperationException("Not a ietf variant 2 or version 1 (time-based UUID)");
        }
        if (this.node == null) {
            byte[] b = new byte[8];
            System.arraycopy(this.rawBytes, 10, b, 2, 6);
            this.node = new Long(Bytes.toLong(b) & 0xFFFFFFFFFFFFL);
        }
        return this.node;
    }

    public long timestamp() throws UnsupportedOperationException {
        if (this.variant() != 2 || this.version() != 1) {
            throw new UnsupportedOperationException("Not a ietf variant 2 or version 1 (time-based UUID)");
        }
        if (this.timestamp == -1L) {
            byte[] longVal = new byte[8];
            System.arraycopy(this.rawBytes, 6, longVal, 0, 2);
            System.arraycopy(this.rawBytes, 4, longVal, 2, 2);
            System.arraycopy(this.rawBytes, 0, longVal, 4, 4);
            longVal[0] = (byte)(longVal[0] & 0xF);
            this.timestamp = Bytes.toLong(longVal);
        }
        return this.timestamp;
    }

    long getLeastSignificantBits() {
        byte[] lsb = new byte[8];
        System.arraycopy(this.rawBytes, 8, lsb, 0, 8);
        return Bytes.toLong(lsb);
    }

    long getMostSignificantBits() {
        byte[] msb = new byte[8];
        System.arraycopy(this.rawBytes, 0, msb, 0, 8);
        return Bytes.toLong(msb);
    }

    public byte[] getRawBytes() {
        byte[] ret = new byte[16];
        System.arraycopy(this.rawBytes, 0, ret, 0, 16);
        return ret;
    }

    public static UUID randomUUID() {
        return (UUID)versionFourGenereator.nextIdentifier();
    }
}

