/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.value;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.util.Base64;
import org.apache.jackrabbit.util.Text;

public class ValueHelper {
    private ValueHelper() {
    }

    public static String serialize(Value value, boolean encodeBlanks) throws IllegalStateException, RepositoryException {
        StringWriter writer = new StringWriter();
        try {
            ValueHelper.serialize(value, encodeBlanks, writer);
        }
        catch (IOException ioe) {
            throw new RepositoryException("failed to serialize value", (Throwable)ioe);
        }
        return writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(Value value, boolean encodeBlanks, Writer writer) throws IllegalStateException, IOException, RepositoryException {
        if (value.getType() == 2) {
            InputStream in = value.getStream();
            try {
                Base64.encode(in, writer);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        String textVal = value.getString();
        if (encodeBlanks) {
            textVal = Text.replace(textVal, " ", "_x0020_");
        }
        writer.write(textVal);
    }

    public static Value deserialize(ValueFactory factory, String value, int type, boolean decodeBlanks) throws ValueFormatException, RepositoryException {
        if (type == 2) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                Base64.decode(value, (OutputStream)baos);
            }
            catch (IOException ioe) {
                throw new RepositoryException("failed to decode binary value", (Throwable)ioe);
            }
            return factory.createValue((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        }
        if (decodeBlanks) {
            value = Text.replace(value, "_x0020_", " ");
        }
        return factory.createValue(value, type);
    }

    public static Value deserialize(ValueFactory factory, Reader reader, int type, boolean decodeBlanks) throws IOException, ValueFormatException, RepositoryException {
        int read;
        if (type == 2) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Base64.decode(reader, (OutputStream)baos);
            return factory.createValue((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        }
        char[] chunk = new char[8192];
        StringBuffer buf = new StringBuffer();
        while ((read = reader.read(chunk)) > -1) {
            buf.append(chunk, 0, read);
        }
        String value = buf.toString();
        if (decodeBlanks) {
            value = Text.replace(value, "_x0020_", " ");
        }
        return factory.createValue(value, type);
    }
}

