/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.client;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.Version;
import javax.jcr.version.VersionIterator;
import org.apache.jackrabbit.rmi.client.LocalAdapterFactory;
import org.apache.jackrabbit.rmi.iterator.ArrayNodeIterator;
import org.apache.jackrabbit.rmi.iterator.ArrayNodeTypeIterator;
import org.apache.jackrabbit.rmi.iterator.ArrayPropertyIterator;
import org.apache.jackrabbit.rmi.iterator.ArrayVersionIterator;
import org.apache.jackrabbit.rmi.remote.RemoteItem;
import org.apache.jackrabbit.rmi.remote.RemoteNode;
import org.apache.jackrabbit.rmi.remote.RemoteNodeDefinition;
import org.apache.jackrabbit.rmi.remote.RemoteNodeType;
import org.apache.jackrabbit.rmi.remote.RemoteProperty;
import org.apache.jackrabbit.rmi.remote.RemotePropertyDefinition;
import org.apache.jackrabbit.rmi.remote.RemoteVersion;
import org.apache.jackrabbit.rmi.remote.RemoteVersionHistory;

public class ClientObject {
    private LocalAdapterFactory factory;

    protected ClientObject(LocalAdapterFactory factory) {
        this.factory = factory;
    }

    protected LocalAdapterFactory getFactory() {
        return this.factory;
    }

    protected Item getItem(Session session, RemoteItem remote) {
        if (remote instanceof RemoteProperty) {
            return this.factory.getProperty(session, (RemoteProperty)remote);
        }
        if (remote instanceof RemoteNode) {
            return this.getNode(session, (RemoteNode)remote);
        }
        return this.factory.getItem(session, remote);
    }

    protected Node getNode(Session session, RemoteNode remote) {
        if (remote instanceof RemoteVersion) {
            return this.factory.getVersion(session, (RemoteVersion)remote);
        }
        if (remote instanceof RemoteVersionHistory) {
            return this.factory.getVersionHistory(session, (RemoteVersionHistory)remote);
        }
        return this.factory.getNode(session, remote);
    }

    protected PropertyIterator getPropertyIterator(Session session, RemoteProperty[] remotes) {
        if (remotes != null) {
            Property[] properties = new Property[remotes.length];
            for (int i = 0; i < remotes.length; ++i) {
                properties[i] = this.factory.getProperty(session, remotes[i]);
            }
            return new ArrayPropertyIterator(properties);
        }
        return new ArrayPropertyIterator(new Property[0]);
    }

    protected NodeIterator getNodeIterator(Session session, RemoteNode[] remotes) {
        if (remotes != null) {
            Node[] nodes = new Node[remotes.length];
            for (int i = 0; i < remotes.length; ++i) {
                nodes[i] = this.getNode(session, remotes[i]);
            }
            return new ArrayNodeIterator(nodes);
        }
        return new ArrayNodeIterator(new Node[0]);
    }

    protected Version[] getVersionArray(Session session, RemoteVersion[] remotes) {
        if (remotes != null) {
            Version[] versions = new Version[remotes.length];
            for (int i = 0; i < remotes.length; ++i) {
                versions[i] = this.factory.getVersion(session, remotes[i]);
            }
            return versions;
        }
        return new Version[0];
    }

    protected VersionIterator getVersionIterator(Session session, RemoteVersion[] remotes) {
        return new ArrayVersionIterator(this.getVersionArray(session, remotes));
    }

    protected NodeType[] getNodeTypeArray(RemoteNodeType[] remotes) {
        if (remotes != null) {
            NodeType[] types = new NodeType[remotes.length];
            for (int i = 0; i < remotes.length; ++i) {
                types[i] = this.factory.getNodeType(remotes[i]);
            }
            return types;
        }
        return new NodeType[0];
    }

    protected NodeTypeIterator getNodeTypeIterator(RemoteNodeType[] remotes) {
        return new ArrayNodeTypeIterator(this.getNodeTypeArray(remotes));
    }

    protected NodeDefinition[] getNodeDefArray(RemoteNodeDefinition[] remotes) {
        if (remotes != null) {
            NodeDefinition[] defs = new NodeDefinition[remotes.length];
            for (int i = 0; i < remotes.length; ++i) {
                defs[i] = this.factory.getNodeDef(remotes[i]);
            }
            return defs;
        }
        return new NodeDefinition[0];
    }

    protected PropertyDefinition[] getPropertyDefArray(RemotePropertyDefinition[] remotes) {
        if (remotes != null) {
            PropertyDefinition[] defs = new PropertyDefinition[remotes.length];
            for (int i = 0; i < remotes.length; ++i) {
                defs[i] = this.factory.getPropertyDef(remotes[i]);
            }
            return defs;
        }
        return new PropertyDefinition[0];
    }
}

