/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.client;

import java.rmi.RemoteException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.rmi.client.ClientObject;
import org.apache.jackrabbit.rmi.client.LocalAdapterFactory;
import org.apache.jackrabbit.rmi.client.RemoteRepositoryException;
import org.apache.jackrabbit.rmi.iterator.ArrayNodeIterator;
import org.apache.jackrabbit.rmi.iterator.ArrayRowIterator;
import org.apache.jackrabbit.rmi.remote.RemoteNode;
import org.apache.jackrabbit.rmi.remote.RemoteQueryResult;
import org.apache.jackrabbit.rmi.remote.RemoteRow;

public class ClientQueryResult
extends ClientObject
implements QueryResult {
    private Session session;
    private RemoteQueryResult remote;

    public ClientQueryResult(Session session, RemoteQueryResult remote, LocalAdapterFactory factory) {
        super(factory);
        this.session = session;
        this.remote = remote;
    }

    public String[] getColumnNames() throws RepositoryException {
        try {
            return this.remote.getColumnNames();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public RowIterator getRows() throws RepositoryException {
        try {
            RemoteRow[] remotes = this.remote.getRows();
            if (remotes != null) {
                Row[] rows = new Row[remotes.length];
                for (int i = 0; i < rows.length; ++i) {
                    rows[i] = this.getFactory().getRow(remotes[i]);
                }
                return new ArrayRowIterator(rows);
            }
            return new ArrayRowIterator(new Row[0]);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public NodeIterator getNodes() throws RepositoryException {
        try {
            RemoteNode[] remotes = this.remote.getNodes();
            if (remotes != null) {
                Node[] nodes = new Node[remotes.length];
                for (int i = 0; i < nodes.length; ++i) {
                    nodes[i] = this.getNode(this.session, remotes[i]);
                }
                return new ArrayNodeIterator(nodes);
            }
            return new ArrayNodeIterator(new Node[0]);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }
}

