/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.observation;

import java.rmi.RemoteException;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.rmi.observation.Queue;
import org.apache.jackrabbit.rmi.remote.RemoteEventCollection;
import org.apache.jackrabbit.rmi.server.RemoteAdapterFactory;

public class ServerEventListenerProxy
implements EventListener {
    private static final Log log = LogFactory.getLog(ServerEventListenerProxy.class);
    private final RemoteAdapterFactory factory;
    private final long listenerId;
    private final Queue queue;

    public ServerEventListenerProxy(RemoteAdapterFactory factory, long listenerId, Queue queue) {
        this.factory = factory;
        this.listenerId = listenerId;
        this.queue = queue;
    }

    public void onEvent(EventIterator events) {
        try {
            RemoteEventCollection remoteEvent = this.factory.getRemoteEvent(this.listenerId, events);
            this.queue.put(remoteEvent);
        }
        catch (RemoteException re) {
            Throwable t = re.getCause() == null ? re : re.getCause();
            log.error((Object)("Problem creating remote event for " + this.listenerId), t);
        }
    }

    public int hashCode() {
        return (int)this.listenerId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ServerEventListenerProxy) {
            return this.listenerId == ((ServerEventListenerProxy)obj).listenerId;
        }
        return false;
    }

    public String toString() {
        return "EventListenerProxy: listenerId=" + this.listenerId;
    }
}

