/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.server;

import java.rmi.RemoteException;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import org.apache.jackrabbit.rmi.remote.RemoteVersion;
import org.apache.jackrabbit.rmi.remote.RemoteVersionHistory;
import org.apache.jackrabbit.rmi.server.RemoteAdapterFactory;
import org.apache.jackrabbit.rmi.server.ServerNode;

public class ServerVersion
extends ServerNode
implements RemoteVersion {
    private Version version;

    public ServerVersion(Version version, RemoteAdapterFactory factory) throws RemoteException {
        super((Node)version, factory);
        this.version = version;
    }

    public Calendar getCreated() throws RepositoryException {
        try {
            return this.version.getCreated();
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteVersion[] getSuccessors() throws RepositoryException, RemoteException {
        try {
            return this.getRemoteVersionArray(this.version.getSuccessors());
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteVersion[] getPredecessors() throws RepositoryException, RemoteException {
        try {
            return this.getRemoteVersionArray(this.version.getPredecessors());
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteVersionHistory getContainingHistory() throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteVersionHistory(this.version.getContainingHistory());
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }
}

