/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.value;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.rmi.value.BaseNonStreamValue;
import org.apache.jackrabbit.rmi.value.StatefulValue;

public class DateValue
extends BaseNonStreamValue
implements Serializable,
StatefulValue {
    private static final long serialVersionUID = 7158448867450810873L;
    private final Calendar value;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    protected DateValue(Calendar value) {
        this.value = value;
    }

    protected DateValue(String value) throws ValueFormatException {
        this(DateValue.toCalendar(value));
    }

    protected static Calendar toCalendar(String value) throws ValueFormatException {
        DateFormat dateFormat = DATE_FORMAT;
        synchronized (dateFormat) {
            try {
                Calendar time = Calendar.getInstance();
                time.setTime(DATE_FORMAT.parse(value));
                return time;
            }
            catch (ParseException pe) {
                throw new ValueFormatException(pe.getMessage());
            }
        }
    }

    public int getType() {
        return 5;
    }

    public double getDouble() {
        return this.value.getTimeInMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString() {
        DateFormat dateFormat = DATE_FORMAT;
        synchronized (dateFormat) {
            return DATE_FORMAT.format(this.value.getTime());
        }
    }

    public long getLong() {
        return this.value.getTimeInMillis();
    }

    public Calendar getDate() {
        return (Calendar)this.value.clone();
    }
}

