/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.cli.avalon.CLArgsParser;
import org.apache.commons.cli.avalon.CLOption;
import org.apache.commons.cli.avalon.CLOptionDescriptor;
import org.apache.commons.cli.avalon.CLUtil;
import org.apache.jmeter.NewDriver;
import org.apache.jmeter.ProxyAuthenticator;
import org.apache.jmeter.engine.ClientJMeterEngine;
import org.apache.jmeter.engine.JMeterEngine;
import org.apache.jmeter.engine.RemoteJMeterEngineImpl;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.MainFrame;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.Load;
import org.apache.jmeter.gui.tree.JMeterTreeListener;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.plugin.JMeterPlugin;
import org.apache.jmeter.plugin.PluginManager;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.reporters.Summariser;
import org.apache.jmeter.samplers.Remoteable;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestListener;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.util.BeanShellServer;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.gui.ComponentUtil;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class JMeter
implements JMeterPlugin {
    private static transient Logger log = LoggingManager.getLoggerForClass();
    private static final int PROPFILE_OPT = 112;
    private static final int PROPFILE2_OPT = 113;
    private static final int TESTFILE_OPT = 116;
    private static final int LOGFILE_OPT = 108;
    private static final int NONGUI_OPT = 110;
    private static final int HELP_OPT = 104;
    private static final int VERSION_OPT = 118;
    private static final int SERVER_OPT = 115;
    private static final int PROXY_HOST = 72;
    private static final int PROXY_PORT = 80;
    private static final int PROXY_USERNAME = 117;
    private static final int PROXY_PASSWORD = 97;
    private static final int JMETER_PROPERTY = 74;
    private static final int SYSTEM_PROPERTY = 68;
    private static final int LOGLEVEL = 76;
    private static final int REMOTE_OPT = 114;
    private static final int JMETER_HOME_OPT = 100;
    private static final CLOptionDescriptor[] options = new CLOptionDescriptor[]{new CLOptionDescriptor("help", 8, 104, "print usage information and exit"), new CLOptionDescriptor("version", 8, 118, "print the version information and exit"), new CLOptionDescriptor("propfile", 2, 112, "the jmeter property file to use"), new CLOptionDescriptor("addprop", 34, 113, "additional property file(s)"), new CLOptionDescriptor("testfile", 2, 116, "the jmeter test(.jmx) file to run"), new CLOptionDescriptor("logfile", 2, 108, "the file to log samples to"), new CLOptionDescriptor("nongui", 8, 110, "run JMeter in nongui mode"), new CLOptionDescriptor("server", 8, 115, "run the JMeter server"), new CLOptionDescriptor("proxyHost", 2, 72, "Set a proxy server for JMeter to use"), new CLOptionDescriptor("proxyPort", 2, 80, "Set proxy server port for JMeter to use"), new CLOptionDescriptor("username", 2, 117, "Set username for proxy server that JMeter is to use"), new CLOptionDescriptor("password", 2, 97, "Set password for proxy server that JMeter is to use"), new CLOptionDescriptor("jmeterproperty", 48, 74, "Define additional JMeter properties"), new CLOptionDescriptor("systemproperty", 48, 68, "Define additional JMeter properties"), new CLOptionDescriptor("loglevel", 48, 76, "Define loglevel: [category=]level e.g. jorphan=INFO or jmeter.util=DEBUG"), new CLOptionDescriptor("runremote", 8, 114, "Start remote servers from non-gui mode"), new CLOptionDescriptor("homedir", 2, 100, "the jmeter home directory to use")};
    transient boolean testEnded = false;
    private JMeter parent;
    private static final String[][] DEFAULT_ICONS = new String[][]{{(class$org$apache$jmeter$control$gui$TestPlanGui == null ? (class$org$apache$jmeter$control$gui$TestPlanGui = JMeter.class$("org.apache.jmeter.control.gui.TestPlanGui")) : class$org$apache$jmeter$control$gui$TestPlanGui).getName(), "org/apache/jmeter/images/beaker.gif"}, {(class$org$apache$jmeter$timers$gui$AbstractTimerGui == null ? (class$org$apache$jmeter$timers$gui$AbstractTimerGui = JMeter.class$("org.apache.jmeter.timers.gui.AbstractTimerGui")) : class$org$apache$jmeter$timers$gui$AbstractTimerGui).getName(), "org/apache/jmeter/images/timer.gif"}, {(class$org$apache$jmeter$threads$gui$ThreadGroupGui == null ? (class$org$apache$jmeter$threads$gui$ThreadGroupGui = JMeter.class$("org.apache.jmeter.threads.gui.ThreadGroupGui")) : class$org$apache$jmeter$threads$gui$ThreadGroupGui).getName(), "org/apache/jmeter/images/thread.gif"}, {(class$org$apache$jmeter$visualizers$gui$AbstractVisualizer == null ? (class$org$apache$jmeter$visualizers$gui$AbstractVisualizer = JMeter.class$("org.apache.jmeter.visualizers.gui.AbstractVisualizer")) : class$org$apache$jmeter$visualizers$gui$AbstractVisualizer).getName(), "org/apache/jmeter/images/meter.png"}, {(class$org$apache$jmeter$config$gui$AbstractConfigGui == null ? (class$org$apache$jmeter$config$gui$AbstractConfigGui = JMeter.class$("org.apache.jmeter.config.gui.AbstractConfigGui")) : class$org$apache$jmeter$config$gui$AbstractConfigGui).getName(), "org/apache/jmeter/images/testtubes.png"}, {(class$org$apache$jmeter$control$gui$AbstractControllerGui == null ? (class$org$apache$jmeter$control$gui$AbstractControllerGui = JMeter.class$("org.apache.jmeter.control.gui.AbstractControllerGui")) : class$org$apache$jmeter$control$gui$AbstractControllerGui).getName(), "org/apache/jmeter/images/knob.gif"}, {(class$org$apache$jmeter$control$gui$WorkBenchGui == null ? (class$org$apache$jmeter$control$gui$WorkBenchGui = JMeter.class$("org.apache.jmeter.control.gui.WorkBenchGui")) : class$org$apache$jmeter$control$gui$WorkBenchGui).getName(), "org/apache/jmeter/images/clipboard.gif"}, {(class$org$apache$jmeter$samplers$gui$AbstractSamplerGui == null ? (class$org$apache$jmeter$samplers$gui$AbstractSamplerGui = JMeter.class$("org.apache.jmeter.samplers.gui.AbstractSamplerGui")) : class$org$apache$jmeter$samplers$gui$AbstractSamplerGui).getName(), "org/apache/jmeter/images/pipet.png"}};
    static /* synthetic */ Class class$org$apache$jmeter$control$gui$TestPlanGui;
    static /* synthetic */ Class class$org$apache$jmeter$timers$gui$AbstractTimerGui;
    static /* synthetic */ Class class$org$apache$jmeter$threads$gui$ThreadGroupGui;
    static /* synthetic */ Class class$org$apache$jmeter$visualizers$gui$AbstractVisualizer;
    static /* synthetic */ Class class$org$apache$jmeter$config$gui$AbstractConfigGui;
    static /* synthetic */ Class class$org$apache$jmeter$control$gui$AbstractControllerGui;
    static /* synthetic */ Class class$org$apache$jmeter$control$gui$WorkBenchGui;
    static /* synthetic */ Class class$org$apache$jmeter$samplers$gui$AbstractSamplerGui;

    public void startGui(CLOption testFile) {
        PluginManager.install(this, true);
        JMeterTreeModel treeModel = new JMeterTreeModel();
        JMeterTreeListener treeLis = new JMeterTreeListener(treeModel);
        treeLis.setActionHandler(ActionRouter.getInstance());
        GuiPackage.getInstance(treeLis, treeModel);
        MainFrame main = new MainFrame(ActionRouter.getInstance(), treeModel, treeLis);
        main.setTitle("Apache JMeter");
        main.setIconImage(JMeterUtils.getImage("jmeter.jpg").getImage());
        ComponentUtil.centerComponentInWindow((Component)main, (int)80);
        main.show();
        ActionRouter.getInstance().actionPerformed(new ActionEvent(main, 1, "add_all"));
        if (testFile != null) {
            try {
                File f = new File(testFile.getArgument());
                log.info("Loading file: " + f);
                FileInputStream reader = new FileInputStream(f);
                HashTree tree = SaveService.loadTree(reader);
                GuiPackage.getInstance().setTestPlanFile(f.getAbsolutePath());
                new Load().insertLoadedTree(1, tree);
            }
            catch (Exception e) {
                log.error("Failure loading test file", (Throwable)e);
                JMeterUtils.reportErrorToUser(e.toString());
            }
        }
    }

    public void start(String[] args) {
        CLArgsParser parser = new CLArgsParser(args, options);
        if (null != parser.getErrorString()) {
            System.err.println("Error: " + parser.getErrorString());
            System.out.println("Usage");
            System.out.println(CLUtil.describeOptions((CLOptionDescriptor[])options).toString());
            return;
        }
        try {
            this.initializeProperties(parser);
            this.setProxy(parser);
            log.info("Version " + JMeterUtils.getJMeterVersion());
            log.info("java.version=" + System.getProperty("java.version"));
            log.info("Locale=" + Locale.getDefault().getDisplayName());
            log.info(JMeterUtils.getJMeterCopyright());
            this.updateClassLoader();
            if (parser.getArgumentById(118) != null) {
                System.out.println(JMeterUtils.getJMeterCopyright());
                System.out.println("Version " + JMeterUtils.getJMeterVersion());
            } else if (parser.getArgumentById(104) != null) {
                System.out.println(JMeterUtils.getResourceFileAsText("org/apache/jmeter/help.txt"));
            } else if (parser.getArgumentById(115) != null) {
                this.startServer(JMeterUtils.getPropDefault("server_port", 0));
                this.startBSH();
            } else if (parser.getArgumentById(110) == null) {
                this.startGui(parser.getArgumentById(116));
                this.startBSH();
            } else {
                this.startNonGui(parser.getArgumentById(116), parser.getArgumentById(108), parser.getArgumentById(114));
                this.startBSH();
            }
        }
        catch (IllegalUserActionException e) {
            System.out.println(e.getMessage());
            System.out.println("Incorrect Usage");
            System.out.println(CLUtil.describeOptions((CLOptionDescriptor[])options).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("An error occurred: " + e.getMessage());
            System.exit(-1);
        }
    }

    private void updateClassLoader() {
        String userpath = JMeterUtils.getPropDefault("user.classpath", "");
        if (userpath.length() > 0) {
            log.info("user.classpath=" + userpath);
            StringTokenizer tok = new StringTokenizer(userpath, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                String path = tok.nextToken();
                File f = new File(path);
                if (!f.canRead() && !f.isDirectory()) {
                    log.warn("Can't read " + path);
                    continue;
                }
                try {
                    URL url = new URL("file", "", path);
                    NewDriver.addURL(url);
                }
                catch (MalformedURLException e) {
                    log.warn("Can't create URL for " + path + " " + e);
                }
            }
        }
    }

    private void startBSH() {
        int bshport = JMeterUtils.getPropDefault("beanshell.server.port", 0);
        String bshfile = JMeterUtils.getPropDefault("beanshell.server.file", "");
        if (bshport > 0) {
            log.info("Starting Beanshell server (" + bshport + "," + bshfile + ")");
            BeanShellServer t = new BeanShellServer(bshport, bshfile);
            t.run();
        }
    }

    private void setProxy(CLArgsParser parser) throws IllegalUserActionException {
        String p;
        if (parser.getArgumentById(117) != null) {
            String u;
            if (parser.getArgumentById(97) != null) {
                u = parser.getArgumentById(117).getArgument();
                p = parser.getArgumentById(97).getArgument();
                Authenticator.setDefault(new ProxyAuthenticator(u, p));
                log.info("Set Proxy login: " + u + "/" + p);
            } else {
                u = parser.getArgumentById(117).getArgument();
                Authenticator.setDefault(new ProxyAuthenticator(u, ""));
                log.info("Set Proxy login: " + u);
            }
        }
        if (parser.getArgumentById(72) != null && parser.getArgumentById(80) != null) {
            String h = parser.getArgumentById(72).getArgument();
            System.setProperty("http.proxyHost", h);
            System.setProperty("https.proxyHost", parser.getArgumentById(72).getArgument());
            p = parser.getArgumentById(80).getArgument();
            System.setProperty("http.proxyPort", p);
            System.setProperty("https.proxyPort", parser.getArgumentById(80).getArgument());
            log.info("Set http[s].proxyHost: " + h + " Port: " + p);
        } else if (parser.getArgumentById(72) != null || parser.getArgumentById(80) != null) {
            throw new IllegalUserActionException(JMeterUtils.getResString("proxy_cl_error"));
        }
    }

    private void initializeProperties(CLArgsParser parser) {
        if (parser.getArgumentById(112) != null) {
            JMeterUtils.getProperties(parser.getArgumentById(112).getArgument());
        } else {
            JMeterUtils.getProperties(NewDriver.getJMeterDir() + File.separator + "bin" + File.separator + "jmeter.properties");
        }
        if (parser.getArgumentById(100) == null) {
            JMeterUtils.setJMeterHome(NewDriver.getJMeterDir());
        } else {
            JMeterUtils.setJMeterHome(parser.getArgumentById(100).getArgument());
        }
        Properties jmeterProps = JMeterUtils.getJMeterProperties();
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        block9: for (int i = 0; i < size; ++i) {
            CLOption option = (CLOption)clOptions.get(i);
            String name = option.getArgument(0);
            String value = option.getArgument(1);
            switch (option.getDescriptor().getId()) {
                case 113: {
                    File f = new File(name);
                    try {
                        jmeterProps.load(new FileInputStream(f));
                    }
                    catch (FileNotFoundException e) {
                        log.warn("Can't find additional property file: " + name, (Throwable)e);
                    }
                    catch (IOException e) {
                        log.warn("Error loading additional property file: " + name, (Throwable)e);
                    }
                    continue block9;
                }
                case 68: {
                    if (value.length() > 0) {
                        log.info("Setting System property: " + name + "=" + value);
                        System.getProperties().setProperty(name, value);
                        continue block9;
                    }
                    log.warn("Removing System property: " + name);
                    System.getProperties().remove(name);
                    continue block9;
                }
                case 74: {
                    if (value.length() > 0) {
                        log.info("Setting JMeter property: " + name + "=" + value);
                        jmeterProps.setProperty(name, value);
                        continue block9;
                    }
                    log.warn("Removing JMeter property: " + name);
                    jmeterProps.remove(name);
                    continue block9;
                }
                case 76: {
                    if (value.length() > 0) {
                        log.info("LogLevel: " + name + "=" + value);
                        LoggingManager.setPriority((String)value, (String)name);
                        continue block9;
                    }
                    log.warn("LogLevel: " + name);
                    LoggingManager.setPriority((String)name);
                }
            }
        }
    }

    public void startServer() {
        this.startServer(0);
    }

    public void startServer(int port) {
        try {
            new RemoteJMeterEngineImpl(port);
            while (true) {
                Thread.sleep(Long.MAX_VALUE);
            }
        }
        catch (Exception ex) {
            log.error("Giving up, as server failed with:", (Throwable)ex);
            System.exit(0);
            return;
        }
    }

    public void startNonGui(CLOption testFile, CLOption logFile, CLOption remoteStart) throws IllegalUserActionException {
        System.setProperty("JMeter.NonGui", "true");
        JMeter driver = new JMeter();
        driver.parent = this;
        PluginManager.install(this, false);
        if (testFile == null) {
            throw new IllegalUserActionException();
        }
        if (logFile == null) {
            driver.run(testFile.getArgument(), null, remoteStart != null);
        } else {
            driver.run(testFile.getArgument(), logFile.getArgument(), remoteStart != null);
        }
    }

    private void run(String testFile, String logFile, boolean remoteStart) {
        FileInputStream reader = null;
        try {
            String summariserName;
            File f = new File(testFile);
            if (!f.exists() || !f.isFile()) {
                JMeter.println("Could not open " + testFile);
                return;
            }
            FileServer.getFileServer().setBasedir(f.getAbsolutePath());
            reader = new FileInputStream(f);
            log.info("Loading file: " + f);
            HashTree tree = SaveService.loadTree(reader);
            this.convertSubTree(tree);
            if (logFile != null) {
                ResultCollector logger = new ResultCollector();
                logger.setFilename(logFile);
                tree.add(tree.getArray()[0], (Object)logger);
            }
            if ((summariserName = JMeterUtils.getPropDefault("summariser.name", "")).length() > 0) {
                log.info("Creating summariser <" + summariserName + ">");
                JMeter.println("Creating summariser <" + summariserName + ">");
                Summariser summer = new Summariser(summariserName);
                tree.add(tree.getArray()[0], (Object)summer);
            }
            tree.add(tree.getArray()[0], (Object)new ListenToTest(this.parent));
            JMeter.println("Created the tree successfully");
            JMeterEngine engine = null;
            if (!remoteStart) {
                engine = new StandardJMeterEngine();
                engine.configure(tree);
                JMeter.println("Starting the test");
                engine.runTest();
            } else {
                String remote_hosts_string = JMeterUtils.getPropDefault("remote_hosts", "127.0.0.1");
                StringTokenizer st = new StringTokenizer(remote_hosts_string, ",");
                LinkedList<JMeterEngine> engines = new LinkedList<JMeterEngine>();
                while (st.hasMoreElements()) {
                    String el = (String)st.nextElement();
                    JMeter.println("Configuring remote engine for " + el);
                    engines.add(this.doRemoteInit(el.trim(), tree));
                }
                JMeter.println("Starting remote engines");
                Iterator iter = engines.iterator();
                while (iter.hasNext()) {
                    engine = (JMeterEngine)iter.next();
                    engine.runTest();
                }
                JMeter.println("Remote engines have been started");
            }
        }
        catch (Exception e) {
            System.out.println("Error in NonGUIDriver " + e.toString());
            log.error("", (Throwable)e);
        }
    }

    private void convertSubTree(HashTree tree) {
        Iterator iter = new LinkedList(tree.list()).iterator();
        while (iter.hasNext()) {
            TestElement item = (TestElement)iter.next();
            if (item.isEnabled()) {
                if (item instanceof TestPlan) {
                    TestPlan tp = (TestPlan)item;
                    tp.setFunctionalMode(tp.isFunctionalMode());
                    tp.setSerialized(tp.isSerialized());
                }
                this.convertSubTree(tree.getTree((Object)item));
                continue;
            }
            tree.remove((Object)item);
        }
    }

    private JMeterEngine doRemoteInit(String hostName, HashTree testTree) {
        ClientJMeterEngine engine = null;
        try {
            engine = new ClientJMeterEngine(hostName);
        }
        catch (Exception e) {
            log.fatalError("Failure connecting to remote host", (Throwable)e);
            System.exit(0);
        }
        engine.configure(testTree);
        return engine;
    }

    private static void println(String str) {
        System.out.println(str);
    }

    public String[][] getIconMappings() {
        String iconProp = JMeterUtils.getPropDefault("jmeter.icons", "org/apache/jmeter/images/icon.properties");
        Properties p = JMeterUtils.loadProperties(iconProp);
        if (p == null) {
            log.info(iconProp + " not found - using default icon set");
            return DEFAULT_ICONS;
        }
        log.info("Loaded icon properties from " + iconProp);
        String[][] iconlist = new String[p.size()][3];
        Enumeration<Object> pe = p.keys();
        int i = 0;
        while (pe.hasMoreElements()) {
            String key = (String)pe.nextElement();
            String[] icons = JOrphanUtils.split((String)p.getProperty(key), (String)" ");
            iconlist[i][0] = key;
            iconlist[i][1] = icons[0];
            if (icons.length > 1) {
                iconlist[i][2] = icons[1];
            }
            ++i;
        }
        return iconlist;
    }

    public String[][] getResourceBundles() {
        return new String[0][];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ListenToTest
    implements TestListener,
    Runnable,
    Remoteable {
        int started = 0;
        private JMeter _parent;

        private ListenToTest(JMeter parent) {
            this._parent = parent;
        }

        public synchronized void testEnded(String host) {
            --this.started;
            log.info("Remote host " + host + " finished");
            if (this.started == 0) {
                this.testEnded();
            }
        }

        public void testEnded() {
            Thread stopSoon = new Thread(this);
            stopSoon.start();
        }

        public synchronized void testStarted(String host) {
            ++this.started;
            log.info("Started remote host: " + host);
        }

        public void testStarted() {
            log.info(JMeterUtils.getResString("running_test"));
        }

        public void run() {
            JMeter.println("Tidying up ...");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            JMeter.println("... end of run");
            this._parent.testEnded = true;
        }

        public void testIterationStart(LoopIterationEvent event) {
        }
    }
}

