/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import junit.framework.TestCase;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.ObjectTableModel;
import org.apache.jorphan.reflect.Functor;

public class ArgumentsPanel
extends AbstractConfigGui
implements ActionListener {
    private JLabel tableLabel;
    private transient JTable table;
    protected transient ObjectTableModel tableModel;
    private JButton add;
    private JButton delete;
    private boolean standalone = true;
    private static final String ADD = "add";
    private static final String DELETE = "delete";
    public static final String COLUMN_NAMES_0 = JMeterUtils.getResString("name");
    public static final String COLUMN_NAMES_1 = JMeterUtils.getResString("value");
    static /* synthetic */ Class class$java$lang$String;

    public ArgumentsPanel() {
        this.tableLabel = new JLabel(JMeterUtils.getResString("user_defined_variables"));
        this.standalone = true;
        this.init();
    }

    public ArgumentsPanel(String label) {
        this.tableLabel = new JLabel(label);
        this.standalone = false;
        this.init();
    }

    public Collection getMenuCategories() {
        if (this.standalone) {
            return super.getMenuCategories();
        }
        return null;
    }

    public String getLabelResource() {
        return "user_defined_variables";
    }

    public TestElement createTestElement() {
        Arguments args = new Arguments();
        this.modifyTestElement(args);
        return args;
    }

    public void modifyTestElement(TestElement args) {
        this.stopTableEditing();
        Iterator modelData = this.tableModel.iterator();
        Arguments arguments = null;
        if (args instanceof Arguments) {
            arguments = (Arguments)args;
            arguments.clear();
            while (modelData.hasNext()) {
                Argument arg = (Argument)modelData.next();
                arg.setMetaData("=");
                arguments.addArgument(arg);
            }
        }
        this.configureTestElement(args);
    }

    public void configure(TestElement el) {
        super.configure(el);
        if (el instanceof Arguments) {
            this.tableModel.clearData();
            PropertyIterator iter = ((Arguments)el).iterator();
            while (iter.hasNext()) {
                Argument arg = (Argument)iter.next().getObjectValue();
                this.tableModel.addRow((Object)arg);
            }
        }
        this.checkDeleteStatus();
    }

    protected JTable getTable() {
        return this.table;
    }

    protected JLabel getTableLabel() {
        return this.tableLabel;
    }

    protected JButton getDeleteButton() {
        return this.delete;
    }

    protected JButton getAddButton() {
        return this.add;
    }

    protected void checkDeleteStatus() {
        if (this.tableModel.getRowCount() == 0) {
            this.delete.setEnabled(false);
        } else {
            this.delete.setEnabled(true);
        }
    }

    public void clear() {
        this.stopTableEditing();
        this.tableModel.clearData();
    }

    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(DELETE)) {
            this.deleteArgument();
        } else if (action.equals(ADD)) {
            this.addArgument();
        }
    }

    protected void deleteArgument() {
        int rowSelected;
        if (this.table.isEditing()) {
            TableCellEditor cellEditor = this.table.getCellEditor(this.table.getEditingRow(), this.table.getEditingColumn());
            cellEditor.cancelCellEditing();
        }
        if ((rowSelected = this.table.getSelectedRow()) >= 0) {
            this.tableModel.removeRow(rowSelected);
            this.tableModel.fireTableDataChanged();
            if (this.tableModel.getRowCount() == 0) {
                this.delete.setEnabled(false);
            } else {
                int rowToSelect = rowSelected;
                if (rowSelected >= this.tableModel.getRowCount()) {
                    rowToSelect = rowSelected - 1;
                }
                this.table.setRowSelectionInterval(rowToSelect, rowToSelect);
            }
        }
    }

    protected void addArgument() {
        this.stopTableEditing();
        this.tableModel.addRow(this.makeNewArgument());
        this.delete.setEnabled(true);
        int rowToSelect = this.tableModel.getRowCount() - 1;
        this.table.setRowSelectionInterval(rowToSelect, rowToSelect);
    }

    protected Object makeNewArgument() {
        return new Argument("", "");
    }

    protected void stopTableEditing() {
        if (this.table.isEditing()) {
            TableCellEditor cellEditor = this.table.getCellEditor(this.table.getEditingRow(), this.table.getEditingColumn());
            cellEditor.stopCellEditing();
        }
    }

    protected void initializeTableModel() {
        this.tableModel = new ObjectTableModel(new String[]{COLUMN_NAMES_0, COLUMN_NAMES_1}, new Functor[]{new Functor("getName"), new Functor("getValue")}, new Functor[]{new Functor("setName"), new Functor("setValue")}, new Class[]{class$java$lang$String == null ? (class$java$lang$String = ArgumentsPanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ArgumentsPanel.class$("java.lang.String")) : class$java$lang$String});
    }

    protected void sizeColumns(JTable table) {
    }

    private Component makeMainPanel() {
        this.initializeTableModel();
        this.table = new JTable((TableModel)this.tableModel);
        this.table.setSelectionMode(0);
        return this.makeScrollPane(this.table);
    }

    protected Component makeLabelPanel() {
        JPanel labelPanel = new JPanel(new FlowLayout(1));
        labelPanel.add(this.tableLabel);
        return labelPanel;
    }

    private JPanel makeButtonPanel() {
        this.add = new JButton(JMeterUtils.getResString(ADD));
        this.add.setActionCommand(ADD);
        this.add.setEnabled(true);
        this.delete = new JButton(JMeterUtils.getResString(DELETE));
        this.delete.setActionCommand(DELETE);
        this.checkDeleteStatus();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.add.addActionListener(this);
        this.delete.addActionListener(this);
        buttonPanel.add(this.add);
        buttonPanel.add(this.delete);
        return buttonPanel;
    }

    private void init() {
        JPanel p = this;
        if (this.standalone) {
            this.setLayout(new BorderLayout(0, 5));
            this.setBorder(this.makeBorder());
            this.add((Component)this.makeTitlePanel(), "North");
            p = new JPanel();
        }
        p.setLayout(new BorderLayout());
        p.add(this.makeLabelPanel(), "North");
        p.add(this.makeMainPanel(), "Center");
        p.add(Box.createVerticalStrut(70), "West");
        p.add((Component)this.makeButtonPanel(), "South");
        if (this.standalone) {
            this.add((Component)p, "Center");
        }
        this.table.revalidate();
        this.sizeColumns(this.table);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Test
    extends TestCase {
        public Test(String name) {
            super(name);
        }

        public void testArgumentCreation() throws Exception {
            ArgumentsPanel gui = new ArgumentsPanel();
            gui.tableModel.addRow((Object)new Argument());
            gui.tableModel.setValueAt((Object)"howdy", 0, 0);
            gui.tableModel.addRow((Object)new Argument());
            gui.tableModel.setValueAt((Object)"doody", 0, 1);
            Test.assertEquals((String)"=", (String)((Argument)((Arguments)gui.createTestElement()).getArguments().get(0).getObjectValue()).getMetaData());
        }
    }
}

