/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.io.Serializable;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.control.NextIsNullException;
import org.apache.jmeter.junit.JMeterTestCase;
import org.apache.jmeter.junit.stubs.TestSampler;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class WhileController
extends GenericController
implements Serializable {
    private static Logger log = LoggingManager.getLoggerForClass();
    private static final String CONDITION = "WhileController.condition";
    private static boolean testMode = false;
    private static boolean testModeResult = false;

    public boolean isDone() {
        return this.getSubControllers().size() == 0;
    }

    private boolean endOfLoop(boolean loopEnd) {
        boolean res;
        String cnd = this.getCondition();
        log.debug("Condition string:" + cnd);
        if (loopEnd && cnd.length() == 0 || "LAST".equalsIgnoreCase(cnd)) {
            if (testMode) {
                res = !testModeResult;
            } else {
                JMeterVariables threadVars = JMeterContextService.getContext().getVariables();
                res = "false".equalsIgnoreCase(threadVars.get("JMeterThread.last_sample_ok"));
            }
        } else {
            res = "false".equalsIgnoreCase(cnd);
        }
        log.debug("Condition value: " + res);
        return res;
    }

    protected Sampler nextIsNull() throws NextIsNullException {
        this.reInitialize();
        if (!this.endOfLoop(true)) {
            return super.next();
        }
        this.setDone(true);
        return null;
    }

    public Sampler next() {
        if (this.current != 0) {
            return super.next();
        }
        if (!this.endOfLoop(false)) {
            return super.next();
        }
        this.reInitialize();
        return null;
    }

    public void setCondition(String string) {
        log.debug("setCondition(" + string + ")");
        this.setProperty(new StringProperty(CONDITION, string));
    }

    public String getCondition() {
        String cnd = this.getPropertyAsString(CONDITION);
        log.debug("getCondition() => " + cnd);
        return cnd;
    }

    public static class Test
    extends JMeterTestCase {
        private static final String OTHER = "X";

        public Test(String name) {
            super(name);
        }

        private String nextName(GenericController c) {
            Sampler s = c.next();
            if (s == null) {
                return null;
            }
            return s.getPropertyAsString("TestElement.name");
        }

        public void testBlankPrevOK() throws Exception {
            log.info("testBlankPrevOK");
            this.runtestPrevOK("");
        }

        public void testLastPrevOK() throws Exception {
            log.info("testLASTPrevOK");
            this.runtestPrevOK("LAST");
        }

        public void testOtherPrevOK() throws Exception {
            log.info("testOtherPrevOK");
            this.runtestPrevOK(OTHER);
        }

        public void runtestPrevOK(String type) throws Exception {
            testMode = true;
            testModeResult = true;
            GenericController controller = new GenericController();
            WhileController while_cont = new WhileController();
            while_cont.setCondition(type);
            while_cont.addTestElement(new TestSampler("one"));
            while_cont.addTestElement(new TestSampler("two"));
            while_cont.addTestElement(new TestSampler("three"));
            controller.addTestElement(while_cont);
            controller.addTestElement(new TestSampler("four"));
            controller.initialize();
            Test.assertEquals((String)"one", (String)this.nextName(controller));
            Test.assertEquals((String)"two", (String)this.nextName(controller));
            Test.assertEquals((String)"three", (String)this.nextName(controller));
            Test.assertEquals((String)"one", (String)this.nextName(controller));
            Test.assertEquals((String)"two", (String)this.nextName(controller));
            Test.assertEquals((String)"three", (String)this.nextName(controller));
            Test.assertEquals((String)"one", (String)this.nextName(controller));
            testModeResult = false;
            if (type.equals(OTHER)) {
                while_cont.setCondition("false");
            }
            Test.assertEquals((String)"two", (String)this.nextName(controller));
            Test.assertEquals((String)"three", (String)this.nextName(controller));
            testModeResult = true;
            if (type.equals(OTHER)) {
                while_cont.setCondition(OTHER);
            }
            Test.assertEquals((String)"one", (String)this.nextName(controller));
            Test.assertEquals((String)"two", (String)this.nextName(controller));
            Test.assertEquals((String)"three", (String)this.nextName(controller));
            testModeResult = false;
            if (type.equals(OTHER)) {
                while_cont.setCondition("false");
            }
            Test.assertEquals((String)"four", (String)this.nextName(controller));
            Test.assertNull((Object)this.nextName(controller));
            testModeResult = true;
            if (type.equals(OTHER)) {
                while_cont.setCondition(OTHER);
            }
            Test.assertEquals((String)"one", (String)this.nextName(controller));
        }

        public void testBlankPrevFailed() throws Exception {
            log.info("testBlankPrevFailed");
            testMode = true;
            testModeResult = false;
            GenericController controller = new GenericController();
            WhileController while_cont = new WhileController();
            while_cont.setCondition("");
            while_cont.addTestElement(new TestSampler("one"));
            while_cont.addTestElement(new TestSampler("two"));
            controller.addTestElement(while_cont);
            controller.addTestElement(new TestSampler("three"));
            controller.initialize();
            Test.assertEquals((String)"one", (String)this.nextName(controller));
            Test.assertEquals((String)"two", (String)this.nextName(controller));
            Test.assertEquals((String)"three", (String)this.nextName(controller));
            Test.assertNull((Object)this.nextName(controller));
            Test.assertEquals((String)"one", (String)this.nextName(controller));
            Test.assertEquals((String)"two", (String)this.nextName(controller));
            Test.assertEquals((String)"three", (String)this.nextName(controller));
            Test.assertNull((Object)this.nextName(controller));
        }

        public void testLASTPrevFailed() throws Exception {
            log.info("testLastPrevFailed");
            this.runTestPrevFailed("LAST");
        }

        public void testfalsePrevFailed() throws Exception {
            log.info("testFalsePrevFailed");
            this.runTestPrevFailed("False");
        }

        public void runTestPrevFailed(String s) throws Exception {
            testMode = true;
            testModeResult = false;
            GenericController controller = new GenericController();
            WhileController while_cont = new WhileController();
            while_cont.setCondition(s);
            while_cont.addTestElement(new TestSampler("one"));
            while_cont.addTestElement(new TestSampler("two"));
            controller.addTestElement(while_cont);
            controller.addTestElement(new TestSampler("three"));
            controller.initialize();
            Test.assertEquals((String)"three", (String)this.nextName(controller));
            Test.assertNull((Object)this.nextName(controller));
            Test.assertEquals((String)"three", (String)this.nextName(controller));
            Test.assertNull((Object)this.nextName(controller));
        }

        public void testAlwaysFailOK() throws Exception {
            this.runTestAlwaysFail(true);
        }

        public void disabletestAlwaysFailBAD() throws Exception {
            this.runTestAlwaysFail(false);
        }

        public void runTestAlwaysFail(boolean other) {
            testMode = true;
            testModeResult = false;
            LoopController controller = new LoopController();
            controller.setContinueForever(true);
            controller.setLoops(-1);
            WhileController while_cont = new WhileController();
            while_cont.setCondition("false");
            while_cont.addTestElement(new TestSampler("one"));
            while_cont.addTestElement(new TestSampler("two"));
            controller.addTestElement(while_cont);
            if (other) {
                controller.addTestElement(new TestSampler("three"));
            }
            controller.initialize();
            try {
                if (other) {
                    Test.assertEquals((String)"three", (String)this.nextName(controller));
                } else {
                    Test.assertNull((Object)this.nextName(controller));
                }
            }
            catch (StackOverflowError e) {
                Test.fail((String)e.toString());
            }
        }
    }
}

