/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.engine.util;

import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.Function;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.testelement.TestListener;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

class FunctionParser {
    Logger log = LoggingManager.getLoggerForClass();

    FunctionParser() {
    }

    LinkedList compileString(String value) throws InvalidVariableException {
        StringReader reader = new StringReader(value);
        LinkedList<Object> result = new LinkedList<Object>();
        StringBuffer buffer = new StringBuffer();
        int previous = 32;
        char[] current = new char[1];
        try {
            while (reader.read(current) == 1) {
                if (current[0] == '\\') {
                    previous = current[0];
                    if (reader.read(current) == 0) break;
                    if (current[0] != '$' && current[0] != ',' && current[0] != '\\') {
                        buffer.append((char)previous);
                    }
                    previous = 32;
                    buffer.append(current[0]);
                    continue;
                }
                if (current[0] == '{' && previous == 36) {
                    buffer.deleteCharAt(buffer.length() - 1);
                    if (buffer.length() > 0) {
                        result.add(buffer.toString());
                        buffer.setLength(0);
                    }
                    result.add(this.makeFunction(reader));
                    previous = 32;
                    continue;
                }
                buffer.append(current[0]);
                previous = current[0];
            }
            if (buffer.length() > 0) {
                result.add(buffer.toString());
            }
        }
        catch (IOException e) {
            this.log.error("Error parsing function: " + value, (Throwable)e);
            result.clear();
            result.add(value);
        }
        if (result.size() == 0) {
            result.add("");
        }
        return result;
    }

    Object makeFunction(StringReader reader) throws InvalidVariableException {
        char[] current = new char[1];
        int previous = 32;
        StringBuffer buffer = new StringBuffer();
        try {
            while (reader.read(current) == 1) {
                Object function;
                if (current[0] == '\\') {
                    if (reader.read(current) != 0) {
                        previous = 32;
                        buffer.append(current[0]);
                        continue;
                    }
                    break;
                }
                if (current[0] == '(' && previous != 32) {
                    function = CompoundVariable.getNamedFunction(buffer.toString());
                    buffer.setLength(0);
                    if (!(function instanceof Function)) continue;
                    ((Function)function).setParameters(this.parseParams(reader));
                    if (reader.read(current) == 0 || current[0] != '}') {
                        throw new InvalidVariableException();
                    }
                    if (function instanceof TestListener) {
                        StandardJMeterEngine.register((TestListener)function);
                    }
                    return function;
                }
                if (current[0] == '}') {
                    function = CompoundVariable.getNamedFunction(buffer.toString());
                    buffer.setLength(0);
                    return function;
                }
                buffer.append(current[0]);
                previous = current[0];
            }
        }
        catch (IOException e) {
            this.log.error("Error parsing function: " + buffer.toString(), (Throwable)e);
            return null;
        }
        this.log.warn("Probably an invalid function string: " + buffer.toString());
        return buffer.toString();
    }

    LinkedList parseParams(StringReader reader) throws InvalidVariableException {
        LinkedList<CompoundVariable> result = new LinkedList<CompoundVariable>();
        StringBuffer buffer = new StringBuffer();
        char[] current = new char[1];
        int previous = 32;
        int functionRecursion = 0;
        int parenRecursion = 0;
        try {
            while (reader.read(current) == 1) {
                CompoundVariable param;
                if (current[0] == '\\') {
                    buffer.append(current[0]);
                    if (reader.read(current) != 0) {
                        previous = 32;
                        buffer.append(current[0]);
                        continue;
                    }
                    break;
                }
                if (current[0] == ',' && functionRecursion == 0) {
                    param = new CompoundVariable();
                    param.setParameters(buffer.toString());
                    buffer.setLength(0);
                    result.add(param);
                    continue;
                }
                if (current[0] == ')' && functionRecursion == 0 && parenRecursion == 0) {
                    param = new CompoundVariable();
                    param.setParameters(buffer.toString());
                    buffer.setLength(0);
                    result.add(param);
                    return result;
                }
                if (current[0] == '{' && previous == 36) {
                    buffer.append(current[0]);
                    previous = current[0];
                    ++functionRecursion;
                    continue;
                }
                if (current[0] == '}' && functionRecursion > 0) {
                    buffer.append(current[0]);
                    previous = current[0];
                    --functionRecursion;
                    continue;
                }
                if (current[0] == ')' && functionRecursion == 0 && parenRecursion > 0) {
                    buffer.append(current[0]);
                    previous = current[0];
                    --parenRecursion;
                    continue;
                }
                if (current[0] == '(' && functionRecursion == 0) {
                    buffer.append(current[0]);
                    previous = current[0];
                    ++parenRecursion;
                    continue;
                }
                buffer.append(current[0]);
                previous = current[0];
            }
        }
        catch (IOException e) {
            this.log.error("Error parsing function: " + buffer.toString(), (Throwable)e);
        }
        this.log.warn("Probably an invalid function string: " + buffer.toString());
        CompoundVariable var = new CompoundVariable();
        var.setParameters(buffer.toString());
        result.add(var);
        return result;
    }
}

