/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.engine.util;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.engine.util.ReplaceStringWithFunctions;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;

public class PackageTest
extends TestCase {
    Map variables;
    SampleResult result;
    ReplaceStringWithFunctions transformer;
    private JMeterContext jmctx = null;

    public PackageTest(String arg0) {
        super(arg0);
    }

    public void setUp() {
        this.jmctx = JMeterContextService.getContext();
        this.variables = new HashMap();
        this.variables.put("my_regex", ".*");
        this.variables.put("server", "jakarta.apache.org");
        this.result = new SampleResult();
        this.result.setResponseData("<html>hello world</html> costs: $3.47,$5.67".getBytes());
        this.transformer = new ReplaceStringWithFunctions(new CompoundVariable(), this.variables);
        this.jmctx.setVariables(new JMeterVariables());
        this.jmctx.setSamplingStarted(true);
        this.jmctx.setPreviousResult(this.result);
        this.jmctx.getVariables().put("server", "jakarta.apache.org");
        this.jmctx.getVariables().put("my_regex", ".*");
    }

    public void testFunctionParse1() throws Exception {
        StringProperty prop = new StringProperty("date", "${__javaScript((new Date().getDate() / 100).toString().substr(${__javaScript(1+1,d\\,ay)}\\,2),heute)}");
        JMeterProperty newProp = this.transformer.transformValue(prop);
        newProp.setRunningVersion(true);
        PackageTest.assertEquals((String)"org.apache.jmeter.testelement.property.FunctionProperty", (String)newProp.getClass().getName());
        newProp.recoverRunningVersion(null);
        PackageTest.assertTrue((Integer.parseInt(newProp.getStringValue()) > -1 ? 1 : 0) != 0);
        PackageTest.assertEquals((Object)"2", (Object)this.jmctx.getVariables().getObject("d,ay"));
    }

    public void testParseExample1() throws Exception {
        StringProperty prop = new StringProperty("html", "${__regexFunction(<html>(.*)</html>,$1$)}");
        JMeterProperty newProp = this.transformer.transformValue(prop);
        newProp.setRunningVersion(true);
        PackageTest.assertEquals((String)"org.apache.jmeter.testelement.property.FunctionProperty", (String)newProp.getClass().getName());
        PackageTest.assertEquals((String)"hello world", (String)newProp.getStringValue());
    }

    public void testParseExample2() throws Exception {
        StringProperty prop = new StringProperty("html", "It should say:\\${${__regexFunction(<html>(.*)</html>,$1$)}}");
        JMeterProperty newProp = this.transformer.transformValue(prop);
        newProp.setRunningVersion(true);
        PackageTest.assertEquals((String)"org.apache.jmeter.testelement.property.FunctionProperty", (String)newProp.getClass().getName());
        PackageTest.assertEquals((String)"It should say:${hello world}", (String)newProp.getStringValue());
    }

    public void testParseExample3() throws Exception {
        StringProperty prop = new StringProperty("html", "${__regexFunction(<html>(.*)</html>,$1$)}${__regexFunction(<html>(.*o)(.*o)(.*)</html>,$1$$3$)}");
        JMeterProperty newProp = this.transformer.transformValue(prop);
        newProp.setRunningVersion(true);
        PackageTest.assertEquals((String)"org.apache.jmeter.testelement.property.FunctionProperty", (String)newProp.getClass().getName());
        PackageTest.assertEquals((String)"hello worldhellorld", (String)newProp.getStringValue());
    }

    public void testParseExample4() throws Exception {
        StringProperty prop = new StringProperty("html", "${non-existing function}");
        JMeterProperty newProp = this.transformer.transformValue(prop);
        newProp.setRunningVersion(true);
        PackageTest.assertEquals((String)"org.apache.jmeter.testelement.property.FunctionProperty", (String)newProp.getClass().getName());
        PackageTest.assertEquals((String)"${non-existing function}", (String)newProp.getStringValue());
    }

    public void testParseExample6() throws Exception {
        StringProperty prop = new StringProperty("html", "${server}");
        JMeterProperty newProp = this.transformer.transformValue(prop);
        newProp.setRunningVersion(true);
        PackageTest.assertEquals((String)"org.apache.jmeter.testelement.property.FunctionProperty", (String)newProp.getClass().getName());
        PackageTest.assertEquals((String)"jakarta.apache.org", (String)newProp.getStringValue());
    }

    public void testParseExample5() throws Exception {
        StringProperty prop = new StringProperty("html", "");
        JMeterProperty newProp = this.transformer.transformValue(prop);
        newProp.setRunningVersion(true);
        PackageTest.assertEquals((String)"org.apache.jmeter.testelement.property.StringProperty", (String)newProp.getClass().getName());
        PackageTest.assertEquals((String)"", (String)newProp.getStringValue());
    }

    public void testParseExample7() throws Exception {
        StringProperty prop = new StringProperty("html", "${__regexFunction(\\<([a-z]*)\\>,$1$)}");
        JMeterProperty newProp = this.transformer.transformValue(prop);
        newProp.setRunningVersion(true);
        PackageTest.assertEquals((String)"org.apache.jmeter.testelement.property.FunctionProperty", (String)newProp.getClass().getName());
        PackageTest.assertEquals((String)"html", (String)newProp.getStringValue());
    }

    public void testParseExample8() throws Exception {
        StringProperty prop = new StringProperty("html", "${__regexFunction((\\\\$\\d+\\.\\d+),$1$)}");
        JMeterProperty newProp = this.transformer.transformValue(prop);
        newProp.setRunningVersion(true);
        PackageTest.assertEquals((String)"org.apache.jmeter.testelement.property.FunctionProperty", (String)newProp.getClass().getName());
        PackageTest.assertEquals((String)"$3.47", (String)newProp.getStringValue());
    }

    public void testParseExample9() throws Exception {
        StringProperty prop = new StringProperty("html", "${__regexFunction(([$]\\d+\\.\\d+),$1$)}");
        JMeterProperty newProp = this.transformer.transformValue(prop);
        newProp.setRunningVersion(true);
        PackageTest.assertEquals((String)"org.apache.jmeter.testelement.property.FunctionProperty", (String)newProp.getClass().getName());
        PackageTest.assertEquals((String)"$3.47", (String)newProp.getStringValue());
    }

    public void testParseExample10() throws Exception {
        StringProperty prop = new StringProperty("html", "${__regexFunction(\\ (\\\\\\$\\d+\\.\\d+\\,\\\\$\\d+\\.\\d+),$1$)}");
        JMeterProperty newProp = this.transformer.transformValue(prop);
        newProp.setRunningVersion(true);
        PackageTest.assertEquals((String)"org.apache.jmeter.testelement.property.FunctionProperty", (String)newProp.getClass().getName());
        PackageTest.assertEquals((String)"$3.47,$5.67", (String)newProp.getStringValue());
    }

    public void testNestedExample1() throws Exception {
        StringProperty prop = new StringProperty("html", "${__regexFunction(<html>(${my_regex})</html>,$1$)}${__regexFunction(<html>(.*o)(.*o)(.*)</html>,$1$$3$)}");
        JMeterProperty newProp = this.transformer.transformValue(prop);
        newProp.setRunningVersion(true);
        PackageTest.assertEquals((String)"org.apache.jmeter.testelement.property.FunctionProperty", (String)newProp.getClass().getName());
        PackageTest.assertEquals((String)"hello worldhellorld", (String)newProp.getStringValue());
    }

    public void testNestedExample2() throws Exception {
        StringProperty prop = new StringProperty("html", "${__regexFunction(<html>(${my_regex})</html>,$1$)}");
        JMeterProperty newProp = this.transformer.transformValue(prop);
        newProp.setRunningVersion(true);
        PackageTest.assertEquals((String)"org.apache.jmeter.testelement.property.FunctionProperty", (String)newProp.getClass().getName());
        PackageTest.assertEquals((String)"hello world", (String)newProp.getStringValue());
    }
}

