/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.engine.util;

import java.util.Iterator;
import java.util.Map;
import org.apache.jmeter.engine.util.AbstractTransformer;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.util.StringUtilities;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.StringSubstitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;

public class ReplaceFunctionsWithStrings
extends AbstractTransformer {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private boolean regexMatch;

    public ReplaceFunctionsWithStrings(CompoundVariable masterFunction, Map variables) {
        this(masterFunction, variables, false);
    }

    public ReplaceFunctionsWithStrings(CompoundVariable masterFunction, Map variables, boolean regexMatch) {
        this.setMasterFunction(masterFunction);
        this.setVariables(variables);
        this.regexMatch = regexMatch;
    }

    public JMeterProperty transformValue(JMeterProperty prop) throws InvalidVariableException {
        Perl5Matcher pm = new Perl5Matcher();
        Pattern pattern = null;
        Perl5Compiler compiler = new Perl5Compiler();
        Iterator iter = this.getVariables().keySet().iterator();
        String input = prop.getStringValue();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = (String)this.getVariables().get(key);
            if (this.regexMatch) {
                try {
                    pattern = compiler.compile(value);
                    input = Util.substitute((PatternMatcher)pm, (Pattern)pattern, (Substitution)new StringSubstitution("${" + key + "}"), (String)input, (int)-1);
                }
                catch (MalformedPatternException e) {
                    log.warn("Malformed pattern " + value);
                }
                continue;
            }
            input = StringUtilities.substitute(input, value, "${" + key + "}");
        }
        StringProperty newProp = new StringProperty(prop.getName(), input);
        return newProp;
    }
}

