/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.GlobalMouseListener;
import org.apache.jmeter.gui.tree.JMeterCellRenderer;
import org.apache.jmeter.gui.tree.JMeterTreeListener;
import org.apache.jmeter.gui.util.JMeterMenuBar;
import org.apache.jmeter.samplers.Remoteable;
import org.apache.jmeter.testelement.TestListener;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.ComponentUtil;

public class MainFrame
extends JFrame
implements TestListener,
Remoteable {
    private JMeterMenuBar menuBar;
    private JScrollPane mainPanel;
    private JScrollPane treePanel;
    private JTree tree;
    private ImageIcon runningIcon = JMeterUtils.getImage("thread.enabled.gif");
    private ImageIcon stoppedIcon = JMeterUtils.getImage("thread.disabled.gif");
    private JButton runningIndicator;
    private int previousDragXLocation = 0;
    private int previousDragYLocation = 0;
    private Set hosts = new HashSet();
    private JDialog stoppingMessage;

    public MainFrame(ActionListener actionHandler, TreeModel treeModel, JMeterTreeListener treeListener) {
        this.runningIndicator = new JButton(this.stoppedIcon);
        this.runningIndicator.setMargin(new Insets(0, 0, 0, 0));
        this.runningIndicator.setBorder(BorderFactory.createEmptyBorder());
        this.tree = this.makeTree(treeModel, treeListener);
        GuiPackage.getInstance().setMainFrame(this);
        this.init();
        this.setDefaultCloseOperation(0);
    }

    public MainFrame() {
    }

    public void setFileLoadEnabled(boolean enabled) {
        this.menuBar.setFileLoadEnabled(enabled);
    }

    public void setFileSaveEnabled(boolean enabled) {
        this.menuBar.setFileSaveEnabled(enabled);
    }

    public void setEditMenu(JPopupMenu menu) {
        this.menuBar.setEditMenu(menu);
    }

    public void setEditEnabled(boolean enabled) {
        this.menuBar.setEditEnabled(enabled);
    }

    public void setEditAddMenu(JMenu menu) {
        this.menuBar.setEditAddMenu(menu);
    }

    public void setEditAddEnabled(boolean enabled) {
        this.menuBar.setEditAddEnabled(enabled);
    }

    public void setEditRemoveEnabled(boolean enabled) {
        this.menuBar.setEditRemoveEnabled(enabled);
    }

    public void closeMenu() {
        MenuElement[] menuElement;
        if (this.menuBar.isSelected() && (menuElement = this.menuBar.getSubElements()) != null) {
            for (int i = 0; i < menuElement.length; ++i) {
                JMenu menu = (JMenu)menuElement[i];
                if (!menu.isSelected()) continue;
                menu.setPopupMenuVisible(false);
                menu.setSelected(false);
                break;
            }
        }
    }

    public void showStoppingMessage(String host) {
        this.stoppingMessage = new JDialog(this, JMeterUtils.getResString("stopping_test_title"), true);
        JLabel stopLabel = new JLabel(JMeterUtils.getResString("stopping_test") + ": " + host);
        stopLabel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.stoppingMessage.getContentPane().add(stopLabel);
        this.stoppingMessage.pack();
        ComponentUtil.centerComponentInComponent((Component)this, (Component)this.stoppingMessage);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (MainFrame.this.stoppingMessage != null) {
                    MainFrame.this.stoppingMessage.show();
                }
            }
        });
    }

    public void setMainPanel(JComponent comp) {
        this.mainPanel.setViewportView(comp);
    }

    public JTree getTree() {
        return this.tree;
    }

    public void testStarted() {
        this.testStarted("local");
        this.menuBar.setEnabled(true);
    }

    public void testStarted(String host) {
        this.hosts.add(host);
        this.runningIndicator.setIcon(this.runningIcon);
        this.menuBar.setRunning(true, host);
    }

    public void testEnded() {
        this.testEnded("local");
        this.menuBar.setEnabled(false);
    }

    public void testEnded(String host) {
        this.hosts.remove(host);
        if (this.hosts.size() == 0) {
            this.runningIndicator.setIcon(this.stoppedIcon);
            JMeterContextService.endTest();
        }
        this.menuBar.setRunning(false, host);
        if (this.stoppingMessage != null) {
            this.stoppingMessage.dispose();
            this.stoppingMessage = null;
        }
    }

    public void testIterationStart(LoopIterationEvent event) {
    }

    private void init() {
        this.menuBar = new JMeterMenuBar();
        this.setJMenuBar(this.menuBar);
        JPanel all = new JPanel(new BorderLayout());
        all.add(this.createToolBar(), "North");
        JSplitPane treeAndMain = new JSplitPane(1);
        this.treePanel = this.createTreePanel();
        treeAndMain.setLeftComponent(this.treePanel);
        this.mainPanel = this.createMainPanel();
        treeAndMain.setRightComponent(this.mainPanel);
        treeAndMain.setResizeWeight(0.2);
        treeAndMain.setContinuousLayout(true);
        all.add((Component)treeAndMain, "Center");
        this.getContentPane().add(all);
        this.tree.setSelectionRow(1);
        this.addWindowListener(new WindowHappenings());
        this.addMouseListener(new GlobalMouseListener());
    }

    private Component createToolBar() {
        Box toolPanel = new Box(0);
        toolPanel.add(Box.createRigidArea(new Dimension(10, 15)));
        toolPanel.add(Box.createGlue());
        toolPanel.add(this.runningIndicator);
        return toolPanel;
    }

    private JScrollPane createTreePanel() {
        JScrollPane treeP = new JScrollPane(this.tree);
        treeP.setMinimumSize(new Dimension(100, 0));
        return treeP;
    }

    private JScrollPane createMainPanel() {
        return new JScrollPane();
    }

    private JTree makeTree(TreeModel treeModel, JMeterTreeListener treeListener) {
        JTree treevar = new JTree(treeModel);
        treevar.setCellRenderer(this.getCellRenderer());
        treevar.setRootVisible(false);
        treevar.setShowsRootHandles(true);
        treeListener.setJTree(treevar);
        treevar.addTreeSelectionListener(treeListener);
        treevar.addMouseListener(treeListener);
        treevar.addMouseMotionListener(treeListener);
        treevar.addKeyListener(treeListener);
        return treevar;
    }

    private TreeCellRenderer getCellRenderer() {
        JMeterCellRenderer rend = new JMeterCellRenderer();
        rend.setFont(new Font("Dialog", 0, 11));
        return rend;
    }

    public void drawDraggedComponent(Component dragIcon, int x, int y) {
        Dimension size = dragIcon.getPreferredSize();
        this.treePanel.paintImmediately(this.previousDragXLocation, this.previousDragYLocation, size.width, size.height);
        this.getLayeredPane().setLayer(dragIcon, 400);
        SwingUtilities.paintComponent(this.treePanel.getGraphics(), dragIcon, this.treePanel, x, y, size.width, size.height);
        this.previousDragXLocation = x;
        this.previousDragYLocation = y;
    }

    private class WindowHappenings
    extends WindowAdapter {
        private WindowHappenings() {
        }

        public void windowClosing(WindowEvent event) {
            ActionRouter.getInstance().actionPerformed(new ActionEvent(this, event.getID(), "exit"));
        }
    }
}

