/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.collections.ListedHashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class CheckDirty
extends AbstractAction
implements HashTreeTraverser,
ActionListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static Map previousGuiItems;
    public static final String CHECK_DIRTY = "check_dirty";
    public static final String SUB_TREE_SAVED = "sub_tree_saved";
    public static final String SUB_TREE_LOADED = "sub_tree_loaded";
    public static final String ADD_ALL = "add_all";
    public static final String REMOVE = "check_remove";
    boolean checkMode = false;
    boolean removeMode = false;
    boolean dirty = false;
    private static Set commands;
    static /* synthetic */ Class class$org$apache$jmeter$gui$action$ExitCommand;

    public CheckDirty() {
        previousGuiItems = new HashMap();
        ActionRouter.getInstance().addPreActionListener(class$org$apache$jmeter$gui$action$ExitCommand == null ? (class$org$apache$jmeter$gui$action$ExitCommand = CheckDirty.class$("org.apache.jmeter.gui.action.ExitCommand")) : class$org$apache$jmeter$gui$action$ExitCommand, this);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("exit")) {
            this.doAction(e);
        }
    }

    public void doAction(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(SUB_TREE_SAVED)) {
            HashTree subTree = (HashTree)e.getSource();
            subTree.traverse((HashTreeTraverser)this);
        } else if (action.equals(SUB_TREE_LOADED)) {
            ListedHashTree addTree = (ListedHashTree)e.getSource();
            addTree.traverse((HashTreeTraverser)this);
        } else if (action.equals(ADD_ALL)) {
            previousGuiItems.clear();
            GuiPackage.getInstance().getTreeModel().getTestPlan().traverse((HashTreeTraverser)this);
        } else if (action.equals(REMOVE)) {
            GuiPackage guiPackage = GuiPackage.getInstance();
            JMeterTreeNode[] nodes = guiPackage.getTreeListener().getSelectedNodes();
            this.removeMode = true;
            for (int i = nodes.length - 1; i >= 0; --i) {
                guiPackage.getTreeModel().getCurrentSubTree(nodes[i]).traverse((HashTreeTraverser)this);
            }
            this.removeMode = false;
        }
        this.checkMode = true;
        this.dirty = false;
        HashTree wholeTree = GuiPackage.getInstance().getTreeModel().getTestPlan();
        wholeTree.traverse((HashTreeTraverser)this);
        GuiPackage.getInstance().setDirty(this.dirty);
        this.checkMode = false;
    }

    public void addNode(Object node, HashTree subTree) {
        log.debug("Node is class:" + node.getClass());
        JMeterTreeNode treeNode = (JMeterTreeNode)node;
        if (this.checkMode) {
            if (previousGuiItems.containsKey(treeNode)) {
                if (!previousGuiItems.get(treeNode).equals(treeNode.getTestElement())) {
                    this.dirty = true;
                }
            } else {
                this.dirty = true;
            }
        } else if (this.removeMode) {
            previousGuiItems.remove(treeNode);
        } else {
            previousGuiItems.put(treeNode, treeNode.getTestElement().clone());
        }
    }

    public void subtractNode() {
    }

    public void processPath() {
    }

    public Set getActionNames() {
        return commands;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        commands = new HashSet();
        commands.add(CHECK_DIRTY);
        commands.add(SUB_TREE_SAVED);
        commands.add(SUB_TREE_LOADED);
        commands.add(ADD_ALL);
        commands.add(REMOVE);
    }
}

