/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.tree.JMeterTreeListener;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.testelement.WorkBench;

public class DragNDrop
extends AbstractAction {
    public static final String ADD = "drag_n_drop.add";
    public static final String INSERT_BEFORE = "drag_n_drop.insert_before";
    public static final String INSERT_AFTER = "drag_n_drop.insert_after";
    private static Set commands = new HashSet();

    public void doAction(ActionEvent e) {
        String action = e.getActionCommand();
        GuiPackage guiPackage = GuiPackage.getInstance();
        JMeterTreeNode[] draggedNodes = guiPackage.getTreeListener().getDraggedNodes();
        JMeterTreeListener treeListener = guiPackage.getTreeListener();
        JMeterTreeNode currentNode = treeListener.getCurrentNode();
        JMeterTreeNode parentNode = (JMeterTreeNode)currentNode.getParent();
        TestElement te = currentNode.getTestElement();
        if (te instanceof TestPlan || te instanceof WorkBench) {
            parentNode = null;
        }
        if (ADD.equals(action) && DragNDrop.canAddTo(currentNode)) {
            this.removeNodesFromParents(draggedNodes);
            for (int i = 0; i < draggedNodes.length; ++i) {
                GuiPackage.getInstance().getTreeModel().insertNodeInto(draggedNodes[i], currentNode, currentNode.getChildCount());
            }
        } else if (INSERT_BEFORE.equals(action) && DragNDrop.canAddTo(parentNode)) {
            this.removeNodesFromParents(draggedNodes);
            for (int i = 0; i < draggedNodes.length; ++i) {
                int index = parentNode.getIndex(currentNode);
                GuiPackage.getInstance().getTreeModel().insertNodeInto(draggedNodes[i], parentNode, index);
            }
        } else if (INSERT_AFTER.equals(action) && DragNDrop.canAddTo(parentNode)) {
            this.removeNodesFromParents(draggedNodes);
            for (int i = 0; i < draggedNodes.length; ++i) {
                int index = parentNode.getIndex(currentNode) + 1;
                GuiPackage.getInstance().getTreeModel().insertNodeInto(draggedNodes[i], parentNode, index);
            }
        }
        GuiPackage.getInstance().getMainFrame().repaint();
    }

    static boolean canAddTo(JMeterTreeNode parentNode) {
        if (null == parentNode) {
            return false;
        }
        TestElement te = parentNode.getTestElement();
        if (te instanceof Controller) {
            return true;
        }
        if (te instanceof Sampler) {
            return true;
        }
        if (te instanceof WorkBench) {
            return true;
        }
        return te instanceof TestPlan;
    }

    protected void removeNodesFromParents(JMeterTreeNode[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            GuiPackage.getInstance().getTreeModel().removeNodeFromParent(nodes[i]);
        }
    }

    public Set getActionNames() {
        return commands;
    }

    static {
        commands.add(ADD);
        commands.add(INSERT_BEFORE);
        commands.add(INSERT_AFTER);
    }
}

