/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class EnableComponent
implements Command {
    private static Logger log = LoggingManager.getLoggerForClass();
    public static final String ENABLE = "enable";
    public static final String DISABLE = "disable";
    private static Set commands = new HashSet();

    public void doAction(ActionEvent e) {
        JMeterTreeNode[] nodes = GuiPackage.getInstance().getTreeListener().getSelectedNodes();
        if (e.getActionCommand().equals(ENABLE)) {
            log.debug("enabling currently selected gui objects");
            this.enableComponents(nodes, true);
        } else if (e.getActionCommand().equals(DISABLE)) {
            log.debug("disabling currently selected gui objects");
            this.enableComponents(nodes, false);
        }
    }

    private void enableComponents(JMeterTreeNode[] nodes, boolean enable) {
        GuiPackage pack = GuiPackage.getInstance();
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i].setEnabled(enable);
            pack.getGui(nodes[i].getTestElement()).setEnabled(enable);
        }
    }

    public Set getActionNames() {
        return commands;
    }

    static {
        commands.add(ENABLE);
        commands.add(DISABLE);
    }
}

