/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import junit.framework.TestCase;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.save.SaveGraphicsService;
import org.apache.jmeter.visualizers.Printable;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class SaveGraphics
implements Command {
    private static transient Logger log = LoggingManager.getLoggerForClass();
    public static final String SAVE_GRAPHICS = "save_graphics";
    private static Set commands = new HashSet();
    public static String[] extensions;

    public Set getActionNames() {
        return commands;
    }

    public void doAction(ActionEvent e) throws IllegalUserActionException {
        JMeterGUIComponent component = null;
        JComponent comp = null;
        if (!commands.contains(e.getActionCommand())) {
            throw new IllegalUserActionException("Invalid user command:" + e.getActionCommand());
        }
        if (e.getActionCommand().equals(SAVE_GRAPHICS) && (component = GuiPackage.getInstance().getCurrentGui()) instanceof Printable) {
            comp = ((Printable)((Object)component)).getPrintableComponent();
            JFileChooser chooser = FileDialoger.promptToSaveFile(GuiPackage.getInstance().getTreeListener().getCurrentNode().getName(), extensions);
            if (chooser == null) {
                return;
            }
            String filename = chooser.getSelectedFile().getAbsolutePath();
            if (filename != null) {
                SaveGraphicsService save = new SaveGraphicsService();
                String ext = filename.substring(filename.length() - 4);
                String name = filename.substring(0, filename.length() - 4);
                if (ext.equals(".png")) {
                    save.saveJComponent(name, 0, comp);
                } else if (ext.equals(".tif")) {
                    save.saveJComponent(name, 1, comp);
                } else {
                    save.saveJComponent(filename, 0, comp);
                }
            }
        }
    }

    static {
        commands.add(SAVE_GRAPHICS);
        extensions = new String[]{".tif", ".png"};
    }

    public static class Test
    extends TestCase {
        SaveGraphics save;

        public Test(String name) {
            super(name);
        }

        public void setUp() {
            this.save = new SaveGraphics();
        }

        public void testSomething() {
        }
    }
}

